/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.EXPERIMENTAL, since="5.10")
public abstract class AnnotationBasedArgumentsProvider<A extends Annotation>
implements ArgumentsProvider,
AnnotationConsumer<A> {
    private final List<A> annotations = new ArrayList<A>();

    @Override
    public final void accept(A annotation) {
        Preconditions.notNull(annotation, "annotation must not be null");
        this.annotations.add(annotation);
    }

    @Override
    public final Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        return this.annotations.stream().flatMap(annotation -> this.provideArguments(context, annotation));
    }

    protected abstract Stream<? extends Arguments> provideArguments(ExtensionContext var1, A var2);
}

