/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.text.StrLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
class StrLookupTest {
    StrLookupTest() {
    }

    @Test
    void testMapLookup() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", "value");
        map.put("number", 2);
        Assertions.assertEquals((Object)"value", (Object)StrLookup.mapLookup(map).apply("key"));
        Assertions.assertEquals((Object)"2", (Object)StrLookup.mapLookup(map).apply("number"));
        Assertions.assertNull((Object)StrLookup.mapLookup(map).apply(null));
        Assertions.assertNull((Object)StrLookup.mapLookup(map).apply(""));
        Assertions.assertNull((Object)StrLookup.mapLookup(map).apply("other"));
    }

    @Test
    void testMapLookup_nullMap() {
        Map map = null;
        Assertions.assertNull((Object)StrLookup.mapLookup(map).apply(null));
        Assertions.assertNull((Object)StrLookup.mapLookup(map).apply(""));
        Assertions.assertNull((Object)StrLookup.mapLookup(map).apply("any"));
    }

    @Test
    void testNoneLookup() {
        Assertions.assertNull((Object)StrLookup.noneLookup().apply(null));
        Assertions.assertNull((Object)StrLookup.noneLookup().apply(""));
        Assertions.assertNull((Object)StrLookup.noneLookup().apply("any"));
    }

    @Test
    void testResourceBundleLookup() {
        ResourceBundle map = ResourceBundle.getBundle("org.apache.commons.text.example.testResourceBundleLookup");
        Assertions.assertEquals((Object)"value", (Object)StrLookup.resourceBundleLookup((ResourceBundle)map).apply("key"));
        Assertions.assertEquals((Object)"2", (Object)StrLookup.resourceBundleLookup((ResourceBundle)map).lookup("number"));
        Assertions.assertNull((Object)StrLookup.resourceBundleLookup((ResourceBundle)map).apply(null));
        Assertions.assertNull((Object)StrLookup.resourceBundleLookup((ResourceBundle)map).apply(""));
        Assertions.assertNull((Object)StrLookup.resourceBundleLookup((ResourceBundle)map).apply("other"));
    }

    @Test
    void testResourceBundleLookup_nullMap() {
        ResourceBundle resourceBundle = null;
        Assertions.assertNull((Object)StrLookup.resourceBundleLookup(resourceBundle).apply(null));
        Assertions.assertNull((Object)StrLookup.resourceBundleLookup(resourceBundle).apply(""));
        Assertions.assertNull((Object)StrLookup.resourceBundleLookup(resourceBundle).apply("any"));
    }

    @Test
    void testSystemPropertiesLookup() {
        Assertions.assertEquals((Object)System.getProperty("os.name"), (Object)StrLookup.systemPropertiesLookup().apply("os.name"));
        Assertions.assertNull((Object)StrLookup.systemPropertiesLookup().apply(""));
        Assertions.assertNull((Object)StrLookup.systemPropertiesLookup().apply("other"));
        Assertions.assertThrows(NullPointerException.class, () -> StrLookup.systemPropertiesLookup().apply(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSystemPropertiesLookupReplacedProperties() {
        Properties oldProperties = System.getProperties();
        String osName = "os.name";
        String newOsName = oldProperties.getProperty("os.name") + "_changed";
        StrLookup sysLookup = StrLookup.systemPropertiesLookup();
        Properties newProps = new Properties();
        newProps.setProperty("os.name", newOsName);
        System.setProperties(newProps);
        try {
            Assertions.assertEquals((Object)newOsName, (Object)sysLookup.apply("os.name"), (String)"Changed properties not detected");
        }
        finally {
            System.setProperties(oldProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSystemPropertiesLookupUpdatedProperty() {
        String osName = "os.name";
        String oldOs = System.getProperty("os.name");
        String newOsName = oldOs + "_changed";
        StrLookup sysLookup = StrLookup.systemPropertiesLookup();
        System.setProperty("os.name", newOsName);
        try {
            Assertions.assertEquals((Object)newOsName, (Object)sysLookup.apply("os.name"), (String)"Changed properties not detected");
        }
        finally {
            System.setProperty("os.name", oldOs);
        }
    }
}

