/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.util.Objects;
import org.apache.commons.statistics.distribution.BinomialDistribution;
import org.apache.commons.statistics.inference.AlternativeHypothesis;
import org.apache.commons.statistics.inference.Arguments;
import org.apache.commons.statistics.inference.BaseSignificanceResult;
import org.apache.commons.statistics.inference.InferenceException;
import org.apache.commons.statistics.inference.Searches;
import org.apache.commons.statistics.inference.SignificanceResult;

public final class BinomialTest {
    private static final BinomialTest DEFAULT = new BinomialTest(AlternativeHypothesis.TWO_SIDED);
    private final AlternativeHypothesis alternative;

    private BinomialTest(AlternativeHypothesis alternative) {
        this.alternative = alternative;
    }

    public static BinomialTest withDefaults() {
        return DEFAULT;
    }

    public BinomialTest with(AlternativeHypothesis v) {
        return new BinomialTest(Objects.requireNonNull(v));
    }

    public SignificanceResult test(int numberOfTrials, int numberOfSuccesses, double probability) {
        Arguments.checkNonNegative(numberOfSuccesses);
        if (numberOfTrials < numberOfSuccesses) {
            throw new InferenceException("must have n >= k for binomial coefficient (n, k), got n = %d, k = %d", numberOfSuccesses, numberOfTrials);
        }
        BinomialDistribution distribution = BinomialDistribution.of((int)numberOfTrials, (double)probability);
        double p = this.alternative == AlternativeHypothesis.GREATER_THAN ? distribution.survivalProbability(numberOfSuccesses - 1) : (this.alternative == AlternativeHypothesis.LESS_THAN ? distribution.cumulativeProbability(numberOfSuccesses) : BinomialTest.twoSidedBinomialTest(numberOfTrials, numberOfSuccesses, probability, distribution));
        return new BaseSignificanceResult((double)numberOfSuccesses / (double)numberOfTrials, p);
    }

    private static double twoSidedBinomialTest(int n, int k, double probability, BinomialDistribution distribution) {
        int m1 = (int)Math.ceil(((double)n + 1.0) * probability) - 1;
        int m2 = (int)Math.floor(((double)n + 1.0) * probability);
        if (k < m1) {
            double pk = distribution.logProbability(k);
            int i = Searches.searchDescending(m2, n, pk, arg_0 -> ((BinomialDistribution)distribution).logProbability(arg_0));
            return distribution.cumulativeProbability(k) + distribution.survivalProbability(i - 1);
        }
        if (k > m2) {
            double pk = distribution.logProbability(k);
            int i = Searches.searchAscending(0, m1, pk, arg_0 -> ((BinomialDistribution)distribution).logProbability(arg_0));
            return distribution.cumulativeProbability(i) + distribution.survivalProbability(k - 1);
        }
        double pk = distribution.probability(k);
        double pm = distribution.probability(k == m1 ? m2 : m1);
        return pm > pk ? 1.0 - pm : 1.0;
    }
}

