/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ode.nonstiff;

import org.apache.commons.math4.legacy.core.Field;
import org.apache.commons.math4.legacy.core.RealFieldElement;
import org.apache.commons.math4.legacy.ode.FieldEquationsMapper;
import org.apache.commons.math4.legacy.ode.FieldODEStateAndDerivative;
import org.apache.commons.math4.legacy.ode.nonstiff.RungeKuttaFieldStepInterpolator;

class ThreeEighthesFieldStepInterpolator<T extends RealFieldElement<T>>
extends RungeKuttaFieldStepInterpolator<T> {
    ThreeEighthesFieldStepInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected ThreeEighthesFieldStepInterpolator<T> create(Field<T> newField, boolean newForward, T[][] newYDotK, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new ThreeEighthesFieldStepInterpolator(newField, newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> mapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        RealFieldElement[] interpolatedDerivatives;
        RealFieldElement[] interpolatedState;
        RealFieldElement coeffDot3 = (RealFieldElement)theta.multiply(0.75);
        RealFieldElement coeffDot1 = (RealFieldElement)((RealFieldElement)coeffDot3.multiply((Object)((RealFieldElement)((RealFieldElement)theta.multiply(4)).subtract(5.0)))).add(1.0);
        RealFieldElement coeffDot2 = (RealFieldElement)coeffDot3.multiply((Object)((RealFieldElement)((RealFieldElement)theta.multiply(-6)).add(5.0)));
        RealFieldElement coeffDot4 = (RealFieldElement)coeffDot3.multiply((Object)((RealFieldElement)((RealFieldElement)theta.multiply(2)).subtract(1.0)));
        if (this.getGlobalPreviousState() != null && theta.getReal() <= 0.5) {
            RealFieldElement s = (RealFieldElement)thetaH.divide(8.0);
            RealFieldElement fourTheta2 = (RealFieldElement)((RealFieldElement)theta.multiply(theta)).multiply(4);
            RealFieldElement coeff1 = (RealFieldElement)s.multiply((Object)((RealFieldElement)((RealFieldElement)((RealFieldElement)fourTheta2.multiply(2)).subtract((Object)((RealFieldElement)theta.multiply(15)))).add(8.0)));
            RealFieldElement coeff2 = (RealFieldElement)((RealFieldElement)s.multiply((Object)((RealFieldElement)((RealFieldElement)theta.multiply(5)).subtract((Object)fourTheta2)))).multiply(3);
            RealFieldElement coeff3 = (RealFieldElement)((RealFieldElement)s.multiply(theta)).multiply(3);
            RealFieldElement coeff4 = (RealFieldElement)s.multiply((Object)((RealFieldElement)fourTheta2.subtract((Object)((RealFieldElement)theta.multiply(3)))));
            interpolatedState = this.previousStateLinearCombination(new RealFieldElement[]{coeff1, coeff2, coeff3, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new RealFieldElement[]{coeffDot1, coeffDot2, coeffDot3, coeffDot4});
        } else {
            RealFieldElement s = (RealFieldElement)oneMinusThetaH.divide(-8.0);
            RealFieldElement fourTheta2 = (RealFieldElement)((RealFieldElement)theta.multiply(theta)).multiply(4);
            RealFieldElement thetaPlus1 = (RealFieldElement)theta.add(1.0);
            RealFieldElement coeff1 = (RealFieldElement)s.multiply((Object)((RealFieldElement)((RealFieldElement)((RealFieldElement)fourTheta2.multiply(2)).subtract((Object)((RealFieldElement)theta.multiply(7)))).add(1.0)));
            RealFieldElement coeff2 = (RealFieldElement)((RealFieldElement)s.multiply((Object)((RealFieldElement)thetaPlus1.subtract((Object)fourTheta2)))).multiply(3);
            RealFieldElement coeff3 = (RealFieldElement)((RealFieldElement)s.multiply((Object)thetaPlus1)).multiply(3);
            RealFieldElement coeff4 = (RealFieldElement)s.multiply((Object)((RealFieldElement)thetaPlus1.add((Object)fourTheta2)));
            interpolatedState = this.currentStateLinearCombination(new RealFieldElement[]{coeff1, coeff2, coeff3, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new RealFieldElement[]{coeffDot1, coeffDot2, coeffDot3, coeffDot4});
        }
        return new FieldODEStateAndDerivative(time, interpolatedState, interpolatedDerivatives);
    }
}

