/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.field.linalg;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math4.legacy.linear.AnyMatrix;
import org.apache.commons.numbers.field.Field;

public final class FieldDenseMatrix<T>
implements AnyMatrix {
    private final Field<T> field;
    private final int rows;
    private final int columns;
    private final T[] data;

    private FieldDenseMatrix(Field<T> f, int r, int c) {
        if (r <= 0 || c <= 0) {
            throw new IllegalArgumentException("Negative size");
        }
        this.field = f;
        this.rows = r;
        this.columns = c;
        this.data = new Object[r * c];
    }

    public static <T> FieldDenseMatrix<T> create(Field<T> f, int r, int c) {
        return new FieldDenseMatrix<T>(f, r, c);
    }

    public static <T> FieldDenseMatrix<T> zero(Field<T> f, int r, int c) {
        return FieldDenseMatrix.create(f, r, c).fill(f.zero());
    }

    public static <T> FieldDenseMatrix<T> identity(Field<T> f, int n) {
        FieldDenseMatrix<Object> r = FieldDenseMatrix.zero(f, n, n);
        for (int i = 0; i < n; ++i) {
            r.set(i, i, f.one());
        }
        return r;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FieldDenseMatrix) {
            FieldDenseMatrix m = (FieldDenseMatrix)other;
            return this.field.equals(m.field) && this.rows == m.rows && this.columns == m.columns && Arrays.equals(this.data, m.data);
        }
        return false;
    }

    public FieldDenseMatrix<T> copy() {
        FieldDenseMatrix<T> r = FieldDenseMatrix.create(this.field, this.rows, this.columns);
        System.arraycopy(this.data, 0, r.data, 0, this.data.length);
        return r;
    }

    public FieldDenseMatrix<T> transpose() {
        FieldDenseMatrix<T> r = FieldDenseMatrix.create(this.field, this.columns, this.rows);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                r.set(j, i, this.get(i, j));
            }
        }
        return r;
    }

    @Override
    public int getRowDimension() {
        return this.rows;
    }

    @Override
    public int getColumnDimension() {
        return this.columns;
    }

    public Field<T> getField() {
        return this.field;
    }

    public FieldDenseMatrix<T> fill(T value) {
        Arrays.fill(this.data, value);
        return this;
    }

    public T get(int i, int j) {
        return this.data[i * this.columns + j];
    }

    public void set(int i, int j, T value) {
        this.data[i * this.columns + j] = value;
    }

    public FieldDenseMatrix<T> add(FieldDenseMatrix<T> other) {
        this.checkAdd(other);
        FieldDenseMatrix<T> r = FieldDenseMatrix.create(this.field, this.rows, this.columns);
        for (int i = 0; i < this.data.length; ++i) {
            r.data[i] = this.field.add(this.data[i], other.data[i]);
        }
        return r;
    }

    public FieldDenseMatrix<T> subtract(FieldDenseMatrix<T> other) {
        this.checkAdd(other);
        FieldDenseMatrix<T> r = FieldDenseMatrix.create(this.field, this.rows, this.columns);
        for (int i = 0; i < this.data.length; ++i) {
            r.data[i] = this.field.subtract(this.data[i], other.data[i]);
        }
        return r;
    }

    public FieldDenseMatrix<T> negate() {
        FieldDenseMatrix<T> r = FieldDenseMatrix.create(this.field, this.rows, this.columns);
        for (int i = 0; i < this.data.length; ++i) {
            r.data[i] = this.field.negate(this.data[i]);
        }
        return r;
    }

    public FieldDenseMatrix<T> multiply(FieldDenseMatrix<T> other) {
        this.checkMultiply(other);
        FieldDenseMatrix<T> r = FieldDenseMatrix.zero(this.field, this.rows, other.columns);
        for (int i = 0; i < this.rows; ++i) {
            int o1 = i * this.columns;
            int o2 = i * r.columns;
            for (int j = 0; j < other.columns; ++j) {
                int o3 = o2 + j;
                for (int k = 0; k < this.columns; ++k) {
                    r.data[o3] = this.field.add(r.data[o3], this.field.multiply(this.data[o1 + k], other.data[k * other.columns + j]));
                }
            }
        }
        return r;
    }

    public FieldDenseMatrix<T> pow(int p) {
        this.checkMultiply(this);
        if (p < 0) {
            throw new IllegalArgumentException("Negative exponent: " + p);
        }
        if (p == 0) {
            return FieldDenseMatrix.identity(this.field, this.rows);
        }
        if (p == 1) {
            return this.copy();
        }
        int power = p - 1;
        char[] binary = Integer.toBinaryString(power).toCharArray();
        ArrayList<Integer> nonZeroPositions = new ArrayList<Integer>();
        for (int i = 0; i < binary.length; ++i) {
            if (binary[i] != '1') continue;
            int pos = binary.length - i - 1;
            nonZeroPositions.add(pos);
        }
        ArrayList<FieldDenseMatrix<T>> results = new ArrayList<FieldDenseMatrix<T>>(binary.length);
        results.add(this);
        for (int i = 1; i < binary.length; ++i) {
            FieldDenseMatrix s = (FieldDenseMatrix)results.get(i - 1);
            FieldDenseMatrix<T> r = s.multiply(s);
            results.add(r);
        }
        FieldDenseMatrix<T> r = this;
        for (Integer i : nonZeroPositions) {
            r = r.multiply((FieldDenseMatrix)results.get(i));
        }
        return r;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }
}

