/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.distribution;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math4.legacy.core.Pair;
import org.apache.commons.math4.legacy.distribution.EnumeratedDistribution;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MathArithmeticException;
import org.apache.commons.math4.legacy.exception.NotANumberException;
import org.apache.commons.math4.legacy.exception.NotFiniteNumberException;
import org.apache.commons.math4.legacy.exception.NotPositiveException;
import org.apache.commons.math4.legacy.exception.OutOfRangeException;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.statistics.distribution.ContinuousDistribution;

public class EnumeratedRealDistribution
implements ContinuousDistribution {
    protected final EnumeratedDistribution<Double> innerDistribution;

    public EnumeratedRealDistribution(double[] singletons, double[] probabilities) throws DimensionMismatchException, NotPositiveException, MathArithmeticException, NotFiniteNumberException, NotANumberException {
        this.innerDistribution = new EnumeratedDistribution(EnumeratedRealDistribution.createDistribution(singletons, probabilities));
    }

    public EnumeratedRealDistribution(double[] data) {
        LinkedHashMap<Double, Integer> dataMap = new LinkedHashMap<Double, Integer>();
        for (double value : data) {
            dataMap.merge(value, 1, Integer::sum);
        }
        int massPoints = dataMap.size();
        double denom = data.length;
        double[] values = new double[massPoints];
        double[] probabilities = new double[massPoints];
        int index = 0;
        for (Map.Entry entry : dataMap.entrySet()) {
            values[index] = (Double)entry.getKey();
            probabilities[index] = (double)((Integer)entry.getValue()).intValue() / denom;
            ++index;
        }
        this.innerDistribution = new EnumeratedDistribution(EnumeratedRealDistribution.createDistribution(values, probabilities));
    }

    private static List<Pair<Double, Double>> createDistribution(double[] singletons, double[] probabilities) {
        if (singletons.length != probabilities.length) {
            throw new DimensionMismatchException(probabilities.length, singletons.length);
        }
        ArrayList<Pair<Double, Double>> samples = new ArrayList<Pair<Double, Double>>(singletons.length);
        for (int i = 0; i < singletons.length; ++i) {
            samples.add((Pair<Double, Double>)new Pair((Object)singletons[i], (Object)probabilities[i]));
        }
        return samples;
    }

    public double density(double x) {
        return this.innerDistribution.probability(x);
    }

    public double cumulativeProbability(double x) {
        double probability = 0.0;
        for (Pair<Double, Double> sample : this.innerDistribution.getPmf()) {
            if (!((Double)sample.getKey() <= x)) continue;
            probability += ((Double)sample.getValue()).doubleValue();
        }
        return probability;
    }

    public double inverseCumulativeProbability(double p) throws OutOfRangeException {
        if (p < 0.0 || p > 1.0) {
            throw new OutOfRangeException((Number)p, (Number)0, (Number)1);
        }
        double probability = 0.0;
        double x = this.getSupportLowerBound();
        for (Pair<Double, Double> sample : this.innerDistribution.getPmf()) {
            if ((Double)sample.getValue() == 0.0) continue;
            probability += ((Double)sample.getValue()).doubleValue();
            x = (Double)sample.getKey();
            if (!(probability >= p)) continue;
            break;
        }
        return x;
    }

    public double getMean() {
        double mean = 0.0;
        for (Pair<Double, Double> sample : this.innerDistribution.getPmf()) {
            mean += (Double)sample.getValue() * (Double)sample.getKey();
        }
        return mean;
    }

    public double getVariance() {
        double mean = 0.0;
        double meanOfSquares = 0.0;
        for (Pair<Double, Double> sample : this.innerDistribution.getPmf()) {
            mean += (Double)sample.getValue() * (Double)sample.getKey();
            meanOfSquares += (Double)sample.getValue() * (Double)sample.getKey() * (Double)sample.getKey();
        }
        return meanOfSquares - mean * mean;
    }

    public double getSupportLowerBound() {
        double min = Double.POSITIVE_INFINITY;
        for (Pair<Double, Double> sample : this.innerDistribution.getPmf()) {
            if (!((Double)sample.getKey() < min) || !((Double)sample.getValue() > 0.0)) continue;
            min = (Double)sample.getKey();
        }
        return min;
    }

    public double getSupportUpperBound() {
        double max = Double.NEGATIVE_INFINITY;
        for (Pair<Double, Double> sample : this.innerDistribution.getPmf()) {
            if (!((Double)sample.getKey() > max) || !((Double)sample.getValue() > 0.0)) continue;
            max = (Double)sample.getKey();
        }
        return max;
    }

    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return this.innerDistribution.createSampler(rng)::sample;
    }
}

