/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.core;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.core.Field;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MathArithmeticException;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.MathInternalError;
import org.apache.commons.math4.legacy.exception.NoDataException;
import org.apache.commons.math4.legacy.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.legacy.exception.NotANumberException;
import org.apache.commons.math4.legacy.exception.NotPositiveException;
import org.apache.commons.math4.legacy.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.exception.NumberIsTooLargeException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.numbers.core.Precision;

public final class MathArrays {
    private MathArrays() {
    }

    public static double[] scale(double val, double[] arr) {
        double[] newArr = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            newArr[i] = arr[i] * val;
        }
        return newArr;
    }

    public static void scaleInPlace(double val, double[] arr) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * val;
        }
    }

    public static double[] ebeAdd(double[] a, double[] b) {
        MathArrays.checkEqualLength(a, b);
        double[] result = (double[])a.clone();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            result[n] = result[n] + b[i];
        }
        return result;
    }

    public static double[] ebeSubtract(double[] a, double[] b) {
        MathArrays.checkEqualLength(a, b);
        double[] result = (double[])a.clone();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            result[n] = result[n] - b[i];
        }
        return result;
    }

    public static double[] ebeMultiply(double[] a, double[] b) {
        MathArrays.checkEqualLength(a, b);
        double[] result = (double[])a.clone();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            result[n] = result[n] * b[i];
        }
        return result;
    }

    public static double[] ebeDivide(double[] a, double[] b) {
        MathArrays.checkEqualLength(a, b);
        double[] result = (double[])a.clone();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            result[n] = result[n] / b[i];
        }
        return result;
    }

    public static double distance1(double[] p1, double[] p2) {
        MathArrays.checkEqualLength(p1, p2);
        double sum = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            sum += JdkMath.abs((double)(p1[i] - p2[i]));
        }
        return sum;
    }

    public static int distance1(int[] p1, int[] p2) {
        MathArrays.checkEqualLength(p1, p2);
        int sum = 0;
        for (int i = 0; i < p1.length; ++i) {
            sum += JdkMath.abs((int)(p1[i] - p2[i]));
        }
        return sum;
    }

    public static double distance(double[] p1, double[] p2) {
        MathArrays.checkEqualLength(p1, p2);
        double sum = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double dp = p1[i] - p2[i];
            sum += dp * dp;
        }
        return JdkMath.sqrt((double)sum);
    }

    public static double distance(int[] p1, int[] p2) {
        MathArrays.checkEqualLength(p1, p2);
        double sum = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double dp = (double)p1[i] - (double)p2[i];
            sum += dp * dp;
        }
        return JdkMath.sqrt((double)sum);
    }

    public static double distanceInf(double[] p1, double[] p2) {
        MathArrays.checkEqualLength(p1, p2);
        double max = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            max = JdkMath.max((double)max, (double)JdkMath.abs((double)(p1[i] - p2[i])));
        }
        return max;
    }

    public static int distanceInf(int[] p1, int[] p2) {
        MathArrays.checkEqualLength(p1, p2);
        int max = 0;
        for (int i = 0; i < p1.length; ++i) {
            max = JdkMath.max((int)max, (int)JdkMath.abs((int)(p1[i] - p2[i])));
        }
        return max;
    }

    public static <T extends Comparable<? super T>> boolean isMonotonic(T[] val, OrderDirection dir, boolean strict) {
        T previous = val[0];
        int max = val.length;
        for (int i = 1; i < max; ++i) {
            switch (dir) {
                case INCREASING: {
                    int comp = previous.compareTo(val[i]);
                    if (!(strict ? comp >= 0 : comp > 0)) break;
                    return false;
                }
                case DECREASING: {
                    int comp = val[i].compareTo(previous);
                    if (!(strict ? comp >= 0 : comp > 0)) break;
                    return false;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            previous = val[i];
        }
        return true;
    }

    public static boolean isMonotonic(double[] val, OrderDirection dir, boolean strict) {
        return MathArrays.checkOrder(val, dir, strict, false);
    }

    public static boolean checkEqualLength(double[] a, double[] b, boolean abort) {
        if (a.length == b.length) {
            return true;
        }
        if (abort) {
            throw new DimensionMismatchException(a.length, b.length);
        }
        return false;
    }

    public static void checkEqualLength(double[] a, double[] b) {
        MathArrays.checkEqualLength(a, b, true);
    }

    public static boolean checkEqualLength(int[] a, int[] b, boolean abort) {
        if (a.length == b.length) {
            return true;
        }
        if (abort) {
            throw new DimensionMismatchException(a.length, b.length);
        }
        return false;
    }

    public static void checkEqualLength(int[] a, int[] b) {
        MathArrays.checkEqualLength(a, b, true);
    }

    public static boolean checkOrder(double[] val, OrderDirection dir, boolean strict, boolean abort) {
        int index;
        double previous = val[0];
        int max = val.length;
        block4: for (index = 1; index < max; ++index) {
            switch (dir) {
                case INCREASING: {
                    if (!(strict ? val[index] <= previous : val[index] < previous)) break;
                    break block4;
                }
                case DECREASING: {
                    if (!(strict ? val[index] >= previous : val[index] > previous)) break;
                    break block4;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            previous = val[index];
        }
        if (index == max) {
            return true;
        }
        if (abort) {
            throw new NonMonotonicSequenceException((Number)val[index], (Number)previous, index, dir == OrderDirection.INCREASING, strict);
        }
        return false;
    }

    public static void checkOrder(double[] val, OrderDirection dir, boolean strict) {
        MathArrays.checkOrder(val, dir, strict, true);
    }

    public static void checkOrder(double[] val) {
        MathArrays.checkOrder(val, OrderDirection.INCREASING, true);
    }

    public static void checkRectangular(long[][] in) {
        NullArgumentException.check((Object)in);
        for (int i = 1; i < in.length; ++i) {
            if (in[i].length == in[0].length) continue;
            throw new DimensionMismatchException((Localizable)LocalizedFormats.DIFFERENT_ROWS_LENGTHS, in[i].length, in[0].length);
        }
    }

    public static void checkPositive(double[] in) {
        for (int i = 0; i < in.length; ++i) {
            if (!(in[i] <= 0.0)) continue;
            throw new NotStrictlyPositiveException((Number)in[i]);
        }
    }

    public static void checkNotNaN(double[] in) {
        for (int i = 0; i < in.length; ++i) {
            if (!Double.isNaN(in[i])) continue;
            throw new NotANumberException();
        }
    }

    public static void checkNonNegative(long[] in) {
        for (int i = 0; i < in.length; ++i) {
            if (in[i] >= 0L) continue;
            throw new NotPositiveException((Number)in[i]);
        }
    }

    public static void checkNonNegative(long[][] in) {
        for (int i = 0; i < in.length; ++i) {
            for (int j = 0; j < in[i].length; ++j) {
                if (in[i][j] >= 0L) continue;
                throw new NotPositiveException((Number)in[i][j]);
            }
        }
    }

    public static boolean equals(float[] x, float[] y) {
        if (x == null || y == null) {
            return x == null == (y == null);
        }
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (Precision.equals((float)x[i], (float)y[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(float[] x, float[] y) {
        if (x == null || y == null) {
            return x == null == (y == null);
        }
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (Precision.equalsIncludingNaN((float)x[i], (float)y[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] x, double[] y) {
        if (x == null || y == null) {
            return x == null == (y == null);
        }
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (Precision.equals((double)x[i], (double)y[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(double[] x, double[] y) {
        if (x == null || y == null) {
            return x == null == (y == null);
        }
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (Precision.equalsIncludingNaN((double)x[i], (double)y[i])) continue;
            return false;
        }
        return true;
    }

    public static double[] normalizeArray(double[] values, double normalizedSum) {
        if (Double.isInfinite(normalizedSum)) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.NORMALIZE_INFINITE, new Object[0]);
        }
        if (Double.isNaN(normalizedSum)) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.NORMALIZE_NAN, new Object[0]);
        }
        double sum = 0.0;
        int len = values.length;
        double[] out = new double[len];
        for (int i = 0; i < len; ++i) {
            if (Double.isInfinite(values[i])) {
                throw new MathIllegalArgumentException((Localizable)LocalizedFormats.INFINITE_ARRAY_ELEMENT, new Object[]{values[i], i});
            }
            if (Double.isNaN(values[i])) continue;
            sum += values[i];
        }
        if (sum == 0.0) {
            throw new MathArithmeticException((Localizable)LocalizedFormats.ARRAY_SUMS_TO_ZERO, new Object[0]);
        }
        double scale = normalizedSum / sum;
        for (int i = 0; i < len; ++i) {
            out[i] = Double.isNaN(values[i]) ? Double.NaN : values[i] * scale;
        }
        return out;
    }

    public static <T> T[] buildArray(Field<T> field, int length) {
        Object[] array = (Object[])Array.newInstance(field.getRuntimeClass(), length);
        Arrays.fill(array, field.getZero());
        return array;
    }

    public static <T> T[][] buildArray(Field<T> field, int rows, int columns) {
        Object[][] array;
        if (columns < 0) {
            T[] dummyRow = MathArrays.buildArray(field, 0);
            array = (Object[][])Array.newInstance(dummyRow.getClass(), rows);
        } else {
            array = (Object[][])Array.newInstance(field.getRuntimeClass(), rows, columns);
            for (int i = 0; i < rows; ++i) {
                Arrays.fill(array[i], field.getZero());
            }
        }
        return array;
    }

    public static double[] convolve(double[] x, double[] h) {
        NullArgumentException.check((Object)x);
        NullArgumentException.check((Object)h);
        int xLen = x.length;
        int hLen = h.length;
        if (xLen == 0 || hLen == 0) {
            throw new NoDataException();
        }
        int totalLength = xLen + hLen - 1;
        double[] y = new double[totalLength];
        for (int n = 0; n < totalLength; ++n) {
            double yn = 0.0;
            int k = JdkMath.max((int)0, (int)(n + 1 - xLen));
            int j = n - k;
            while (k < hLen && j >= 0) {
                yn += x[j--] * h[k++];
            }
            y[n] = yn;
        }
        return y;
    }

    public static int[] natural(int n) {
        return MathArrays.sequence(n, 0, 1);
    }

    public static int[] sequence(int size, int start, int stride) {
        int[] a = new int[size];
        for (int i = 0; i < size; ++i) {
            a[i] = start + i * stride;
        }
        return a;
    }

    public static boolean verifyValues(double[] values, int begin, int length) {
        return MathArrays.verifyValues(values, begin, length, false);
    }

    public static boolean verifyValues(double[] values, int begin, int length, boolean allowEmpty) {
        if (values == null) {
            throw new NullArgumentException((Localizable)LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (begin < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, (Number)begin);
        }
        if (length < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, (Number)length);
        }
        if (begin + length > values.length) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(begin + length), (Number)values.length, true);
        }
        return length != 0 || allowEmpty;
    }

    public static boolean verifyValues(double[] values, double[] weights, int begin, int length) {
        return MathArrays.verifyValues(values, weights, begin, length, false);
    }

    public static boolean verifyValues(double[] values, double[] weights, int begin, int length, boolean allowEmpty) {
        if (weights == null || values == null) {
            throw new NullArgumentException((Localizable)LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        MathArrays.checkEqualLength(weights, values);
        if (length != 0) {
            boolean containsPositiveWeight = false;
            for (int i = begin; i < begin + length; ++i) {
                double weight = weights[i];
                if (Double.isNaN(weight)) {
                    throw new MathIllegalArgumentException((Localizable)LocalizedFormats.NAN_ELEMENT_AT_INDEX, new Object[]{i});
                }
                if (Double.isInfinite(weight)) {
                    throw new MathIllegalArgumentException((Localizable)LocalizedFormats.INFINITE_ARRAY_ELEMENT, new Object[]{weight, i});
                }
                if (weight < 0.0) {
                    throw new MathIllegalArgumentException((Localizable)LocalizedFormats.NEGATIVE_ELEMENT_AT_INDEX, new Object[]{i, weight});
                }
                if (containsPositiveWeight || !(weight > 0.0)) continue;
                containsPositiveWeight = true;
            }
            if (!containsPositiveWeight) {
                throw new MathIllegalArgumentException((Localizable)LocalizedFormats.WEIGHT_AT_LEAST_ONE_NON_ZERO, new Object[0]);
            }
        }
        return MathArrays.verifyValues(values, begin, length, allowEmpty);
    }

    public static double[] concatenate(double[] ... x) {
        int combinedLength = 0;
        for (double[] a : x) {
            combinedLength += a.length;
        }
        int offset = 0;
        int curLength = 0;
        double[] combined = new double[combinedLength];
        for (int i = 0; i < x.length; ++i) {
            curLength = x[i].length;
            System.arraycopy(x[i], 0, combined, offset, curLength);
            offset += curLength;
        }
        return combined;
    }

    public static double[] unique(double[] data) {
        TreeSet<Double> values = new TreeSet<Double>();
        for (int i = 0; i < data.length; ++i) {
            values.add(data[i]);
        }
        int count = values.size();
        double[] out = new double[count];
        Iterator iterator = values.descendingIterator();
        int i = 0;
        while (iterator.hasNext()) {
            out[i++] = (Double)iterator.next();
        }
        return out;
    }

    public static enum OrderDirection {
        INCREASING,
        DECREASING;

    }

    public static interface Function {
        public double evaluate(double[] var1);

        public double evaluate(double[] var1, int var2, int var3);
    }
}

