/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.univariate;

import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.optim.univariate.SimpleUnivariateValueChecker;
import org.apache.commons.math3.optim.univariate.UnivariatePointValuePair;
import org.junit.Assert;
import org.junit.Test;

public class SimpleUnivariateValueCheckerTest {
    @Test(expected=NotStrictlyPositiveException.class)
    public void testIterationCheckPrecondition() {
        new SimpleUnivariateValueChecker(0.1, 0.01, 0);
    }

    @Test
    public void testIterationCheck() {
        int max = 10;
        SimpleUnivariateValueChecker checker = new SimpleUnivariateValueChecker(0.1, 0.01, 10);
        Assert.assertTrue((boolean)checker.converged(10, null, null));
        Assert.assertTrue((boolean)checker.converged(11, null, null));
    }

    @Test
    public void testIterationCheckDisabled() {
        SimpleUnivariateValueChecker checker = new SimpleUnivariateValueChecker(1.0E-8, 1.0E-8);
        UnivariatePointValuePair a = new UnivariatePointValuePair(1.0, 1.0);
        UnivariatePointValuePair b = new UnivariatePointValuePair(10.0, 10.0);
        Assert.assertFalse((boolean)checker.converged(-1, a, b));
        Assert.assertFalse((boolean)checker.converged(0, a, b));
        Assert.assertFalse((boolean)checker.converged(1000000, a, b));
        Assert.assertTrue((boolean)checker.converged(-1, a, a));
        Assert.assertTrue((boolean)checker.converged(-1, b, b));
    }
}

