/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.util.Random;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.linear.HessenbergTransformer;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.junit.Assert;
import org.junit.Test;

public class HessenbergTransformerTest {
    private double[][] testSquare5 = new double[][]{{5.0, 4.0, 3.0, 2.0, 1.0}, {1.0, 4.0, 0.0, 3.0, 3.0}, {2.0, 0.0, 3.0, 0.0, 0.0}, {3.0, 2.0, 1.0, 2.0, 5.0}, {4.0, 2.0, 1.0, 4.0, 1.0}};
    private double[][] testSquare3 = new double[][]{{2.0, -1.0, 1.0}, {-1.0, 2.0, 1.0}, {1.0, -1.0, 2.0}};
    private double[][] testRandom = new double[][]{{0.68, 0.823, -0.444, -0.27}, {-0.211, -0.605, 0.108, 0.0268}, {0.566, -0.33, -0.0452, 0.904}, {0.597, 0.536, 0.258, 0.832}};

    @Test
    public void testNonSquare() {
        try {
            new HessenbergTransformer(MatrixUtils.createRealMatrix((double[][])new double[3][2]));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testAEqualPHPt() {
        this.checkAEqualPHPt(MatrixUtils.createRealMatrix((double[][])this.testSquare5));
        this.checkAEqualPHPt(MatrixUtils.createRealMatrix((double[][])this.testSquare3));
        this.checkAEqualPHPt(MatrixUtils.createRealMatrix((double[][])this.testRandom));
    }

    @Test
    public void testPOrthogonal() {
        this.checkOrthogonal(new HessenbergTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare5)).getP());
        this.checkOrthogonal(new HessenbergTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare3)).getP());
    }

    @Test
    public void testPTOrthogonal() {
        this.checkOrthogonal(new HessenbergTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare5)).getPT());
        this.checkOrthogonal(new HessenbergTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare3)).getPT());
    }

    @Test
    public void testHessenbergForm() {
        this.checkHessenbergForm(new HessenbergTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare5)).getH());
        this.checkHessenbergForm(new HessenbergTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare3)).getH());
    }

    @Test
    public void testRandomData() {
        for (int run = 0; run < 100; ++run) {
            Random r = new Random(System.currentTimeMillis());
            int size = r.nextInt(20) + 4;
            double[][] data = new double[size][size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    data[i][j] = r.nextInt(100);
                }
            }
            RealMatrix m = MatrixUtils.createRealMatrix((double[][])data);
            RealMatrix h = this.checkAEqualPHPt(m);
            this.checkHessenbergForm(h);
        }
    }

    @Test
    public void testRandomDataNormalDistribution() {
        for (int run = 0; run < 100; ++run) {
            Random r = new Random(System.currentTimeMillis());
            NormalDistribution dist = new NormalDistribution(0.0, r.nextDouble() * 5.0);
            int size = r.nextInt(20) + 4;
            double[][] data = new double[size][size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    data[i][j] = dist.sample();
                }
            }
            RealMatrix m = MatrixUtils.createRealMatrix((double[][])data);
            RealMatrix h = this.checkAEqualPHPt(m);
            this.checkHessenbergForm(h);
        }
    }

    @Test
    public void testMatricesValues5() {
        this.checkMatricesValues(this.testSquare5, new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -0.182574185835055, 0.784218758628863, 0.395029040913988, -0.442289115981669}, {0.0, -0.365148371670111, -0.337950625265477, -0.37411079408882, -0.782621974707823}, {0.0, -0.547722557505166, 0.402941130124223, -0.626468266309003, 0.381019628053472}, {0.0, -0.730296743340221, -0.329285224617644, 0.558149336547665, 0.216118545309225}}, new double[][]{{5.0, -3.65148371670111, 2.59962019434982, -0.237003414680848, -3.13886458663398}, {-5.47722557505166, 6.9, -2.29164066120599, 0.207283564429169, 0.703858369151728}, {0.0, -4.21386600008432, 2.30555659846067, 2.74935928725112, 0.857569835914113}, {0.0, 0.0, 2.86406180891882, -1.11582249161595, 0.817995267184158}, {0.0, 0.0, 0.0, 0.683518597386085, 1.91026589315528}});
    }

    @Test
    public void testMatricesValues3() {
        this.checkMatricesValues(this.testSquare3, new double[][]{{1.0, 0.0, 0.0}, {0.0, -0.707106781186547, 0.707106781186547}, {0.0, 0.707106781186547, 0.707106781186548}}, new double[][]{{2.0, 1.41421356237309, 0.0}, {1.4142135623731, 2.0, -1.0}, {0.0, 1.0, 2.0}});
    }

    private RealMatrix checkAEqualPHPt(RealMatrix matrix) {
        HessenbergTransformer transformer = new HessenbergTransformer(matrix);
        RealMatrix p = transformer.getP();
        RealMatrix pT = transformer.getPT();
        RealMatrix h = transformer.getH();
        RealMatrix result = p.multiply(h).multiply(pT);
        double norm = result.subtract(matrix).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-10);
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                if (i <= j + 1) continue;
                Assert.assertEquals((double)matrix.getEntry(i, j), (double)result.getEntry(i, j), (double)1.0E-12);
            }
        }
        return transformer.getH();
    }

    private void checkOrthogonal(RealMatrix m) {
        RealMatrix mTm = m.transpose().multiply(m);
        RealMatrix id = MatrixUtils.createRealIdentityMatrix((int)mTm.getRowDimension());
        Assert.assertEquals((double)0.0, (double)mTm.subtract(id).getNorm(), (double)1.0E-14);
    }

    private void checkHessenbergForm(RealMatrix m) {
        int rows = m.getRowDimension();
        int cols = m.getColumnDimension();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (i <= j + 1) continue;
                Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)1.0E-16);
            }
        }
    }

    private void checkMatricesValues(double[][] matrix, double[][] pRef, double[][] hRef) {
        HessenbergTransformer transformer = new HessenbergTransformer(MatrixUtils.createRealMatrix((double[][])matrix));
        RealMatrix p = transformer.getP();
        Assert.assertEquals((double)0.0, (double)p.subtract(MatrixUtils.createRealMatrix((double[][])pRef)).getNorm(), (double)1.0E-14);
        RealMatrix h = transformer.getH();
        Assert.assertEquals((double)0.0, (double)h.subtract(MatrixUtils.createRealMatrix((double[][])hRef)).getNorm(), (double)1.0E-14);
        Assert.assertTrue((p == transformer.getP() ? 1 : 0) != 0);
        Assert.assertTrue((h == transformer.getH() ? 1 : 0) != 0);
    }
}

