/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod;

import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math3.geometry.euclidean.twod.Line;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.Transform;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class LineTest {
    @Test
    public void testContains() {
        Line l = new Line(new Vector2D(0.0, 1.0), new Vector2D(1.0, 2.0), 1.0E-10);
        Assert.assertTrue((boolean)l.contains(new Vector2D(0.0, 1.0)));
        Assert.assertTrue((boolean)l.contains(new Vector2D(1.0, 2.0)));
        Assert.assertTrue((boolean)l.contains(new Vector2D(7.0, 8.0)));
        Assert.assertTrue((!l.contains(new Vector2D(8.0, 7.0)) ? 1 : 0) != 0);
    }

    @Test
    public void testAbscissa() {
        Line l = new Line(new Vector2D(2.0, 1.0), new Vector2D(-2.0, -2.0), 1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.toSubSpace((Vector)new Vector2D(-3.0, 4.0)).getX(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.toSubSpace((Vector)new Vector2D(3.0, -4.0)).getX(), (double)1.0E-10);
        Assert.assertEquals((double)-5.0, (double)l.toSubSpace((Vector)new Vector2D(7.0, -1.0)).getX(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)l.toSubSpace((Vector)new Vector2D(-1.0, -7.0)).getX(), (double)1.0E-10);
    }

    @Test
    public void testOffset() {
        Line l = new Line(new Vector2D(2.0, 1.0), new Vector2D(-2.0, -2.0), 1.0E-10);
        Assert.assertEquals((double)-5.0, (double)l.getOffset((Vector)new Vector2D(5.0, -3.0)), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)l.getOffset((Vector)new Vector2D(-5.0, 2.0)), (double)1.0E-10);
    }

    @Test
    public void testDistance() {
        Line l = new Line(new Vector2D(2.0, 1.0), new Vector2D(-2.0, -2.0), 1.0E-10);
        Assert.assertEquals((double)5.0, (double)l.distance(new Vector2D(5.0, -3.0)), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)l.distance(new Vector2D(-5.0, 2.0)), (double)1.0E-10);
    }

    @Test
    public void testPointAt() {
        Line l = new Line(new Vector2D(2.0, 1.0), new Vector2D(-2.0, -2.0), 1.0E-10);
        for (double a = -2.0; a < 2.0; a += 0.2) {
            Vector1D pA = new Vector1D(a);
            Vector2D point = l.toSpace((Point)pA);
            Assert.assertEquals((double)a, (double)l.toSubSpace((Point)point).getX(), (double)1.0E-10);
            Assert.assertEquals((double)0.0, (double)l.getOffset((Point)point), (double)1.0E-10);
            for (double o = -2.0; o < 2.0; o += 0.2) {
                point = l.getPointAt(pA, o);
                Assert.assertEquals((double)a, (double)l.toSubSpace((Point)point).getX(), (double)1.0E-10);
                Assert.assertEquals((double)o, (double)l.getOffset((Point)point), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testOriginOffset() {
        Line l1 = new Line(new Vector2D(0.0, 1.0), new Vector2D(1.0, 2.0), 1.0E-10);
        Assert.assertEquals((double)FastMath.sqrt((double)0.5), (double)l1.getOriginOffset(), (double)1.0E-10);
        Line l2 = new Line(new Vector2D(1.0, 2.0), new Vector2D(0.0, 1.0), 1.0E-10);
        Assert.assertEquals((double)(-FastMath.sqrt((double)0.5)), (double)l2.getOriginOffset(), (double)1.0E-10);
    }

    @Test
    public void testParallel() {
        Line l1 = new Line(new Vector2D(0.0, 1.0), new Vector2D(1.0, 2.0), 1.0E-10);
        Line l2 = new Line(new Vector2D(2.0, 2.0), new Vector2D(3.0, 3.0), 1.0E-10);
        Assert.assertTrue((boolean)l1.isParallelTo(l2));
        Line l3 = new Line(new Vector2D(1.0, 0.0), new Vector2D(0.5, -0.5), 1.0E-10);
        Assert.assertTrue((boolean)l1.isParallelTo(l3));
        Line l4 = new Line(new Vector2D(1.0, 0.0), new Vector2D(0.5, -0.51), 1.0E-10);
        Assert.assertTrue((!l1.isParallelTo(l4) ? 1 : 0) != 0);
    }

    @Test
    public void testTransform() throws MathIllegalArgumentException {
        Line l1 = new Line(new Vector2D(1.0, 1.0), new Vector2D(4.0, 1.0), 1.0E-10);
        Transform t1 = Line.getTransform((double)0.0, (double)0.5, (double)-1.0, (double)0.0, (double)1.0, (double)1.5);
        Assert.assertEquals((double)1.5707963267948966, (double)((Line)t1.apply((Hyperplane)l1)).getAngle(), (double)1.0E-10);
        Line l2 = new Line(new Vector2D(0.0, 0.0), new Vector2D(1.0, 1.0), 1.0E-10);
        Transform t2 = Line.getTransform((double)0.0, (double)0.5, (double)-1.0, (double)0.0, (double)1.0, (double)1.5);
        Assert.assertEquals((double)FastMath.atan2((double)1.0, (double)-2.0), (double)((Line)t2.apply((Hyperplane)l2)).getAngle(), (double)1.0E-10);
    }

    @Test
    public void testIntersection() {
        Line l1 = new Line(new Vector2D(0.0, 1.0), new Vector2D(1.0, 2.0), 1.0E-10);
        Line l2 = new Line(new Vector2D(-1.0, 2.0), new Vector2D(2.0, 1.0), 1.0E-10);
        Vector2D p = l1.intersection(l2);
        Assert.assertEquals((double)0.5, (double)p.getX(), (double)1.0E-10);
        Assert.assertEquals((double)1.5, (double)p.getY(), (double)1.0E-10);
    }
}

