/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.apache.commons.math3.analysis.differentiation.DSCompiler;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.junit.Assert;
import org.junit.Test;

public class DSCompilerTest {
    @Test
    public void testSize() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                long expected = CombinatoricsUtils.binomialCoefficient((int)(i + j), (int)i);
                Assert.assertEquals((long)expected, (long)DSCompiler.getCompiler((int)i, (int)j).getSize());
                Assert.assertEquals((long)expected, (long)DSCompiler.getCompiler((int)j, (int)i).getSize());
            }
        }
    }

    @Test
    public void testIndices() {
        DSCompiler c = DSCompiler.getCompiler((int)0, (int)0);
        this.checkIndices(c.getPartialDerivativeOrders(0), new int[0]);
        c = DSCompiler.getCompiler((int)0, (int)1);
        this.checkIndices(c.getPartialDerivativeOrders(0), new int[0]);
        c = DSCompiler.getCompiler((int)1, (int)0);
        this.checkIndices(c.getPartialDerivativeOrders(0), 0);
        c = DSCompiler.getCompiler((int)1, (int)1);
        this.checkIndices(c.getPartialDerivativeOrders(0), 0);
        this.checkIndices(c.getPartialDerivativeOrders(1), 1);
        c = DSCompiler.getCompiler((int)1, (int)2);
        this.checkIndices(c.getPartialDerivativeOrders(0), 0);
        this.checkIndices(c.getPartialDerivativeOrders(1), 1);
        this.checkIndices(c.getPartialDerivativeOrders(2), 2);
        c = DSCompiler.getCompiler((int)2, (int)1);
        this.checkIndices(c.getPartialDerivativeOrders(0), 0, 0);
        this.checkIndices(c.getPartialDerivativeOrders(1), 1, 0);
        this.checkIndices(c.getPartialDerivativeOrders(2), 0, 1);
        c = DSCompiler.getCompiler((int)1, (int)3);
        this.checkIndices(c.getPartialDerivativeOrders(0), 0);
        this.checkIndices(c.getPartialDerivativeOrders(1), 1);
        this.checkIndices(c.getPartialDerivativeOrders(2), 2);
        this.checkIndices(c.getPartialDerivativeOrders(3), 3);
        c = DSCompiler.getCompiler((int)2, (int)2);
        this.checkIndices(c.getPartialDerivativeOrders(0), 0, 0);
        this.checkIndices(c.getPartialDerivativeOrders(1), 1, 0);
        this.checkIndices(c.getPartialDerivativeOrders(2), 2, 0);
        this.checkIndices(c.getPartialDerivativeOrders(3), 0, 1);
        this.checkIndices(c.getPartialDerivativeOrders(4), 1, 1);
        this.checkIndices(c.getPartialDerivativeOrders(5), 0, 2);
        c = DSCompiler.getCompiler((int)3, (int)1);
        this.checkIndices(c.getPartialDerivativeOrders(0), 0, 0, 0);
        this.checkIndices(c.getPartialDerivativeOrders(1), 1, 0, 0);
        this.checkIndices(c.getPartialDerivativeOrders(2), 0, 1, 0);
        this.checkIndices(c.getPartialDerivativeOrders(3), 0, 0, 1);
        c = DSCompiler.getCompiler((int)1, (int)4);
        this.checkIndices(c.getPartialDerivativeOrders(0), 0);
        this.checkIndices(c.getPartialDerivativeOrders(1), 1);
        this.checkIndices(c.getPartialDerivativeOrders(2), 2);
        this.checkIndices(c.getPartialDerivativeOrders(3), 3);
        this.checkIndices(c.getPartialDerivativeOrders(4), 4);
        c = DSCompiler.getCompiler((int)2, (int)3);
        this.checkIndices(c.getPartialDerivativeOrders(0), 0, 0);
        this.checkIndices(c.getPartialDerivativeOrders(1), 1, 0);
        this.checkIndices(c.getPartialDerivativeOrders(2), 2, 0);
        this.checkIndices(c.getPartialDerivativeOrders(3), 3, 0);
        this.checkIndices(c.getPartialDerivativeOrders(4), 0, 1);
        this.checkIndices(c.getPartialDerivativeOrders(5), 1, 1);
        this.checkIndices(c.getPartialDerivativeOrders(6), 2, 1);
        this.checkIndices(c.getPartialDerivativeOrders(7), 0, 2);
        this.checkIndices(c.getPartialDerivativeOrders(8), 1, 2);
        this.checkIndices(c.getPartialDerivativeOrders(9), 0, 3);
        c = DSCompiler.getCompiler((int)3, (int)2);
        this.checkIndices(c.getPartialDerivativeOrders(0), 0, 0, 0);
        this.checkIndices(c.getPartialDerivativeOrders(1), 1, 0, 0);
        this.checkIndices(c.getPartialDerivativeOrders(2), 2, 0, 0);
        this.checkIndices(c.getPartialDerivativeOrders(3), 0, 1, 0);
        this.checkIndices(c.getPartialDerivativeOrders(4), 1, 1, 0);
        this.checkIndices(c.getPartialDerivativeOrders(5), 0, 2, 0);
        this.checkIndices(c.getPartialDerivativeOrders(6), 0, 0, 1);
        this.checkIndices(c.getPartialDerivativeOrders(7), 1, 0, 1);
        this.checkIndices(c.getPartialDerivativeOrders(8), 0, 1, 1);
        this.checkIndices(c.getPartialDerivativeOrders(9), 0, 0, 2);
        c = DSCompiler.getCompiler((int)4, (int)1);
        this.checkIndices(c.getPartialDerivativeOrders(0), 0, 0, 0, 0);
        this.checkIndices(c.getPartialDerivativeOrders(1), 1, 0, 0, 0);
        this.checkIndices(c.getPartialDerivativeOrders(2), 0, 1, 0, 0);
        this.checkIndices(c.getPartialDerivativeOrders(3), 0, 0, 1, 0);
        this.checkIndices(c.getPartialDerivativeOrders(4), 0, 0, 0, 1);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testIncompatibleParams() {
        DSCompiler.getCompiler((int)3, (int)2).checkCompatibility(DSCompiler.getCompiler((int)4, (int)2));
    }

    @Test(expected=DimensionMismatchException.class)
    public void testIncompatibleOrder() {
        DSCompiler.getCompiler((int)3, (int)3).checkCompatibility(DSCompiler.getCompiler((int)3, (int)2));
    }

    @Test
    public void testSymmetry() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                DSCompiler c = DSCompiler.getCompiler((int)i, (int)j);
                for (int k = 0; k < c.getSize(); ++k) {
                    Assert.assertEquals((long)k, (long)c.getPartialDerivativeIndex(c.getPartialDerivativeOrders(k)));
                }
            }
        }
    }

    @Test
    public void testMultiplicationRules() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        HashMap<String, String> referenceRules = new HashMap<String, String>();
        referenceRules.put("(f*g)", "f * g");
        referenceRules.put("d(f*g)/dx", "f * dg/dx + df/dx * g");
        referenceRules.put("d(f*g)/dy", ((String)referenceRules.get("d(f*g)/dx")).replaceAll("x", "y"));
        referenceRules.put("d(f*g)/dz", ((String)referenceRules.get("d(f*g)/dx")).replaceAll("x", "z"));
        referenceRules.put("d(f*g)/dt", ((String)referenceRules.get("d(f*g)/dx")).replaceAll("x", "t"));
        referenceRules.put("d2(f*g)/dx2", "f * d2g/dx2 + 2 * df/dx * dg/dx + d2f/dx2 * g");
        referenceRules.put("d2(f*g)/dy2", ((String)referenceRules.get("d2(f*g)/dx2")).replaceAll("x", "y"));
        referenceRules.put("d2(f*g)/dz2", ((String)referenceRules.get("d2(f*g)/dx2")).replaceAll("x", "z"));
        referenceRules.put("d2(f*g)/dt2", ((String)referenceRules.get("d2(f*g)/dx2")).replaceAll("x", "t"));
        referenceRules.put("d2(f*g)/dxdy", "f * d2g/dxdy + df/dy * dg/dx + df/dx * dg/dy + d2f/dxdy * g");
        referenceRules.put("d2(f*g)/dxdz", ((String)referenceRules.get("d2(f*g)/dxdy")).replaceAll("y", "z"));
        referenceRules.put("d2(f*g)/dxdt", ((String)referenceRules.get("d2(f*g)/dxdy")).replaceAll("y", "t"));
        referenceRules.put("d2(f*g)/dydz", ((String)referenceRules.get("d2(f*g)/dxdz")).replaceAll("x", "y"));
        referenceRules.put("d2(f*g)/dydt", ((String)referenceRules.get("d2(f*g)/dxdt")).replaceAll("x", "y"));
        referenceRules.put("d2(f*g)/dzdt", ((String)referenceRules.get("d2(f*g)/dxdt")).replaceAll("x", "z"));
        referenceRules.put("d3(f*g)/dx3", "f * d3g/dx3 + 3 * df/dx * d2g/dx2 + 3 * d2f/dx2 * dg/dx + d3f/dx3 * g");
        referenceRules.put("d3(f*g)/dy3", ((String)referenceRules.get("d3(f*g)/dx3")).replaceAll("x", "y"));
        referenceRules.put("d3(f*g)/dz3", ((String)referenceRules.get("d3(f*g)/dx3")).replaceAll("x", "z"));
        referenceRules.put("d3(f*g)/dt3", ((String)referenceRules.get("d3(f*g)/dx3")).replaceAll("x", "t"));
        referenceRules.put("d3(f*g)/dx2dy", "f * d3g/dx2dy + df/dy * d2g/dx2 + 2 * df/dx * d2g/dxdy + 2 * d2f/dxdy * dg/dx + d2f/dx2 * dg/dy + d3f/dx2dy * g");
        referenceRules.put("d3(f*g)/dxdy2", "f * d3g/dxdy2 + 2 * df/dy * d2g/dxdy + d2f/dy2 * dg/dx + df/dx * d2g/dy2 + 2 * d2f/dxdy * dg/dy + d3f/dxdy2 * g");
        referenceRules.put("d3(f*g)/dx2dz", ((String)referenceRules.get("d3(f*g)/dx2dy")).replaceAll("y", "z"));
        referenceRules.put("d3(f*g)/dy2dz", ((String)referenceRules.get("d3(f*g)/dx2dz")).replaceAll("x", "y"));
        referenceRules.put("d3(f*g)/dxdz2", ((String)referenceRules.get("d3(f*g)/dxdy2")).replaceAll("y", "z"));
        referenceRules.put("d3(f*g)/dydz2", ((String)referenceRules.get("d3(f*g)/dxdz2")).replaceAll("x", "y"));
        referenceRules.put("d3(f*g)/dx2dt", ((String)referenceRules.get("d3(f*g)/dx2dz")).replaceAll("z", "t"));
        referenceRules.put("d3(f*g)/dy2dt", ((String)referenceRules.get("d3(f*g)/dx2dt")).replaceAll("x", "y"));
        referenceRules.put("d3(f*g)/dz2dt", ((String)referenceRules.get("d3(f*g)/dx2dt")).replaceAll("x", "z"));
        referenceRules.put("d3(f*g)/dxdt2", ((String)referenceRules.get("d3(f*g)/dxdy2")).replaceAll("y", "t"));
        referenceRules.put("d3(f*g)/dydt2", ((String)referenceRules.get("d3(f*g)/dxdt2")).replaceAll("x", "y"));
        referenceRules.put("d3(f*g)/dzdt2", ((String)referenceRules.get("d3(f*g)/dxdt2")).replaceAll("x", "z"));
        referenceRules.put("d3(f*g)/dxdydz", "f * d3g/dxdydz + df/dz * d2g/dxdy + df/dy * d2g/dxdz + d2f/dydz * dg/dx + df/dx * d2g/dydz + d2f/dxdz * dg/dy + d2f/dxdy * dg/dz + d3f/dxdydz * g");
        referenceRules.put("d3(f*g)/dxdydt", ((String)referenceRules.get("d3(f*g)/dxdydz")).replaceAll("z", "t"));
        referenceRules.put("d3(f*g)/dxdzdt", ((String)referenceRules.get("d3(f*g)/dxdydt")).replaceAll("y", "z"));
        referenceRules.put("d3(f*g)/dydzdt", ((String)referenceRules.get("d3(f*g)/dxdzdt")).replaceAll("x", "y"));
        Field multFieldArrayField = DSCompiler.class.getDeclaredField("multIndirection");
        multFieldArrayField.setAccessible(true);
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 4; ++j) {
                DSCompiler compiler = DSCompiler.getCompiler((int)i, (int)j);
                int[][][] multIndirection = (int[][][])multFieldArrayField.get(compiler);
                for (int k = 0; k < multIndirection.length; ++k) {
                    String product = this.ordersToString(compiler.getPartialDerivativeOrders(k), "(f*g)", "x", "y", "z", "t");
                    StringBuilder rule = new StringBuilder();
                    for (int[] term : multIndirection[k]) {
                        if (rule.length() > 0) {
                            rule.append(" + ");
                        }
                        if (term[0] > 1) {
                            rule.append(term[0]).append(" * ");
                        }
                        rule.append(this.ordersToString(compiler.getPartialDerivativeOrders(term[1]), "f", "x", "y", "z", "t"));
                        rule.append(" * ");
                        rule.append(this.ordersToString(compiler.getPartialDerivativeOrders(term[2]), "g", "x", "y", "z", "t"));
                    }
                    Assert.assertEquals((String)product, referenceRules.get(product), (Object)rule.toString());
                }
            }
        }
    }

    @Test
    public void testCompositionRules() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        HashMap<String, String> referenceRules = new HashMap<String, String>();
        referenceRules.put("(f(g))", "(f(g))");
        referenceRules.put("d(f(g))/dx", "d(f(g))/dg * dg/dx");
        referenceRules.put("d(f(g))/dy", ((String)referenceRules.get("d(f(g))/dx")).replaceAll("x", "y"));
        referenceRules.put("d(f(g))/dz", ((String)referenceRules.get("d(f(g))/dx")).replaceAll("x", "z"));
        referenceRules.put("d(f(g))/dt", ((String)referenceRules.get("d(f(g))/dx")).replaceAll("x", "t"));
        referenceRules.put("d2(f(g))/dx2", "d2(f(g))/dg2 * dg/dx * dg/dx + d(f(g))/dg * d2g/dx2");
        referenceRules.put("d2(f(g))/dy2", ((String)referenceRules.get("d2(f(g))/dx2")).replaceAll("x", "y"));
        referenceRules.put("d2(f(g))/dz2", ((String)referenceRules.get("d2(f(g))/dx2")).replaceAll("x", "z"));
        referenceRules.put("d2(f(g))/dt2", ((String)referenceRules.get("d2(f(g))/dx2")).replaceAll("x", "t"));
        referenceRules.put("d2(f(g))/dxdy", "d2(f(g))/dg2 * dg/dx * dg/dy + d(f(g))/dg * d2g/dxdy");
        referenceRules.put("d2(f(g))/dxdz", ((String)referenceRules.get("d2(f(g))/dxdy")).replaceAll("y", "z"));
        referenceRules.put("d2(f(g))/dxdt", ((String)referenceRules.get("d2(f(g))/dxdy")).replaceAll("y", "t"));
        referenceRules.put("d2(f(g))/dydz", ((String)referenceRules.get("d2(f(g))/dxdz")).replaceAll("x", "y"));
        referenceRules.put("d2(f(g))/dydt", ((String)referenceRules.get("d2(f(g))/dxdt")).replaceAll("x", "y"));
        referenceRules.put("d2(f(g))/dzdt", ((String)referenceRules.get("d2(f(g))/dxdt")).replaceAll("x", "z"));
        referenceRules.put("d3(f(g))/dx3", "d3(f(g))/dg3 * dg/dx * dg/dx * dg/dx + 3 * d2(f(g))/dg2 * dg/dx * d2g/dx2 + d(f(g))/dg * d3g/dx3");
        referenceRules.put("d3(f(g))/dy3", ((String)referenceRules.get("d3(f(g))/dx3")).replaceAll("x", "y"));
        referenceRules.put("d3(f(g))/dz3", ((String)referenceRules.get("d3(f(g))/dx3")).replaceAll("x", "z"));
        referenceRules.put("d3(f(g))/dt3", ((String)referenceRules.get("d3(f(g))/dx3")).replaceAll("x", "t"));
        referenceRules.put("d3(f(g))/dxdy2", "d3(f(g))/dg3 * dg/dx * dg/dy * dg/dy + 2 * d2(f(g))/dg2 * dg/dy * d2g/dxdy + d2(f(g))/dg2 * dg/dx * d2g/dy2 + d(f(g))/dg * d3g/dxdy2");
        referenceRules.put("d3(f(g))/dxdz2", ((String)referenceRules.get("d3(f(g))/dxdy2")).replaceAll("y", "z"));
        referenceRules.put("d3(f(g))/dxdt2", ((String)referenceRules.get("d3(f(g))/dxdy2")).replaceAll("y", "t"));
        referenceRules.put("d3(f(g))/dydz2", ((String)referenceRules.get("d3(f(g))/dxdz2")).replaceAll("x", "y"));
        referenceRules.put("d3(f(g))/dydt2", ((String)referenceRules.get("d3(f(g))/dxdt2")).replaceAll("x", "y"));
        referenceRules.put("d3(f(g))/dzdt2", ((String)referenceRules.get("d3(f(g))/dxdt2")).replaceAll("x", "z"));
        referenceRules.put("d3(f(g))/dx2dy", "d3(f(g))/dg3 * dg/dx * dg/dx * dg/dy + 2 * d2(f(g))/dg2 * dg/dx * d2g/dxdy + d2(f(g))/dg2 * d2g/dx2 * dg/dy + d(f(g))/dg * d3g/dx2dy");
        referenceRules.put("d3(f(g))/dx2dz", ((String)referenceRules.get("d3(f(g))/dx2dy")).replaceAll("y", "z"));
        referenceRules.put("d3(f(g))/dx2dt", ((String)referenceRules.get("d3(f(g))/dx2dy")).replaceAll("y", "t"));
        referenceRules.put("d3(f(g))/dy2dz", ((String)referenceRules.get("d3(f(g))/dx2dz")).replaceAll("x", "y"));
        referenceRules.put("d3(f(g))/dy2dt", ((String)referenceRules.get("d3(f(g))/dx2dt")).replaceAll("x", "y"));
        referenceRules.put("d3(f(g))/dz2dt", ((String)referenceRules.get("d3(f(g))/dx2dt")).replaceAll("x", "z"));
        referenceRules.put("d3(f(g))/dxdydz", "d3(f(g))/dg3 * dg/dx * dg/dy * dg/dz + d2(f(g))/dg2 * dg/dy * d2g/dxdz + d2(f(g))/dg2 * dg/dx * d2g/dydz + d2(f(g))/dg2 * d2g/dxdy * dg/dz + d(f(g))/dg * d3g/dxdydz");
        referenceRules.put("d3(f(g))/dxdydt", ((String)referenceRules.get("d3(f(g))/dxdydz")).replaceAll("z", "t"));
        referenceRules.put("d3(f(g))/dxdzdt", ((String)referenceRules.get("d3(f(g))/dxdydt")).replaceAll("y", "z"));
        referenceRules.put("d3(f(g))/dydzdt", ((String)referenceRules.get("d3(f(g))/dxdzdt")).replaceAll("x", "y"));
        referenceRules.put("d4(f(g))/dx4", "d4(f(g))/dg4 * dg/dx * dg/dx * dg/dx * dg/dx + 6 * d3(f(g))/dg3 * dg/dx * dg/dx * d2g/dx2 + 3 * d2(f(g))/dg2 * d2g/dx2 * d2g/dx2 + 4 * d2(f(g))/dg2 * dg/dx * d3g/dx3 + d(f(g))/dg * d4g/dx4");
        referenceRules.put("d4(f(g))/dy4", ((String)referenceRules.get("d4(f(g))/dx4")).replaceAll("x", "y"));
        referenceRules.put("d4(f(g))/dz4", ((String)referenceRules.get("d4(f(g))/dx4")).replaceAll("x", "z"));
        referenceRules.put("d4(f(g))/dt4", ((String)referenceRules.get("d4(f(g))/dx4")).replaceAll("x", "t"));
        referenceRules.put("d4(f(g))/dx3dy", "d4(f(g))/dg4 * dg/dx * dg/dx * dg/dx * dg/dy + 3 * d3(f(g))/dg3 * dg/dx * dg/dx * d2g/dxdy + 3 * d3(f(g))/dg3 * dg/dx * d2g/dx2 * dg/dy + 3 * d2(f(g))/dg2 * d2g/dx2 * d2g/dxdy + 3 * d2(f(g))/dg2 * dg/dx * d3g/dx2dy + d2(f(g))/dg2 * d3g/dx3 * dg/dy + d(f(g))/dg * d4g/dx3dy");
        referenceRules.put("d4(f(g))/dx3dz", ((String)referenceRules.get("d4(f(g))/dx3dy")).replaceAll("y", "z"));
        referenceRules.put("d4(f(g))/dx3dt", ((String)referenceRules.get("d4(f(g))/dx3dy")).replaceAll("y", "t"));
        referenceRules.put("d4(f(g))/dxdy3", "d4(f(g))/dg4 * dg/dx * dg/dy * dg/dy * dg/dy + 3 * d3(f(g))/dg3 * dg/dy * dg/dy * d2g/dxdy + 3 * d3(f(g))/dg3 * dg/dx * dg/dy * d2g/dy2 + 3 * d2(f(g))/dg2 * d2g/dxdy * d2g/dy2 + 3 * d2(f(g))/dg2 * dg/dy * d3g/dxdy2 + d2(f(g))/dg2 * dg/dx * d3g/dy3 + d(f(g))/dg * d4g/dxdy3");
        referenceRules.put("d4(f(g))/dxdz3", ((String)referenceRules.get("d4(f(g))/dxdy3")).replaceAll("y", "z"));
        referenceRules.put("d4(f(g))/dxdt3", ((String)referenceRules.get("d4(f(g))/dxdy3")).replaceAll("y", "t"));
        referenceRules.put("d4(f(g))/dy3dz", ((String)referenceRules.get("d4(f(g))/dx3dz")).replaceAll("x", "y"));
        referenceRules.put("d4(f(g))/dy3dt", ((String)referenceRules.get("d4(f(g))/dx3dt")).replaceAll("x", "y"));
        referenceRules.put("d4(f(g))/dydz3", ((String)referenceRules.get("d4(f(g))/dxdz3")).replaceAll("x", "y"));
        referenceRules.put("d4(f(g))/dydt3", ((String)referenceRules.get("d4(f(g))/dxdt3")).replaceAll("x", "y"));
        referenceRules.put("d4(f(g))/dz3dt", ((String)referenceRules.get("d4(f(g))/dx3dt")).replaceAll("x", "z"));
        referenceRules.put("d4(f(g))/dzdt3", ((String)referenceRules.get("d4(f(g))/dxdt3")).replaceAll("x", "z"));
        referenceRules.put("d4(f(g))/dx2dy2", "d4(f(g))/dg4 * dg/dx * dg/dx * dg/dy * dg/dy + 4 * d3(f(g))/dg3 * dg/dx * dg/dy * d2g/dxdy + d3(f(g))/dg3 * dg/dx * dg/dx * d2g/dy2 + 2 * d2(f(g))/dg2 * d2g/dxdy * d2g/dxdy + 2 * d2(f(g))/dg2 * dg/dx * d3g/dxdy2 + d3(f(g))/dg3 * d2g/dx2 * dg/dy * dg/dy + 2 * d2(f(g))/dg2 * dg/dy * d3g/dx2dy + d2(f(g))/dg2 * d2g/dx2 * d2g/dy2 + d(f(g))/dg * d4g/dx2dy2");
        referenceRules.put("d4(f(g))/dx2dz2", ((String)referenceRules.get("d4(f(g))/dx2dy2")).replaceAll("y", "z"));
        referenceRules.put("d4(f(g))/dx2dt2", ((String)referenceRules.get("d4(f(g))/dx2dy2")).replaceAll("y", "t"));
        referenceRules.put("d4(f(g))/dy2dz2", ((String)referenceRules.get("d4(f(g))/dx2dz2")).replaceAll("x", "y"));
        referenceRules.put("d4(f(g))/dy2dt2", ((String)referenceRules.get("d4(f(g))/dx2dt2")).replaceAll("x", "y"));
        referenceRules.put("d4(f(g))/dz2dt2", ((String)referenceRules.get("d4(f(g))/dx2dt2")).replaceAll("x", "z"));
        referenceRules.put("d4(f(g))/dx2dydz", "d4(f(g))/dg4 * dg/dx * dg/dx * dg/dy * dg/dz + 2 * d3(f(g))/dg3 * dg/dx * dg/dy * d2g/dxdz + d3(f(g))/dg3 * dg/dx * dg/dx * d2g/dydz + 2 * d3(f(g))/dg3 * dg/dx * d2g/dxdy * dg/dz + 2 * d2(f(g))/dg2 * d2g/dxdy * d2g/dxdz + 2 * d2(f(g))/dg2 * dg/dx * d3g/dxdydz + d3(f(g))/dg3 * d2g/dx2 * dg/dy * dg/dz + d2(f(g))/dg2 * dg/dy * d3g/dx2dz + d2(f(g))/dg2 * d2g/dx2 * d2g/dydz + d2(f(g))/dg2 * d3g/dx2dy * dg/dz + d(f(g))/dg * d4g/dx2dydz");
        referenceRules.put("d4(f(g))/dx2dydt", ((String)referenceRules.get("d4(f(g))/dx2dydz")).replaceAll("z", "t"));
        referenceRules.put("d4(f(g))/dx2dzdt", ((String)referenceRules.get("d4(f(g))/dx2dydt")).replaceAll("y", "z"));
        referenceRules.put("d4(f(g))/dxdy2dz", "d4(f(g))/dg4 * dg/dx * dg/dy * dg/dy * dg/dz + d3(f(g))/dg3 * dg/dy * dg/dy * d2g/dxdz + 2 * d3(f(g))/dg3 * dg/dx * dg/dy * d2g/dydz + 2 * d3(f(g))/dg3 * dg/dy * d2g/dxdy * dg/dz + 2 * d2(f(g))/dg2 * d2g/dxdy * d2g/dydz + 2 * d2(f(g))/dg2 * dg/dy * d3g/dxdydz + d3(f(g))/dg3 * dg/dx * d2g/dy2 * dg/dz + d2(f(g))/dg2 * d2g/dy2 * d2g/dxdz + d2(f(g))/dg2 * dg/dx * d3g/dy2dz + d2(f(g))/dg2 * d3g/dxdy2 * dg/dz + d(f(g))/dg * d4g/dxdy2dz");
        referenceRules.put("d4(f(g))/dxdy2dt", ((String)referenceRules.get("d4(f(g))/dxdy2dz")).replaceAll("z", "t"));
        referenceRules.put("d4(f(g))/dy2dzdt", ((String)referenceRules.get("d4(f(g))/dx2dzdt")).replaceAll("x", "y"));
        referenceRules.put("d4(f(g))/dxdydz2", "d4(f(g))/dg4 * dg/dx * dg/dy * dg/dz * dg/dz + 2 * d3(f(g))/dg3 * dg/dy * dg/dz * d2g/dxdz + 2 * d3(f(g))/dg3 * dg/dx * dg/dz * d2g/dydz + d3(f(g))/dg3 * dg/dx * dg/dy * d2g/dz2 + 2 * d2(f(g))/dg2 * d2g/dxdz * d2g/dydz + d2(f(g))/dg2 * dg/dy * d3g/dxdz2 + d2(f(g))/dg2 * dg/dx * d3g/dydz2 + d3(f(g))/dg3 * d2g/dxdy * dg/dz * dg/dz + 2 * d2(f(g))/dg2 * dg/dz * d3g/dxdydz + d2(f(g))/dg2 * d2g/dxdy * d2g/dz2 + d(f(g))/dg * d4g/dxdydz2");
        referenceRules.put("d4(f(g))/dxdz2dt", ((String)referenceRules.get("d4(f(g))/dxdy2dt")).replaceAll("y", "z"));
        referenceRules.put("d4(f(g))/dydz2dt", ((String)referenceRules.get("d4(f(g))/dxdz2dt")).replaceAll("x", "y"));
        referenceRules.put("d4(f(g))/dxdydt2", ((String)referenceRules.get("d4(f(g))/dxdydz2")).replaceAll("z", "t"));
        referenceRules.put("d4(f(g))/dxdzdt2", ((String)referenceRules.get("d4(f(g))/dxdydt2")).replaceAll("y", "z"));
        referenceRules.put("d4(f(g))/dydzdt2", ((String)referenceRules.get("d4(f(g))/dxdzdt2")).replaceAll("x", "y"));
        referenceRules.put("d4(f(g))/dxdydzdt", "d4(f(g))/dg4 * dg/dx * dg/dy * dg/dz * dg/dt + d3(f(g))/dg3 * dg/dy * dg/dz * d2g/dxdt + d3(f(g))/dg3 * dg/dx * dg/dz * d2g/dydt + d3(f(g))/dg3 * dg/dx * dg/dy * d2g/dzdt + d3(f(g))/dg3 * dg/dy * d2g/dxdz * dg/dt + d2(f(g))/dg2 * d2g/dxdz * d2g/dydt + d2(f(g))/dg2 * dg/dy * d3g/dxdzdt + d3(f(g))/dg3 * dg/dx * d2g/dydz * dg/dt + d2(f(g))/dg2 * d2g/dydz * d2g/dxdt + d2(f(g))/dg2 * dg/dx * d3g/dydzdt + d3(f(g))/dg3 * d2g/dxdy * dg/dz * dg/dt + d2(f(g))/dg2 * dg/dz * d3g/dxdydt + d2(f(g))/dg2 * d2g/dxdy * d2g/dzdt + d2(f(g))/dg2 * d3g/dxdydz * dg/dt + d(f(g))/dg * d4g/dxdydzdt");
        Field compFieldArrayField = DSCompiler.class.getDeclaredField("compIndirection");
        compFieldArrayField.setAccessible(true);
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                DSCompiler compiler = DSCompiler.getCompiler((int)i, (int)j);
                int[][][] compIndirection = (int[][][])compFieldArrayField.get(compiler);
                for (int k = 0; k < compIndirection.length; ++k) {
                    String product = this.ordersToString(compiler.getPartialDerivativeOrders(k), "(f(g))", "x", "y", "z", "t");
                    StringBuilder rule = new StringBuilder();
                    for (int[] term : compIndirection[k]) {
                        if (rule.length() > 0) {
                            rule.append(" + ");
                        }
                        if (term[0] > 1) {
                            rule.append(term[0]).append(" * ");
                        }
                        rule.append(this.orderToString(term[1], "(f(g))", "g"));
                        for (int l = 2; l < term.length; ++l) {
                            rule.append(" * ");
                            rule.append(this.ordersToString(compiler.getPartialDerivativeOrders(term[l]), "g", "x", "y", "z", "t"));
                        }
                    }
                    Assert.assertEquals((String)product, referenceRules.get(product), (Object)rule.toString());
                }
            }
        }
    }

    private void checkIndices(int[] indices, int ... expected) {
        Assert.assertEquals((long)expected.length, (long)indices.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((long)expected[i], (long)indices[i]);
        }
    }

    private String orderToString(int order, String functionName, String parameterName) {
        if (order == 0) {
            return functionName;
        }
        if (order == 1) {
            return "d" + functionName + "/d" + parameterName;
        }
        return "d" + order + functionName + "/d" + parameterName + order;
    }

    private String ordersToString(int[] orders, String functionName, String ... parametersNames) {
        int sumOrders = 0;
        for (int order : orders) {
            sumOrders += order;
        }
        if (sumOrders == 0) {
            return functionName;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('d');
        if (sumOrders > 1) {
            builder.append(sumOrders);
        }
        builder.append(functionName).append('/');
        for (int i = 0; i < orders.length; ++i) {
            if (orders[i] <= 0) continue;
            builder.append('d').append(parametersNames[i]);
            if (orders[i] <= 1) continue;
            builder.append(orders[i]);
        }
        return builder.toString();
    }
}

