/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.internal;

import org.apache.commons.geometry.core.Vector;
import org.apache.commons.numbers.core.Norm;
import org.apache.commons.numbers.core.Sum;

public final class Vectors {
    private Vectors() {
    }

    public static boolean isRealNonZero(double value) {
        return Double.isFinite(value) && value != 0.0;
    }

    public static double checkedNorm(double norm) {
        if (!Vectors.isRealNonZero(norm)) {
            throw Vectors.illegalNorm(norm);
        }
        return norm;
    }

    public static double checkedNorm(Vector<?> vec) {
        return Vectors.checkedNorm(vec.norm());
    }

    public static IllegalArgumentException illegalNorm(double norm) {
        return new IllegalArgumentException("Illegal norm: " + norm);
    }

    public static double norm(double x) {
        return Math.abs(x);
    }

    public static double norm(double x1, double x2) {
        return Math.hypot(x1, x2);
    }

    public static double norm(double x1, double x2, double x3) {
        return Norm.EUCLIDEAN.of(x1, x2, x3);
    }

    public static double normSq(double x) {
        return x * x;
    }

    public static double normSq(double x1, double x2) {
        return x1 * x1 + x2 * x2;
    }

    public static double normSq(double x1, double x2, double x3) {
        return x1 * x1 + x2 * x2 + x3 * x3;
    }

    public static double linearCombination(double a1, double b1, double a2, double b2) {
        return Sum.create().addProduct(a1, b1).addProduct(a2, b2).getAsDouble();
    }

    public static double linearCombination(double a1, double b1, double a2, double b2, double a3, double b3) {
        return Sum.create().addProduct(a1, b1).addProduct(a2, b2).addProduct(a3, b3).getAsDouble();
    }
}

