/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.impl;

import jakarta.xml.ws.WebServiceException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.ds.AbstractOMDataSource;
import org.apache.axiom.om.ds.BlobOMDataSource;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.util.Reader2Writer;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BlockImpl<T, C>
extends AbstractOMDataSource
implements Block<T, C> {
    private static Log log = LogFactory.getLog(BlockImpl.class);
    protected T busObject;
    protected C busContext;
    protected OMElement omElement = null;
    protected QName qName;
    private boolean noQNameAvailable = false;
    protected BlockFactory factory;
    protected boolean consumed = false;
    protected Message parent;

    protected BlockImpl(T busObject, C busContext, QName qName, BlockFactory factory) {
        this.busObject = busObject;
        this.busContext = busContext;
        this.qName = qName;
        this.factory = factory;
    }

    protected BlockImpl(OMElement omElement, C busContext, QName qName, BlockFactory factory) {
        this.omElement = omElement;
        this.busContext = busContext;
        this.qName = qName;
        this.factory = factory;
    }

    protected BlockImpl(C busContext, OMElement omElement, QName qName, BlockFactory factory) {
        this(omElement, busContext, qName, factory);
    }

    @Override
    public final BlockFactory getBlockFactory() {
        return this.factory;
    }

    @Override
    public final Object getBusinessContext() {
        return this.busContext;
    }

    @Override
    public final Message getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Message p) {
        this.parent = p;
    }

    @Override
    public final T getBusinessObject(boolean consume) throws XMLStreamException, WebServiceException {
        if (this.consumed) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"BlockImplErr1", (String)this.getClass().getName()));
        }
        if (this.busObject != null) {
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
        } else {
            this.busObject = this._getBOFromOM(this.omElement, this.busContext);
            this.omElement = null;
        }
        T newBusObject = this.busObject;
        this.setConsumed(consume);
        return newBusObject;
    }

    @Override
    public final QName getQName() throws WebServiceException {
        try {
            if (this.qName == null) {
                if (this.noQNameAvailable) {
                    return null;
                }
                if (this.omElement == null) {
                    try {
                        XMLStreamReader newReader = this._getReaderFromBO(this.busObject, this.busContext);
                        this.busObject = null;
                        OMXMLParserWrapper builder = OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)newReader);
                        this.omElement = builder.getDocumentElement();
                        this.omElement.close(true);
                    }
                    catch (Exception e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Exception occurred while obtaining QName:" + String.valueOf(e)));
                        }
                        if (!this.isElementData()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"The block does not contain an xml element. Processing continues.");
                            }
                            this.noQNameAvailable = true;
                            return null;
                        }
                        throw ExceptionFactory.makeWebServiceException((Throwable)e);
                    }
                }
                this.qName = this.omElement.getQName();
            }
            return this.qName;
        }
        catch (Exception xse) {
            this.setConsumed(true);
            throw ExceptionFactory.makeWebServiceException((Throwable)xse);
        }
    }

    protected final void setQName(QName qName) {
        this.qName = qName;
    }

    @Override
    public final XMLStreamReader getXMLStreamReader(boolean consume) throws XMLStreamException, WebServiceException {
        XMLStreamReader newReader = null;
        if (this.consumed) {
            if (this.getParent() != null && this.getParent().isPostPivot()) {
                return this._postPivot_getXMLStreamReader();
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"BlockImplErr1", (String)this.getClass().getName()));
        }
        if (this.omElement != null) {
            newReader = this.omElement.getXMLStreamReader(!consume);
            if (consume) {
                this.omElement = null;
            }
        } else if (this.busObject != null) {
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
            newReader = this._getReaderFromBO(this.busObject, this.busContext);
        }
        this.setConsumed(consume);
        return newReader;
    }

    public final XMLStreamReader getReader() throws XMLStreamException {
        return this.getXMLStreamReader(true);
    }

    public final void serialize(XMLStreamWriter writer) throws XMLStreamException {
        this.outputTo(writer, this.isDestructiveWrite());
    }

    @Override
    public OMElement getOMElement() throws XMLStreamException, WebServiceException {
        OMElement newOMElement = null;
        boolean consume = true;
        if (this.consumed) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"BlockImplErr1", (String)this.getClass().getName()));
        }
        if (this.omElement != null) {
            newOMElement = this.omElement;
        } else if (this.busObject != null) {
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
            newOMElement = this._getOMFromBO(this.busObject, this.busContext);
        }
        this.setConsumed(consume);
        return newOMElement;
    }

    @Override
    public final boolean isConsumed() {
        return this.consumed;
    }

    public final void setConsumed(boolean consume) {
        if (consume) {
            this.consumed = true;
            this.busObject = null;
            this.busContext = null;
            this.omElement = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Message Block Monitor: Action=Consumed");
                log.trace((Object)JavaUtils.stackToString());
            }
        } else {
            this.consumed = false;
        }
    }

    @Override
    public final boolean isQNameAvailable() {
        return this.qName != null;
    }

    @Override
    public final void outputTo(XMLStreamWriter writer, boolean consume) throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start outputTo");
        }
        if (this.consumed) {
            if (this.getParent() != null && this.getParent().isPostPivot()) {
                this._postPivot_outputTo(writer);
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"BlockImplErr1", (String)this.getClass().getName()));
        }
        if (this.omElement != null) {
            this._outputFromOM(this.omElement, writer, consume);
        } else if (this.busObject != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Write business object");
            }
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
            this._outputFromBO(this.busObject, this.busContext, writer);
        }
        this.setConsumed(consume);
        if (log.isDebugEnabled()) {
            log.debug((Object)"End outputTo");
        }
    }

    protected final void _postPivot_outputTo(XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            QName theQName = this.isQNameAvailable() ? this.getQName() : new QName("unknown");
            log.debug((Object)("The Block for " + String.valueOf(theQName) + " is already consumed and therefore it is not written."));
            log.debug((Object)"If you need this block preserved, please set the org.apache.axis2.jaxws.spi.SAVE_REQUEST_MSG property on the MessageContext.");
        }
    }

    protected final XMLStreamReader _postPivot_getXMLStreamReader() throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            QName theQName = this.isQNameAvailable() ? this.getQName() : new QName("unknown");
            log.debug((Object)("The Block for " + String.valueOf(theQName) + " is already consumed and therefore it is only partially read."));
            log.debug((Object)"If you need this block preserved, please set the org.apache.axis2.jaxws.spi.SAVE_REQUEST_MSG property on the MessageContext.");
        }
        QName qName = this.getQName();
        Object text = "";
        text = qName.getNamespaceURI().length() > 0 ? "<prefix:" + qName.getLocalPart() + " xmlns:prefix='" + qName.getNamespaceURI() + "'/>" : "<" + qName.getLocalPart() + "/>";
        StringReader sr = new StringReader((String)text);
        return StAXUtils.createXMLStreamReader((Reader)sr);
    }

    protected final boolean isBusinessObject() {
        return this.busObject != null;
    }

    @Override
    public final String traceString(String indent) {
        return null;
    }

    protected T _getBOFromBO(T busObject, C busContext, boolean consume) {
        return busObject;
    }

    protected abstract T _getBOFromOM(OMElement var1, C var2) throws XMLStreamException, WebServiceException;

    protected abstract XMLStreamReader _getReaderFromBO(T var1, C var2) throws XMLStreamException, WebServiceException;

    protected OMElement _getOMFromBO(T busObject, C busContext) throws XMLStreamException, WebServiceException {
        XMLStreamReader newReader = this._getReaderFromBO(busObject, busContext);
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)newReader);
        return builder.getDocumentElement();
    }

    protected final void _outputFromReader(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        Reader2Writer r2w = new Reader2Writer(reader);
        r2w.outputTo(writer);
    }

    protected final void _outputFromOM(OMElement omElement, XMLStreamWriter writer, boolean consume) throws XMLStreamException {
        if (consume) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Write using OMElement.serializeAndConsume");
            }
            omElement.serializeAndConsume(writer);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Write Using OMElement.serialize");
            }
            omElement.serialize(writer);
        }
    }

    public OMDataSourceExt copy() throws OMException {
        try {
            String encoding = "utf-8";
            byte[] bytes = this.getXMLBytes(encoding);
            return new BlobOMDataSource(Blobs.createBlob((byte[])bytes), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new OMException((Throwable)e);
        }
    }

    protected abstract void _outputFromBO(T var1, C var2, XMLStreamWriter var3) throws XMLStreamException, WebServiceException;
}

