/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task;

import org.apache.camel.support.task.Task;

abstract class AbstractTask
implements Task {
    static final long NEVER = -1L;
    final String name;
    Task.Status status;
    long firstAttemptTime;
    long lastAttemptTime;
    long nextAttemptTime;
    Throwable cause;

    public AbstractTask(String name) {
        this.name = name;
        this.status = Task.Status.Active;
        this.firstAttemptTime = -1L;
        this.lastAttemptTime = -1L;
        this.nextAttemptTime = -1L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Task.Status getStatus() {
        return this.status;
    }

    @Override
    public long getFirstAttemptTime() {
        return this.firstAttemptTime;
    }

    @Override
    public long getLastAttemptTime() {
        return this.lastAttemptTime;
    }

    @Override
    public long getNextAttemptTime() {
        return this.nextAttemptTime;
    }

    @Override
    public long getCurrentElapsedTime() {
        if (this.firstAttemptTime > 0L) {
            return System.currentTimeMillis() - this.firstAttemptTime;
        }
        return -1L;
    }

    @Override
    public Throwable getException() {
        return this.cause;
    }
}

