#include <math.h>
#include <string.h>

#define LUA_COMPAT_ALL
#include "../src/lauxlib.h"

static double compute_sin(const double x)
{
  return sin(x);
}

static double compute_cos(const double x)
{
  return cos(x);
}

static int compute_trig_function(lua_State *L)
{
  const double argument = lua_tonumber(L, 1);
  const char *selected_function = lua_tostring (L, 2);
  double result;

  if (strcmp(selected_function, "sin") == 0)
    result = compute_sin(argument);
  else if (strcmp(selected_function, "cos") == 0)
    result = compute_cos(argument);
  else
    return 0;

  lua_pushnumber(L, result);

  return 1;  /* One element returned on stack. */
}

static const struct luaL_Reg my_lib[] = {
  {"compute_trig_function", compute_trig_function},
  {NULL, NULL}
};

int luaopen_libtest2(lua_State *L)
{
  luaL_register(L, "my_lib", my_lib);  /* Register all functions belonging to my_lib module. */
  return 1;
}
