/* trap.c -- generate output for the trap test.  See comments in
   lib/texmf.c for what each routine does.  */

#define EXTERN extern
#include "../mfd.h"


/* No #ifdef for the whole file, because we always want to support this.  */


/* This returns true if we can do window operations, else false.  */

boolean
mf_trap_initscreen P1H(void)
{
  return 1;
}

void
mf_trap_updatescreen P1H(void)
{
  fputs ("Calling UPDATESCREEN\n", logfile);
}

void
mf_trap_blankrectangle (left, right, top, bottom)
    screencol left, right;
    screenrow top, bottom;
{
  fprintf (logfile, "\nCalling BLANKRECTANGLE(%d,%d,%d,%d)\n",
           left, right, top, bottom);
}

void
mf_trap_paintrow (row, init_color, transition_vector, vector_size)
    screenrow row;
    pixelcolor init_color;
    transspec transition_vector;
    screencol vector_size;
{
  unsigned k;

  fprintf (logfile, "Calling PAINTROW(%d,%d;", row, init_color);
  for (k = 0; k <= vector_size; k++) {
    fprintf (logfile, "%d", transition_vector[k]);
    if (k != vector_size)
      putc (',', logfile);
    }
  fputs (")\n", logfile);
}
