/*
 * Decompiled with CFR 0.152.
 */
package jaxp;

import java.io.PrintWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SourceValidator
implements ErrorHandler {
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String XS11_CTA_FULL_XPATH_CHECKING_ID = "http://apache.org/xml/features/validation/cta-full-xpath-checking";
    protected static final String SAX_NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String SAX_XMLNS_URIS_FEATURE_ID = "http://xml.org/sax/features/xmlns-uris";
    protected static final String XS11_ASSERT_COMMENT_PI_CHECKING_ID = "http://apache.org/xml/features/validation/assert-comments-and-pi-checking";
    protected static final String IS_SUPPORTING_LOCATION_COORDINATES = "javax.xml.stream.isSupportingLocationCoordinates";
    protected static final String DEFAULT_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    protected static final String XSD11_SCHEMA_LANGUAGE = "http://www.w3.org/XML/XMLSchema/v1.1";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final String DEFAULT_VALIDATION_SOURCE = "sax";
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_GENERATE_SYNTHETIC_ANNOTATIONS = false;
    protected static final boolean DEFAULT_SAX_NAMESPACE_PREFIXES = true;
    protected static final boolean DEFAULT_SAX_XMLNS_URIS = true;
    protected static final boolean DEFAULT_XS11_CTA_XPATH_FULL_CHECKING = false;
    protected static final boolean DEFAULT_XS11_ASSERT_COMMENT_PI_CHECKING = false;
    protected static final boolean DEFAULT_MEMORY_USAGE = false;
    protected final PrintWriter fOut = new PrintWriter(System.out);

    public void validate(Validator validator, Source source, String string, int n, boolean bl) {
        try {
            long l = System.currentTimeMillis();
            long l2 = Runtime.getRuntime().freeMemory();
            for (int i = 0; i < n; ++i) {
                validator.validate(source);
            }
            long l3 = Runtime.getRuntime().freeMemory();
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            long l6 = bl ? l2 - l3 : Long.MIN_VALUE;
            this.printResults(this.fOut, string, l5, l6, n);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            Exception exception2 = exception;
            if (exception instanceof SAXException) {
                exception2 = ((SAXException)exception).getException();
            }
            if (exception2 != null) {
                exception2.printStackTrace(System.err);
            }
            exception.printStackTrace(System.err);
        }
    }

    public void validate(Validator validator, XMLInputFactory xMLInputFactory, String string, int n, boolean bl) {
        try {
            StreamSource streamSource = new StreamSource(string);
            long l = System.currentTimeMillis();
            long l2 = Runtime.getRuntime().freeMemory();
            for (int i = 0; i < n; ++i) {
                XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(streamSource);
                validator.validate(new StAXSource(xMLStreamReader));
                xMLStreamReader.close();
            }
            long l3 = Runtime.getRuntime().freeMemory();
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            long l6 = bl ? l2 - l3 : Long.MIN_VALUE;
            this.printResults(this.fOut, string, l5, l6, n);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            Exception exception2 = exception;
            if (exception instanceof SAXException) {
                exception2 = ((SAXException)exception).getException();
            }
            if (exception2 != null) {
                exception2.printStackTrace(System.err);
            }
            exception.printStackTrace(System.err);
        }
    }

    public void printResults(PrintWriter printWriter, String string, long l, long l2, int n) {
        printWriter.print(string);
        printWriter.print(": ");
        if (n == 1) {
            printWriter.print(l);
        } else {
            printWriter.print(l);
            printWriter.print('/');
            printWriter.print(n);
            printWriter.print('=');
            printWriter.print((float)l / (float)n);
        }
        printWriter.print(" ms");
        if (l2 != Long.MIN_VALUE) {
            printWriter.print(", ");
            printWriter.print(l2);
            printWriter.print(" bytes");
        }
        printWriter.println();
        printWriter.flush();
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    public static void main(String[] stringArray) {
        block78: {
            Object object;
            Object object2;
            if (stringArray.length == 0) {
                SourceValidator.printUsage();
                System.exit(1);
            }
            Vector<Object> vector = null;
            Vector<Object> vector2 = null;
            String string = DEFAULT_SCHEMA_LANGUAGE;
            int n = 1;
            Object object3 = DEFAULT_VALIDATION_SOURCE;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            boolean bl6 = true;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                object2 = stringArray[i];
                if (!((String)object2).startsWith("-")) continue;
                object = ((String)object2).substring(1);
                if (((String)object).equals("l")) {
                    if (++i == stringArray.length) {
                        System.err.println("error: Missing argument to -l option.");
                        continue;
                    }
                    string = stringArray[i];
                    continue;
                }
                if (((String)object).equals("xsd11")) {
                    string = XSD11_SCHEMA_LANGUAGE;
                    continue;
                }
                if (((String)object).equals("x")) {
                    if (++i == stringArray.length) {
                        System.err.println("error: Missing argument to -x option.");
                        continue;
                    }
                    String string2 = stringArray[i];
                    try {
                        int n2 = Integer.parseInt(string2);
                        if (n2 < 1) {
                            System.err.println("error: Repetition must be at least 1.");
                            continue;
                        }
                        n = n2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("error: invalid number (" + string2 + ").");
                    }
                    continue;
                }
                if (((String)object2).equals("-a")) {
                    if (vector == null) {
                        vector = new Vector<Object>();
                    }
                    while (i + 1 < stringArray.length && !((String)(object2 = stringArray[i + 1])).startsWith("-")) {
                        vector.add(object2);
                        ++i;
                    }
                    continue;
                }
                if (((String)object2).equals("-i")) {
                    if (vector2 == null) {
                        vector2 = new Vector<Object>();
                    }
                    while (i + 1 < stringArray.length && !((String)(object2 = stringArray[i + 1])).startsWith("-")) {
                        vector2.add(object2);
                        ++i;
                    }
                    continue;
                }
                if (((String)object2).equals("-vs")) {
                    if (i + 1 >= stringArray.length || ((String)(object2 = stringArray[i + 1])).startsWith("-")) continue;
                    if (((String)object2).equals(DEFAULT_VALIDATION_SOURCE) || ((String)object2).equals("dom") || ((String)object2).equals("stax") || ((String)object2).equals("stream")) {
                        object3 = object2;
                        continue;
                    }
                    System.err.println("error: unknown source type (" + (String)object2 + ").");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("f")) {
                    bl = ((String)object).equals("f");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("hs")) {
                    bl2 = ((String)object).equals("hs");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("va")) {
                    bl3 = ((String)object).equals("va");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("ga")) {
                    bl4 = ((String)object).equals("ga");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("fx")) {
                    bl7 = ((String)object).equals("fx");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("acp")) {
                    bl8 = ((String)object).equals("acp");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("m")) {
                    bl9 = ((String)object).equals("m");
                    continue;
                }
                if (((String)object).equals("h")) {
                    SourceValidator.printUsage();
                    continue;
                }
                System.err.println("error: unknown option (" + (String)object + ").");
            }
            try {
                int n3;
                SourceValidator sourceValidator = new SourceValidator();
                object2 = SchemaFactory.newInstance(string);
                ((SchemaFactory)object2).setErrorHandler(sourceValidator);
                try {
                    ((SchemaFactory)object2).setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                }
                try {
                    ((SchemaFactory)object2).setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                }
                try {
                    ((SchemaFactory)object2).setFeature(VALIDATE_ANNOTATIONS_ID, bl3);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validate-annotations)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validate-annotations)");
                }
                try {
                    ((SchemaFactory)object2).setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl4);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
                }
                if (XSD11_SCHEMA_LANGUAGE.equals(string)) {
                    try {
                        ((SchemaFactory)object2).setFeature(XS11_CTA_FULL_XPATH_CHECKING_ID, bl7);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validation/cta-full-xpath-checking)");
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validation/cta-full-xpath-checking)");
                    }
                }
                if (vector != null && vector.size() > 0) {
                    int n4 = vector.size();
                    Source[] sourceArray = new StreamSource[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        sourceArray[n3] = new StreamSource((String)vector.elementAt(n3));
                    }
                    object = ((SchemaFactory)object2).newSchema(sourceArray);
                } else {
                    object = ((SchemaFactory)object2).newSchema();
                }
                Validator validator = ((Schema)object).newValidator();
                validator.setErrorHandler(sourceValidator);
                try {
                    validator.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                }
                try {
                    validator.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                }
                try {
                    validator.setFeature(VALIDATE_ANNOTATIONS_ID, bl3);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validate-annotations)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validate-annotations)");
                }
                try {
                    validator.setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl4);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
                }
                if (XSD11_SCHEMA_LANGUAGE.equals(string)) {
                    try {
                        validator.setFeature(XS11_CTA_FULL_XPATH_CHECKING_ID, bl7);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validation/cta-full-xpath-checking)");
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validation/cta-full-xpath-checking)");
                    }
                }
                if (XSD11_SCHEMA_LANGUAGE.equals(string)) {
                    try {
                        validator.setFeature(XS11_ASSERT_COMMENT_PI_CHECKING_ID, bl8);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validation/assert-comments-and-pi-checking)");
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validation/assert-comments-and-pi-checking)");
                    }
                }
                if (vector2 == null || vector2.size() <= 0) break block78;
                int n5 = vector2.size();
                if (((String)object3).equals(DEFAULT_VALIDATION_SOURCE)) {
                    XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                    xMLReader.setFeature(SAX_NAMESPACE_PREFIXES_FEATURE_ID, bl5);
                    xMLReader.setFeature(SAX_XMLNS_URIS_FEATURE_ID, bl6);
                    xMLReader.setErrorHandler(sourceValidator);
                    for (int i = 0; i < n5; ++i) {
                        String string3 = (String)vector2.elementAt(i);
                        SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(string3));
                        sourceValidator.validate(validator, sAXSource, string3, n, bl9);
                    }
                    break block78;
                }
                if (((String)object3).equals("dom")) {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    documentBuilder.setErrorHandler(sourceValidator);
                    for (int i = 0; i < n5; ++i) {
                        String string4 = (String)vector2.elementAt(i);
                        Document document = documentBuilder.parse(string4);
                        DOMSource dOMSource = new DOMSource(document);
                        dOMSource.setSystemId(string4);
                        sourceValidator.validate(validator, dOMSource, string4, n, bl9);
                    }
                    break block78;
                }
                if (((String)object3).equals("stax")) {
                    XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                    try {
                        xMLInputFactory.setProperty(IS_SUPPORTING_LOCATION_COORDINATES, Boolean.TRUE);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    for (int i = 0; i < n5; ++i) {
                        String string5 = (String)vector2.elementAt(i);
                        sourceValidator.validate(validator, xMLInputFactory, string5, n, bl9);
                    }
                    break block78;
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    String string6 = (String)vector2.elementAt(n3);
                    StreamSource streamSource = new StreamSource(string6);
                    sourceValidator.validate(validator, streamSource, string6, n, bl9);
                }
            }
            catch (SAXParseException sAXParseException) {
            }
            catch (Exception exception) {
                Object object4;
                System.err.println("error: Parse error occurred - " + exception.getMessage());
                if (exception instanceof SAXException && (object2 = ((SAXException)exception).getException()) != null) {
                    object4 = object2;
                }
                ((Throwable)object4).printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java jaxp.SourceValidator (options) ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -l name     Select schema language by name.");
        System.err.println("  -x number   Select number of repetitions.");
        System.err.println("  -a uri ...  Provide a list of schema documents");
        System.err.println("  -i uri ...  Provide a list of instance documents to validate");
        System.err.println("  -vs source  Select validation source (sax|dom|stax|stream)");
        System.err.println("  -f   | -F   Turn on/off Schema full checking.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -hs  | -HS  Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -va  | -VA  Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -ga  | -GA  Turn on/off generation of synthetic schema annotations.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -m   | -M   Turn on/off memory usage report");
        System.err.println("  -xsd11      Turn on/off XSD 1.1 support.");
        System.err.println("  -fx         Turn on/off full XPath 2.0 checks with CTA when working");
        System.err.println("              with XSD 1.1.");
        System.err.println("  -acp        Turn on/off assert comments and PI processing when working");
        System.err.println("              with XSD 1.1.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Schema language:                    http://www.w3.org/2001/XMLSchema");
        System.err.println("  Repetition:                         1");
        System.err.println("  Validation source:                  sax");
        System.err.print("  Schema full checking:               ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:        ");
        System.err.println("off");
        System.err.print("  Validate annotations:               ");
        System.err.println("off");
        System.err.print("  Generate synthetic annotations:     ");
        System.err.println("off");
        System.err.print("  Memory:                             ");
        System.err.println("off");
        System.err.print("  XSD 1.1 [-xsd11 option]:            ");
        System.err.println("off");
        System.err.print("  CTA XPath 2.0:                      ");
        System.err.println("off");
        System.err.print("  Assert comments and PI processing:  ");
        System.err.println("off");
        System.err.println();
        System.err.println("notes:");
        System.err.println("  The speed and memory results from this program should NOT be used as the");
        System.err.println("  basis of parser performance comparison! Real analytical methods should be");
        System.err.println("  used. For better results, perform multiple document validations within the");
        System.err.println("  same virtual machine to remove class loading from parse time and memory usage.");
    }
}

