/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public final class AuthenticatorTransport
implements Comparable<AuthenticatorTransport> {
    @JsonValue
    @NonNull
    private final String id;
    public static final AuthenticatorTransport USB = new AuthenticatorTransport("usb");
    public static final AuthenticatorTransport NFC = new AuthenticatorTransport("nfc");
    public static final AuthenticatorTransport BLE = new AuthenticatorTransport("ble");
    @Deprecated
    public static final AuthenticatorTransport HYBRID = new AuthenticatorTransport("hybrid");
    public static final AuthenticatorTransport INTERNAL = new AuthenticatorTransport("internal");

    public static AuthenticatorTransport[] values() {
        return new AuthenticatorTransport[]{USB, NFC, BLE, HYBRID, INTERNAL};
    }

    @JsonCreator
    public static AuthenticatorTransport of(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return Stream.of(AuthenticatorTransport.values()).filter(v -> v.getId().equals(id)).findAny().orElseGet(() -> new AuthenticatorTransport(id));
    }

    public static AuthenticatorTransport valueOf(String name) {
        switch (name) {
            case "USB": {
                return USB;
            }
            case "NFC": {
                return NFC;
            }
            case "BLE": {
                return BLE;
            }
            case "HYBRID": {
                return HYBRID;
            }
            case "INTERNAL": {
                return INTERNAL;
            }
        }
        throw new IllegalArgumentException("No constant com.yubico.webauthn.data.AuthenticatorTransport." + name);
    }

    @Override
    public int compareTo(AuthenticatorTransport other) {
        return this.id.compareTo(other.id);
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorTransport)) {
            return false;
        }
        AuthenticatorTransport other = (AuthenticatorTransport)o;
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticatorTransport(id=" + this.getId() + ")";
    }

    @Generated
    private AuthenticatorTransport(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }
}

