/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.scheduler;

import com.github.openjson.JSONArray;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.behavior.AjaxCallbackBehavior;
import org.wicketstuff.jquery.core.utils.DateUtils;
import org.wicketstuff.kendo.ui.scheduler.ISchedulerConverter;
import org.wicketstuff.kendo.ui.scheduler.ISchedulerVisitor;
import org.wicketstuff.kendo.ui.scheduler.SchedulerEvent;
import org.wicketstuff.kendo.ui.scheduler.SchedulerModel;

public class SchedulerModelBehavior
extends AjaxCallbackBehavior {
    private static final long serialVersionUID = 1L;
    private final SchedulerModel model;
    private final ISchedulerConverter converter;

    public SchedulerModelBehavior(SchedulerModel model, ISchedulerConverter converter) {
        this.model = model;
        this.converter = (ISchedulerConverter)Args.notNull((Object)converter, (String)"converter");
    }

    protected void setModelStartDate(SchedulerModel model, ZonedDateTime datetime) {
        model.setStart(datetime);
    }

    protected void setModelUntilDate(SchedulerModel model, ZonedDateTime datetime) {
        model.setUntil(datetime);
    }

    protected String getResponse(IRequestParameters parameters) {
        long startTimestamp = parameters.getParameterValue("start").toLong(0L);
        long untilTimestamp = parameters.getParameterValue("end").toLong(0L);
        JSONArray payload = new JSONArray();
        if (this.model != null) {
            this.setModelStartDate(this.model, DateUtils.toZonedDateTime((long)startTimestamp, (ZoneOffset)this.converter.getOffset()));
            this.setModelUntilDate(this.model, DateUtils.toZonedDateTime((long)untilTimestamp, (ZoneOffset)this.converter.getOffset()));
            List list = (List)this.model.getObject();
            if (list != null) {
                for (SchedulerEvent event : list) {
                    if (this.model instanceof ISchedulerVisitor) {
                        event.accept((ISchedulerVisitor)((Object)this.model));
                    }
                    if (!event.isVisible()) continue;
                    payload.put((Object)this.converter.toJson(event));
                }
            }
        }
        return payload.toString();
    }
}

