/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import com.google.common.base.Strings;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.net.URISupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.ClientStorageLoadContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.slf4j.Logger;

public class LoadClientStorageServices
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String SUPPORT_FORM_FIELD = "shib_idp_ls_supported";
    @Nonnull
    @NotEmpty
    public static final String SUCCESS_FORM_FIELD = "shib_idp_ls_success";
    @Nonnull
    @NotEmpty
    public static final String VALUE_FORM_FIELD = "shib_idp_ls_value";
    @Nonnull
    @NotEmpty
    public static final String EXCEPTION_FORM_FIELD = "shib_idp_ls_exception";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LoadClientStorageServices.class);
    private boolean useLocalStorage = false;
    @Nonnull
    private Map<String, ClientStorageService> storageServices = CollectionSupport.emptyMap();
    @Nullable
    private ClientStorageLoadContext clientStorageLoadCtx;

    public void setUseLocalStorage(boolean flag) {
        this.checkSetterPreconditions();
        this.useLocalStorage = flag;
    }

    public void setStorageServices(@Nullable Collection<ClientStorageService> services) {
        this.checkSetterPreconditions();
        this.storageServices = services != null ? (Map)((NonnullSupplier)services.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(ClientStorageService::getStorageName, ss -> ss)))).get() : CollectionSupport.emptyMap();
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.storageServices.isEmpty()) {
            this.log.debug("{} No ClientStorageServices supplied, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.clientStorageLoadCtx = (ClientStorageLoadContext)profileRequestContext.getSubcontext(ClientStorageLoadContext.class);
        if (this.clientStorageLoadCtx == null) {
            this.log.debug("{} No ClientStorageLoadContext found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String param;
        HttpServletRequest httpRequest = this.getHttpServletRequest();
        if (httpRequest == null) {
            this.log.error("{} HttpServletRequest not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        boolean useLS = this.useLocalStorage;
        if (useLS && ((param = httpRequest.getParameter(SUPPORT_FORM_FIELD)) == null || !Boolean.valueOf(param).booleanValue())) {
            this.log.debug("{} Local storage not available, backing off to cookies", (Object)this.getLogPrefix());
            useLS = false;
        }
        assert (this.clientStorageLoadCtx != null);
        for (String storageKey : this.clientStorageLoadCtx.getStorageKeys()) {
            ClientStorageService storageService = this.storageServices.get(storageKey);
            if (storageService == null) {
                this.log.error("{} ClientStorageService with storage name '{}' missing from configuration", (Object)this.getLogPrefix(), (Object)storageKey);
                continue;
            }
            if (useLS) {
                this.loadFromLocalStorage(httpRequest, storageService);
                continue;
            }
            this.loadFromCookie(httpRequest, storageService, ClientStorageService.ClientStorageSource.COOKIE);
        }
        assert (this.clientStorageLoadCtx != null);
        profileRequestContext.removeSubcontext((BaseContext)this.clientStorageLoadCtx);
    }

    private void loadFromCookie(@Nonnull HttpServletRequest httpRequest, @Nonnull ClientStorageService storageService, @Nonnull ClientStorageService.ClientStorageSource source) {
        Optional<Object> cookie = Optional.empty();
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            cookie = Arrays.asList(cookies).stream().filter(c -> c != null && c.getName().equals(storageService.getStorageName())).findFirst();
        }
        if (!cookie.isPresent() || Strings.isNullOrEmpty((String)((Cookie)cookie.get()).getValue())) {
            this.log.debug("{} No cookie data present, initializing StorageService '{}' to empty state", (Object)this.getLogPrefix(), (Object)storageService.getId());
            storageService.load(null, source);
        } else {
            this.log.debug("{} Initializing StorageService '{}' from cookie", (Object)this.getLogPrefix(), (Object)storageService.getId());
            storageService.load(URISupport.doURLDecode((String)((Cookie)cookie.orElseThrow()).getValue()), source);
        }
    }

    private void loadFromLocalStorage(@Nonnull HttpServletRequest httpRequest, @Nonnull ClientStorageService storageService) {
        String param = httpRequest.getParameter("shib_idp_ls_success." + storageService.getStorageName());
        if (param == null || !Boolean.valueOf(param).booleanValue()) {
            param = httpRequest.getParameter("shib_idp_ls_exception." + storageService.getStorageName());
            this.log.debug("{} Load from local storage failed ({}), initializing StorageService '{}' to empty state", new Object[]{this.getLogPrefix(), param, storageService.getId()});
            storageService.load(null, ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE);
            return;
        }
        param = httpRequest.getParameter("shib_idp_ls_value." + storageService.getStorageName());
        if (param == null || param.isEmpty()) {
            this.log.debug("{} No local storage data present, checking for a cookie set by older storage implementation", (Object)this.getLogPrefix(), (Object)storageService.getId());
            this.loadFromCookie(httpRequest, storageService, ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE);
        } else {
            this.log.debug("{} Initializing StorageService '{}' from local storage data", (Object)this.getLogPrefix(), (Object)storageService.getId());
            storageService.load(param, ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE);
        }
    }
}

