/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.authentication.storage;

import com.github.benmanes.caffeine.cache.Expiry;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import lombok.Generated;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.util.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultifactorAuthenticationTrustRecordExpiry
implements Expiry<String, MultifactorAuthenticationTrustRecord> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationTrustRecordExpiry.class);

    public long expireAfterCreate(@Nonnull String key, @Nonnull MultifactorAuthenticationTrustRecord value, long currentTime) {
        if (value.getExpirationDate() == null) {
            LOGGER.trace("Multifactor trust record [{}] will never expire", (Object)value);
            return Long.MAX_VALUE;
        }
        if (value.isExpired()) {
            LOGGER.trace("Multifactor trust record [{}] is expired", (Object)value);
            return 0L;
        }
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS);
        ZonedDateTime zonedExp = DateTimeUtils.zonedDateTimeOf((Date)value.getExpirationDate()).truncatedTo(ChronoUnit.SECONDS);
        long nanos = Duration.between(now, zonedExp).toNanos();
        LOGGER.trace("Multifactor trust record [{}] expires in [{}] nanoseconds", (Object)value, (Object)nanos);
        return nanos;
    }

    public long expireAfterUpdate(@Nonnull String key, @Nonnull MultifactorAuthenticationTrustRecord value, long currentTime, long currentDuration) {
        return this.expireAfterCreate(key, value, currentTime);
    }

    public long expireAfterRead(@Nonnull String key, @Nonnull MultifactorAuthenticationTrustRecord value, long currentTime, long currentDuration) {
        return this.expireAfterCreate(key, value, currentTime);
    }
}

