/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.attribute.DefaultAttributeDefinition;
import org.apereo.cas.oidc.assurance.AssuranceVerifiedClaimsProducer;
import org.apereo.cas.oidc.claims.OidcAttributeDefinition;
import org.apereo.cas.oidc.claims.OidcIdTokenClaimCollector;
import org.apereo.cas.util.CollectionUtils;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class OidcSimpleIdTokenClaimCollector
implements OidcIdTokenClaimCollector {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcSimpleIdTokenClaimCollector.class);
    protected final AttributeDefinitionStore attributeDefinitionStore;
    protected final AssuranceVerifiedClaimsProducer assuranceVerifiedClaimsProducer;

    @Override
    public void conclude(JwtClaims claims) {
        Set claimNames = Set.copyOf(claims.getClaimNames());
        claimNames.forEach(claimName -> this.attributeDefinitionStore.locateAttributeDefinition(claimName, OidcAttributeDefinition.class).or(() -> this.attributeDefinitionStore.locateAttributeDefinitionByName(claimName, OidcAttributeDefinition.class)).stream().filter(definition -> StringUtils.isNotBlank((CharSequence)definition.getTrustFramework())).findFirst().ifPresent(definition -> this.assuranceVerifiedClaimsProducer.produce(claims, (String)claimName, definition.getTrustFramework())));
    }

    @Override
    public void collect(JwtClaims jwtClaims, String name, List<Object> values) {
        if (!values.isEmpty()) {
            Optional<OidcAttributeDefinition> attributeDefinition = this.attributeDefinitionStore.locateAttributeDefinition(name, OidcAttributeDefinition.class).or(() -> this.attributeDefinitionStore.locateAttributeDefinitionByName(name, OidcAttributeDefinition.class));
            Object finalValue = attributeDefinition.map(definition -> definition.toAttributeValue(values)).orElseGet(() -> values.size() == 1 ? values.getFirst() : values);
            attributeDefinition.stream().filter(OidcAttributeDefinition::isStructured).filter(definition -> definition.getName().contains(".")).findFirst().ifPresentOrElse(definition -> this.collectStructuredClaim(jwtClaims, (OidcAttributeDefinition)((Object)definition), finalValue), () -> {
                String claimName = attributeDefinition.map(DefaultAttributeDefinition::getName).orElse(name);
                this.collectClaim(jwtClaims, claimName, finalValue);
            });
        }
    }

    protected void collectClaim(JwtClaims claims, String name, Object finalValue) {
        LOGGER.debug("Collecting ID token claim [{}] with value(s) [{}]", (Object)name, finalValue);
        claims.setClaim(name, finalValue);
    }

    protected void collectStructuredClaim(JwtClaims claims, OidcAttributeDefinition definition, Object finalValue) {
        List claimNames = Splitter.on((char)'.').splitToList((CharSequence)definition.getName().trim());
        HashMap<String, Object> structuredClaims = new HashMap<String, Object>();
        String lastClaimName = (String)claimNames.getLast();
        structuredClaims.put(lastClaimName, finalValue);
        for (int i = claimNames.size() - 2; i >= 1; --i) {
            Object lastClaimValue = structuredClaims.remove(lastClaimName);
            String currentClaimName = (String)claimNames.get(i);
            structuredClaims.put(currentClaimName, CollectionUtils.wrap((String)lastClaimName, lastClaimValue));
            lastClaimName = currentClaimName;
        }
        LOGGER.debug("Collecting structured ID token claim [{}] with nested entries [{}]", claimNames.getFirst(), structuredClaims);
        claims.setClaim((String)claimNames.getFirst(), structuredClaims);
    }

    @Generated
    public OidcSimpleIdTokenClaimCollector(AttributeDefinitionStore attributeDefinitionStore, AssuranceVerifiedClaimsProducer assuranceVerifiedClaimsProducer) {
        this.attributeDefinitionStore = attributeDefinitionStore;
        this.assuranceVerifiedClaimsProducer = assuranceVerifiedClaimsProducer;
    }
}

