/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ExtendWith(value={ClusterTestExtensions.class})
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\tUb\u0001\u0002\u0010 \u0001\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006e\u0001!\ta\r\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006\u0007\u0002!\t\u0001\u000f\u0005\u0006\u000b\u0002!\t\u0001\u000f\u0005\u0006\u001d\u0002!\t\u0001\u000f\u0005\u0006!\u0002!\t\u0001\u000f\u0005\u0006%\u0002!Ia\u0015\u0005\u0006M\u0002!\t\u0001\u000f\u0005\u0006Q\u0002!\t\u0001\u000f\u0005\u0006U\u0002!\t\u0001\u000f\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u001d\t\u0019\u0002\u0001Q\u0001\n9D\u0001\"!\u0006\u0001\u0005\u0004%I!\u001c\u0005\b\u0003/\u0001\u0001\u0015!\u0003o\u0011\u0019\tI\u0002\u0001C\u0005q!1\u00111\u0004\u0001\u0005\u0002aBa!a\b\u0001\t\u0003A\u0004BBA\u0012\u0001\u0011\u0005\u0001\b\u0003\u0004\u0002(\u0001!\t\u0001\u000f\u0005\u0007\u0003W\u0001A\u0011\u0001\u001d\t\u000f\u0005=\u0002\u0001\"\u0003\u00022!9\u0011\u0011\t\u0001\u0005\n\u0005\r\u0003bBA*\u0001\u0011%\u0011Q\u000b\u0005\b\u00037\u0002A\u0011BA/\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000bCq!!&\u0001\t\u0013\t9\nC\u0004\u00024\u0002!I!!.\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\n92\t\\5f]R\fVo\u001c;bgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003A\u0005\naa]3sm\u0016\u0014(\"\u0001\u0012\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\rdWo\u001d;feB\u0011Q\u0006M\u0007\u0002])\u0011q&I\u0001\u0005i\u0016\u001cH/\u0003\u00022]\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003iY\u0002\"!\u000e\u0001\u000e\u0003}AQa\u000b\u0002A\u00021\nA\u0004^3ti\u0006cG/\u001a:DY&,g\u000e^)v_R\f7OU3rk\u0016\u001cH\u000fF\u0001:!\t1#(\u0003\u0002<O\t!QK\\5uQ\t\u0019Q\b\u0005\u0002?\u00036\tqH\u0003\u0002A]\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\t{$aC\"mkN$XM\u001d+fgR\f\u0001\u0006^3ti\u0006cG/\u001a:DY&,g\u000e^)v_R\f7OU3rk\u0016\u001cHOV1mS\u0012\fG/Z(oYfD#\u0001B\u001f\u0002;Q,7\u000f^\"mS\u0016tG/U;pi\u0006\u001chi\u001c:TGJ\fW.V:feNDC!B\u001fH\u0011\u0006)A/\u001f9fg2\n\u0011\nJ\u0001K\u0013\tYE*\u0001\u0002[\u0017*\u0011QjP\u0001\u0005)f\u0004X-\u0001\ruKN$\u0018\t\u001c;fe&\u0003\u0018+^8uCN\u0014V-];fgRD#AB\u001f\u0002IQ,7\u000f^!mi\u0016\u00148\t\\5f]R\fVo\u001c;bg&sg/\u00197jIJ+\u0017/^3tiND#aB\u001f\u0002?\u0015D\b/Z2u\u0013:4\u0018\r\\5e%\u0016\fX/Z:u/&$\b.T3tg\u0006<W\rF\u0002:)fCa!\u0016\u0005\u0005\u0002\u00041\u0016\u0001\u0003:v]:\f'\r\\3\u0011\u0007\u0019:\u0016(\u0003\u0002YO\tAAHY=oC6,g\bC\u0003[\u0011\u0001\u00071,A\bfqB,7\r^3e\u001b\u0016\u001c8/Y4f!\ta6M\u0004\u0002^CB\u0011alJ\u0007\u0002?*\u0011\u0001mI\u0001\u0007yI|w\u000e\u001e \n\u0005\t<\u0013A\u0002)sK\u0012,g-\u0003\u0002eK\n11\u000b\u001e:j]\u001eT!AY\u0014\u0002[Q,7\u000f^!mi\u0016\u00148\t\\5f]R\fVo\u001c;bg&sg/\u00197jI\u0016sG/\u001b;z\u0007>l'-\u001b8bi&|g\u000e\u000b\u0002\n{\u0005QB/Z:u\u00032$XM]\"mS\u0016tG/U;pi\u0006\u001c()\u00193Ja\"\u0012!\"P\u00011i\u0016\u001cH\u000fR3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001c\u0018J\u001c<bY&$g)\u001b7uKJ\u001cu.\u001c2j]\u0006$\u0018n\u001c8)\u0005-i\u0014aF7bi\u000eDWk]3s\u00072LWM\u001c;F]RLG/[3t+\u0005q\u0007cA8um6\t\u0001O\u0003\u0002re\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003g\u001e\n!bY8mY\u0016\u001cG/[8o\u0013\t)\bO\u0001\u0003MSN$\b#\u0002\u0014xs\u00065\u0011B\u0001=(\u0005\u0019!V\u000f\u001d7feA\u0019!0!\u0003\u000e\u0003mT!\u0001`?\u0002\u000bE,x\u000e^1\u000b\u0005y|\u0018AB2p[6|gNC\u0002#\u0003\u0003QA!a\u0001\u0002\u0006\u00051\u0011\r]1dQ\u0016T!!a\u0002\u0002\u0007=\u0014x-C\u0002\u0002\fm\u0014\u0011c\u00117jK:$\u0018+^8uC\u0016sG/\u001b;z!\r1\u0013qB\u0005\u0004\u0003#9#A\u0002#pk\ndW-\u0001\rnCR\u001c\u0007.V:fe\u000ec\u0017.\u001a8u\u000b:$\u0018\u000e^5fg\u0002\nq\"\\1uG\"L\u0005/\u00128uSRLWm]\u0001\u0011[\u0006$8\r[%q\u000b:$\u0018\u000e^5fg\u0002\n!e]3ukB$Um]2sS\n,7\t\\5f]R\fVo\u001c;bg6\u000bGo\u00195UKN$\u0018A\t;fgR$Um]2sS\n,7\t\\5f]R\fVo\u001c;bg6\u000bGo\u00195Fq\u0006\u001cG\u000f\u000b\u0002\u0012{\u0005!C/Z:u\t\u0016\u001c8M]5cK\u000ec\u0017.\u001a8u#V|G/Y:NCR\u001c\u0007\u000eU1si&\fG\u000e\u000b\u0002\u0013{\u00051C/Z:u\u00072LWM\u001c;Rk>$\u0018m]+ogV\u0004\bo\u001c:uK\u0012,e\u000e^5usRK\b/Z:)\u0005Mi\u0014!\u0007;fgR\u001cE.[3oiF+x\u000e^1t'\u0006t\u0017\u000e^5{K\u0012D#\u0001F\u001f\u0002?Q,7\u000f^\"mS\u0016tG/U;pi\u0006\u001cx+\u001b;i\t\u00164\u0017-\u001e7u\u001d\u0006lW\r\u000b\u0002\u0016{\u0005Qb/\u001a:jMf$Um]2sS\n,WI\u001c;jif\fVo\u001c;bgR)\u0011(a\r\u00028!1\u0011Q\u0007\fA\u0002e\fa!\u001a8uSRL\bbBA\u001d-\u0001\u0007\u00111H\u0001\u0007cV|G/Y:\u0011\rq\u000bidWA\u0007\u0013\r\ty$\u001a\u0002\u0004\u001b\u0006\u0004\u0018A\u0004;p\u00072LWM\u001c;F]RLG/\u001f\u000b\u0006s\u0006\u0015\u0013q\n\u0005\b\u0003\u000f:\u0002\u0019AA%\u0003\u0011)8/\u001a:\u0011\t\u0019\nYeW\u0005\u0004\u0003\u001b:#AB(qi&|g\u000eC\u0004\u0002R]\u0001\r!!\u0013\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\f!\u0002^8Ja\u0016sG/\u001b;z)\rI\u0018q\u000b\u0005\b\u00033B\u0002\u0019AA%\u0003\tI\u0007/\u0001\u000beKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u0005\u0003?\nI\bE\u0004\u0002b\u0005-\u00140!\u001c\u000e\u0005\u0005\r$\u0002BA3\u0003O\nA!\u001e;jY*\u0011\u0011\u0011N\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002@\u0005\r\u0004cBA1\u0003WZ\u0016q\u000e\t\u0005\u0003c\n9(\u0004\u0002\u0002t)!\u0011QOA4\u0003\u0011a\u0017M\\4\n\t\u0005E\u00111\u000f\u0005\b\u0003wJ\u0002\u0019AA?\u0003\u00191\u0017\u000e\u001c;feB\u0019!0a \n\u0007\u0005\u00055PA\tDY&,g\u000e^)v_R\fg)\u001b7uKJ\fqd]3oI\u0012+7o\u0019:jE\u0016\u001cE.[3oiF+x\u000e^1t%\u0016\fX/Z:u)\u0011\t9)a%\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017S1!!$~\u0003!\u0011X-];fgR\u001c\u0018\u0002BAI\u0003\u0017\u0013A\u0004R3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001c(+Z:q_:\u001cX\rC\u0004\u0002|i\u0001\r!! \u0002#\u0005dG/\u001a:F]RLG/_)v_R\f7\u000f\u0006\u0005\u0002\u001a\u0006}\u0015\u0011UAU!\u0011\t\t(a'\n\t\u0005u\u00151\u000f\u0002\u0005->LG\r\u0003\u0004\u00026m\u0001\r!\u001f\u0005\b\u0003G[\u0002\u0019AAS\u0003\u0015\tG\u000e^3s!\u0019a\u0016QH.\u0002(B)a%a\u0013\u0002\u000e!9\u00111V\u000eA\u0002\u00055\u0016\u0001\u0004<bY&$\u0017\r^3P]2L\bc\u0001\u0014\u00020&\u0019\u0011\u0011W\u0014\u0003\u000f\t{w\u000e\\3b]\u0006\t\u0012\r\u001c;fe\u000ec\u0017.\u001a8u#V|G/Y:\u0015\r\u0005]\u0016QZAj!\u001d\tI,a0z\u0003\u0003l!!a/\u000b\u0007\u0005u&/A\u0004nkR\f'\r\\3\n\t\u0005}\u00121\u0018\t\u0007\u0003\u0007\fI-!'\u000e\u0005\u0005\u0015'bAAd{\u0006I\u0011N\u001c;fe:\fGn]\u0005\u0005\u0003\u0017\f)MA\bLC\u001a\\\u0017MR;ukJ,\u0017*\u001c9m\u0011\u001d\ty\r\ba\u0001\u0003#\fqA]3rk\u0016\u001cH\u000f\u0005\u0004]\u0003{I\u0018Q\u0015\u0005\b\u0003Wc\u0002\u0019AAW\u0003q\u0019XM\u001c3BYR,'o\u00117jK:$\u0018+^8uCN\u0014V-];fgR$b!!7\u0002`\u0006m\b\u0003BAE\u00037LA!!8\u0002\f\nI\u0012\t\u001c;fe\u000ec\u0017.\u001a8u#V|G/Y:SKN\u0004xN\\:f\u0011\u001d\t\t/\ba\u0001\u0003G\fq!\u001a8ue&,7\u000f\u0005\u0004\u0002f\u0006=\u0018Q\u001f\b\u0005\u0003O\fYOD\u0002_\u0003SL\u0011\u0001K\u0005\u0004\u0003[<\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003c\f\u0019P\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tio\n\t\u0004u\u0006]\u0018bAA}w\n)2\t\\5f]R\fVo\u001c;b\u00032$XM]1uS>t\u0007bBAV;\u0001\u0007\u0011Q\u0016\u0015\b\u0001\u0005}(q\u0003B\r!\u0011\u0011\tAa\u0005\u000e\u0005\t\r!\u0002\u0002B\u0003\u0005\u000f\t\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u000b\t\t%!1B\u0001\u0004CBL'\u0002\u0002B\u0007\u0005\u001f\tqA[;qSR,'O\u0003\u0003\u0003\u0012\u0005\u0015\u0011!\u00026v]&$\u0018\u0002\u0002B\u000b\u0005\u0007\u0011!\"\u0012=uK:$w+\u001b;i\u0003\u00151\u0018\r\\;fY\t\u0011Yb\t\u0002\u0003\u001eA!!q\u0004B\u0012\u001b\t\u0011\tCC\u0002\u0003\u00129JAA!\n\u0003\"\t)2\t\\;ti\u0016\u0014H+Z:u\u000bb$XM\\:j_:\u001c\bf\u0002\u0001\u0003*\t]!\u0011\u0007\t\u0005\u0005W\u0011i#\u0004\u0002\u0003\b%!!q\u0006B\u0004\u0005\r!\u0016mZ\u0011\u0003\u0005g\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class ClientQuotasRequestTest {
    private final ClusterInstance cluster;
    private final List<Tuple2<ClientQuotaEntity, Object>> matchUserClientEntities;
    private final List<Tuple2<ClientQuotaEntity, Object>> matchIpEntities;

    @ClusterTest
    public void testAlterClientQuotasRequest() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client-id")}))).asJava());
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)15000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)15000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)None$.MODULE$)}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)None$.MODULE$)}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)5000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)5000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.3)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)BoxesRunTime.boxToDouble((double)12.3))}))));
    }

    @ClusterTest
    public void testAlterClientQuotasRequestValidateOnly() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)23.45)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50000.0)))}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0)))}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)None$.MODULE$)}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)None$.MODULE$)}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
    }

    @ClusterTest(types={Type.ZK})
    public void testClientQuotasForScramUsers() {
        String userName = "user";
        this.cluster.createAdminClient().alterUserScramCredentials(Arrays.asList(new UserScramCredentialUpsertion(userName, new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 4096), "password"))).all().get();
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)userName)}))).asJava());
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
    }

    @ClusterTest
    public void testAlterIpQuotasRequest() {
        String knownHost = "1.2.3.4";
        String unknownHost = "2.3.4.5";
        ClientQuotaEntity entity = this.toIpEntity((Option<String>)new Some((Object)knownHost));
        ClientQuotaEntity defaultEntity = this.toIpEntity((Option<String>)new Some(null));
        ClientQuotaFilterComponent entityFilter = ClientQuotaFilterComponent.ofEntity((String)"ip", (String)knownHost);
        ClientQuotaFilterComponent defaultEntityFilter = ClientQuotaFilterComponent.ofDefaultEntity((String)"ip");
        ClientQuotaFilterComponent allIpEntityFilter = ClientQuotaFilterComponent.ofEntityType((String)"ip");
        this.verifyIpQuotas$1(allIpEntityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)100.0)))}))), false);
        this.verifyIpQuotas$1(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)100.0))})), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)150.0)))}))), false);
        this.verifyIpQuotas$1(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0))})), unknownHost);
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)200.0)))}))), false);
        this.verifyIpQuotas$1(defaultEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})), unknownHost);
        this.verifyIpQuotas$1(allIpEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)None$.MODULE$)}))), false);
        this.verifyIpQuotas$1(entityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)None$.MODULE$)}))), false);
        this.verifyIpQuotas$1(allIpEntityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
    }

    @ClusterTest
    public void testAlterClientQuotasInvalidRequests() {
        ObjectRef entity = ObjectRef.create((Object)new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"")}))).asJava()));
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"name")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.5)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.5)))}))), true));
    }

    private void expectInvalidRequestWithMessage(Function0<BoxedUnit> runnable, String expectedMessage) {
        InvalidRequestException exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> runnable.apply$mcV$sp());
        Assertions.assertTrue((boolean)exception.getMessage().contains(expectedMessage), (String)new StringBuilder(29).append("Expected message ").append(exception).append(" to contain ").append(expectedMessage).toString());
    }

    @ClusterTest
    public void testAlterClientQuotasInvalidEntityCombination() {
        ClientQuotaEntity userAndIpEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.2.3.4")}))).asJava());
        ClientQuotaEntity clientAndIpEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.2.3.4")}))).asJava());
        String expectedExceptionMessage = "Invalid quota entity combination";
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(userAndIpEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception).append(" to contain ").append(expectedExceptionMessage).toString());
        Object var4_4 = null;
        Object var5_5 = null;
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(clientAndIpEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception2).append(" to contain ").append(expectedExceptionMessage).toString());
    }

    @ClusterTest
    public void testAlterClientQuotasBadIp() {
        ClientQuotaEntity invalidHostPatternEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"not a valid host because it has spaces")}))).asJava());
        ClientQuotaEntity unresolvableHostEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"RFC2606.invalid")}))).asJava());
        String expectedExceptionMessage = "not a valid IP";
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(invalidHostPatternEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception).append(" to contain ").append(expectedExceptionMessage).toString());
        Object var4_4 = null;
        Object var5_5 = null;
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(unresolvableHostEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception2).append(" to contain ").append(expectedExceptionMessage).toString());
    }

    @ClusterTest
    public void testDescribeClientQuotasInvalidFilterCombination() {
        ClientQuotaFilterComponent ipFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"ip");
        ClientQuotaFilterComponent userFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"user");
        ClientQuotaFilterComponent clientIdFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"client-id");
        String expectedExceptionMessage = "Invalid entity filter component combination";
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable)() -> this.describeClientQuotas(ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ipFilterComponent, (List)new .colon.colon((Object)userFilterComponent, (List)Nil$.MODULE$))).asJava()));
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception).append(" to contain ").append(expectedExceptionMessage).toString());
        Object var5_5 = null;
        Object var6_6 = null;
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable)() -> this.describeClientQuotas(ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ipFilterComponent, (List)new .colon.colon((Object)clientIdFilterComponent, (List)Nil$.MODULE$))).asJava()));
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception2).append(" to contain ").append(expectedExceptionMessage).toString());
    }

    private List<Tuple2<ClientQuotaEntity, Object>> matchUserClientEntities() {
        return this.matchUserClientEntities;
    }

    private List<Tuple2<ClientQuotaEntity, Object>> matchIpEntities() {
        return this.matchIpEntities;
    }

    private void setupDescribeClientQuotasMatchTest() {
        scala.collection.immutable.Map userClientQuotas = this.matchUserClientEntities().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ClientQuotaEntity e = (ClientQuotaEntity)x0$1._1();
                double v = x0$1._2$mcD$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"request_percentage", (Object)new Some((Object)BoxesRunTime.boxToDouble((double)v)))})));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map ipQuotas = this.matchIpEntities().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ClientQuotaEntity e = (ClientQuotaEntity)x0$2._1();
                double v = x0$2._2$mcD$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"connection_creation_rate", (Object)new Some((Object)BoxesRunTime.boxToDouble((double)v)))})));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map<ClientQuotaEntity, KafkaFutureImpl<Void>> result = this.alterClientQuotas((scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>>)((scala.collection.immutable.Map)userClientQuotas.$plus$plus((IterableOnce)ipQuotas)), false);
        ((List)this.matchUserClientEntities().$plus$plus(this.matchIpEntities())).foreach((Function1 & Serializable)e -> (Void)((KafkaFutureImpl)result.apply(e._1())).get(10L, TimeUnit.SECONDS));
    }

    @ClusterTest
    public void testDescribeClientQuotasMatchExact() {
        this.setupDescribeClientQuotasMatchTest();
        this.matchUserClientEntities().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-1"), (Object)new Some((Object)"client-id-2")), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-3"), (Object)new Some((Object)"client-id-1")), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-2"), (Object)new Some(null)), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-4"), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)new Some(null), (Object)new Some((Object)"client-id-2")), (List)new .colon.colon((Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"client-id-1")), (List)new .colon.colon((Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"client-id-3")), (List)Nil$.MODULE$))))))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Option u = (Option)x0$2._1();
                Option c = (Option)x0$2._2();
                return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)Option$.MODULE$.option2Iterable(u.map((Function1 & Serializable)x$1 -> new Tuple2((Object)"user", x$1))).$plus$plus((IterableOnce)c.map((Function1 & Serializable)x$2 -> new Tuple2((Object)"client-id", x$2)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
            }
            throw new MatchError(null);
        }).foreach((Function1 & Serializable)e -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$7(this, e);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testDescribeClientQuotasMatchPartial() {
        void var166_130;
        Tuple2 tuple2;
        void testMatchEntities$1_expectedMatchSize;
        void testMatchEntities$1_partition;
        Object var153_120;
        Tuple2 tuple22;
        void testMatchEntities$1_expectedMatchSize2;
        void testMatchEntities$1_partition2;
        Object var140_110;
        Tuple2 tuple23;
        void testMatchEntities$1_expectedMatchSize3;
        void testMatchEntities$1_partition3;
        Object var127_100;
        Tuple2 tuple24;
        void testMatchEntities$1_expectedMatchSize4;
        void testMatchEntities$1_partition4;
        Object var114_90;
        Tuple2 tuple25;
        void testMatchEntities$1_expectedMatchSize5;
        void testMatchEntities$1_partition5;
        Object var101_80;
        Tuple2 tuple26;
        void testMatchEntities$1_expectedMatchSize6;
        void testMatchEntities$1_partition6;
        Object var88_70;
        Tuple2 tuple27;
        void testMatchEntities$1_expectedMatchSize7;
        void testMatchEntities$1_partition7;
        Object var75_60;
        Tuple2 tuple28;
        void testMatchEntities$1_expectedMatchSize8;
        void testMatchEntities$1_partition8;
        Object var62_50;
        Tuple2 tuple29;
        void testMatchEntities$1_expectedMatchSize9;
        void testMatchEntities$1_partition9;
        Object var49_40;
        Tuple2 tuple210;
        void testMatchEntities$1_expectedMatchSize10;
        void testMatchEntities$1_partition10;
        Object var36_30;
        Tuple2 tuple211;
        void testMatchEntities$1_expectedMatchSize11;
        void testMatchEntities$1_partition11;
        Object var23_20;
        Tuple2 tuple212;
        void testMatchEntities$1_expectedMatchSize12;
        void testMatchEntities$1_partition12;
        Object var10_10;
        Tuple2 tuple213;
        void testMatchEntities$1_partition13;
        this.setupDescribeClientQuotasMatchTest();
        Function1 & Serializable intersect = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$5(entity));
        int testMatchEntities$1_expectedMatchSize13 = 3;
        ClientQuotaFilter testMatchEntities$1_filter = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user-1"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect2 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter, (Function1)testMatchEntities$1_partition13, testMatchEntities$1_expectedMatchSize13);
        long l = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple213 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime + testMatchEntities$1_tryUntilNoAssertionError_waitTime) {
                tuple213 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var13_8 = null;
        Tuple2 tuple214 = tuple213;
        if (tuple214 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either = (Either)tuple214._1();
        if (!(var10_10 instanceof Left)) {
            if (var10_10 instanceof Right) {
                throw (AssertionError)((Right)var10_10).value();
            }
            throw new MatchError((Object)var10_10);
        }
        ((Left)var10_10).value();
        intersect2 = null;
        tuple214 = null;
        var10_10 = null;
        Object var1_3 = null;
        intersect = null;
        Function1 & Serializable intersect3 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$6(entity));
        boolean bl = false;
        ClientQuotaFilter testMatchEntities$1_filter2 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"unknown"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect4 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter2, (Function1)testMatchEntities$1_partition12, (int)testMatchEntities$1_expectedMatchSize12);
        long l2 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime2 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple212 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime2 + testMatchEntities$1_tryUntilNoAssertionError_waitTime2) {
                tuple212 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime2), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var26_18 = null;
        Tuple2 tuple215 = tuple212;
        if (tuple215 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either2 = (Either)tuple215._1();
        if (!(var23_20 instanceof Left)) {
            if (var23_20 instanceof Right) {
                throw (AssertionError)((Right)var23_20).value();
            }
            throw new MatchError((Object)var23_20);
        }
        ((Left)var23_20).value();
        intersect4 = null;
        tuple215 = null;
        var23_20 = null;
        Object var14_13 = null;
        intersect3 = null;
        Function1 & Serializable intersect5 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$7(entity));
        int n = 2;
        ClientQuotaFilter testMatchEntities$1_filter3 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"client-id-2"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect6 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter3, (Function1)testMatchEntities$1_partition11, (int)testMatchEntities$1_expectedMatchSize11);
        long l3 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime3 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple211 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime3 + testMatchEntities$1_tryUntilNoAssertionError_waitTime3) {
                tuple211 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime3), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var39_28 = null;
        Tuple2 tuple216 = tuple211;
        if (tuple216 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either3 = (Either)tuple216._1();
        if (!(var36_30 instanceof Left)) {
            if (var36_30 instanceof Right) {
                throw (AssertionError)((Right)var36_30).value();
            }
            throw new MatchError((Object)var36_30);
        }
        ((Left)var36_30).value();
        intersect6 = null;
        tuple216 = null;
        var36_30 = null;
        Object var27_23 = null;
        intersect5 = null;
        Function1 & Serializable intersect7 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$8(entity));
        int n2 = 2;
        ClientQuotaFilter testMatchEntities$1_filter4 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect8 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter4, (Function1)testMatchEntities$1_partition10, (int)testMatchEntities$1_expectedMatchSize10);
        long l4 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime4 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime4 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple210 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime4 + testMatchEntities$1_tryUntilNoAssertionError_waitTime4) {
                tuple210 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime4), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var52_38 = null;
        Tuple2 tuple217 = tuple210;
        if (tuple217 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either4 = (Either)tuple217._1();
        if (!(var49_40 instanceof Left)) {
            if (var49_40 instanceof Right) {
                throw (AssertionError)((Right)var49_40).value();
            }
            throw new MatchError((Object)var49_40);
        }
        ((Left)var49_40).value();
        intersect8 = null;
        tuple217 = null;
        var49_40 = null;
        Object var40_33 = null;
        intersect7 = null;
        Function1 & Serializable intersect9 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$9(entity));
        boolean bl2 = true;
        ClientQuotaFilter testMatchEntities$1_filter5 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user-2"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect10 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter5, (Function1)testMatchEntities$1_partition9, (int)testMatchEntities$1_expectedMatchSize9);
        long l5 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime5 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime5 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple29 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime5 + testMatchEntities$1_tryUntilNoAssertionError_waitTime5) {
                tuple29 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime5), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var65_48 = null;
        Tuple2 tuple218 = tuple29;
        if (tuple218 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either5 = (Either)tuple218._1();
        if (!(var62_50 instanceof Left)) {
            if (var62_50 instanceof Right) {
                throw (AssertionError)((Right)var62_50).value();
            }
            throw new MatchError((Object)var62_50);
        }
        ((Left)var62_50).value();
        intersect10 = null;
        tuple218 = null;
        var62_50 = null;
        Object var53_43 = null;
        intersect9 = null;
        Function1 & Serializable intersect11 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$10(entity));
        boolean bl3 = false;
        ClientQuotaFilter testMatchEntities$1_filter6 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"client-id-1"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect12 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter6, (Function1)testMatchEntities$1_partition8, (int)testMatchEntities$1_expectedMatchSize8);
        long l6 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime6 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime6 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime6 + testMatchEntities$1_tryUntilNoAssertionError_waitTime6) {
                tuple28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime6), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var78_58 = null;
        Tuple2 tuple219 = tuple28;
        if (tuple219 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either6 = (Either)tuple219._1();
        if (!(var75_60 instanceof Left)) {
            if (var75_60 instanceof Right) {
                throw (AssertionError)((Right)var75_60).value();
            }
            throw new MatchError((Object)var75_60);
        }
        ((Left)var75_60).value();
        intersect12 = null;
        tuple219 = null;
        var75_60 = null;
        Object var66_53 = null;
        intersect11 = null;
        Function1 & Serializable intersect13 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$11(entity));
        int n3 = 4;
        ClientQuotaFilter testMatchEntities$1_filter7 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"user"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect14 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter7, (Function1)testMatchEntities$1_partition7, (int)testMatchEntities$1_expectedMatchSize7);
        long l7 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime7 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime7 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple27 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime7 + testMatchEntities$1_tryUntilNoAssertionError_waitTime7) {
                tuple27 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime7), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var91_68 = null;
        Tuple2 tuple220 = tuple27;
        if (tuple220 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either7 = (Either)tuple220._1();
        if (!(var88_70 instanceof Left)) {
            if (var88_70 instanceof Right) {
                throw (AssertionError)((Right)var88_70).value();
            }
            throw new MatchError((Object)var88_70);
        }
        ((Left)var88_70).value();
        intersect14 = null;
        tuple220 = null;
        var88_70 = null;
        Object var79_63 = null;
        intersect13 = null;
        Function1 & Serializable intersect15 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$12(entity));
        int n4 = 10;
        ClientQuotaFilter testMatchEntities$1_filter8 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"user"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect16 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter8, (Function1)testMatchEntities$1_partition6, (int)testMatchEntities$1_expectedMatchSize6);
        long l8 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime8 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime8 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime8 + testMatchEntities$1_tryUntilNoAssertionError_waitTime8) {
                tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime8), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var104_78 = null;
        Tuple2 tuple221 = tuple26;
        if (tuple221 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either8 = (Either)tuple221._1();
        if (!(var101_80 instanceof Left)) {
            if (var101_80 instanceof Right) {
                throw (AssertionError)((Right)var101_80).value();
            }
            throw new MatchError((Object)var101_80);
        }
        ((Left)var101_80).value();
        intersect16 = null;
        tuple221 = null;
        var101_80 = null;
        Object var92_73 = null;
        intersect15 = null;
        Function1 & Serializable intersect17 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$13(entity));
        boolean bl4 = true;
        ClientQuotaFilter testMatchEntities$1_filter9 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"client-id"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect18 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter9, (Function1)testMatchEntities$1_partition5, (int)testMatchEntities$1_expectedMatchSize5);
        long l9 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime9 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime9 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime9 + testMatchEntities$1_tryUntilNoAssertionError_waitTime9) {
                tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime9), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var117_88 = null;
        Tuple2 tuple222 = tuple25;
        if (tuple222 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either9 = (Either)tuple222._1();
        if (!(var114_90 instanceof Left)) {
            if (var114_90 instanceof Right) {
                throw (AssertionError)((Right)var114_90).value();
            }
            throw new MatchError((Object)var114_90);
        }
        ((Left)var114_90).value();
        intersect18 = null;
        tuple222 = null;
        var114_90 = null;
        Object var105_83 = null;
        intersect17 = null;
        Function1 & Serializable intersect19 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$14(entity));
        int n5 = 7;
        ClientQuotaFilter testMatchEntities$1_filter10 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"client-id"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect20 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter10, (Function1)testMatchEntities$1_partition4, (int)testMatchEntities$1_expectedMatchSize4);
        long l10 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime10 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime10 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime10 + testMatchEntities$1_tryUntilNoAssertionError_waitTime10) {
                tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime10), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var130_98 = null;
        Tuple2 tuple223 = tuple24;
        if (tuple223 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either10 = (Either)tuple223._1();
        if (!(var127_100 instanceof Left)) {
            if (var127_100 instanceof Right) {
                throw (AssertionError)((Right)var127_100).value();
            }
            throw new MatchError((Object)var127_100);
        }
        ((Left)var127_100).value();
        intersect20 = null;
        tuple223 = null;
        var127_100 = null;
        Object var118_93 = null;
        intersect19 = null;
        Function1 & Serializable intersect21 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$15(entity));
        int n6 = 2;
        ClientQuotaFilter testMatchEntities$1_filter11 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"ip"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect22 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter11, (Function1)testMatchEntities$1_partition3, (int)testMatchEntities$1_expectedMatchSize3);
        long l11 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime11 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime11 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime11 + testMatchEntities$1_tryUntilNoAssertionError_waitTime11) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime11), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var143_108 = null;
        Tuple2 tuple224 = tuple23;
        if (tuple224 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either11 = (Either)tuple224._1();
        if (!(var140_110 instanceof Left)) {
            if (var140_110 instanceof Right) {
                throw (AssertionError)((Right)var140_110).value();
            }
            throw new MatchError((Object)var140_110);
        }
        ((Left)var140_110).value();
        intersect22 = null;
        tuple224 = null;
        var140_110 = null;
        Object var131_103 = null;
        intersect21 = null;
        Function1 & Serializable intersect23 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$16(entity));
        int n7 = 13;
        ClientQuotaFilter testMatchEntities$1_filter12 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        JFunction0.mcV.sp & Serializable intersect24 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter12, (Function1)testMatchEntities$1_partition2, (int)testMatchEntities$1_expectedMatchSize2);
        long l12 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime12 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime12 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime12 + testMatchEntities$1_tryUntilNoAssertionError_waitTime12) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime12), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var156_118 = null;
        Tuple2 tuple225 = tuple22;
        if (tuple225 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either12 = (Either)tuple225._1();
        if (!(var153_120 instanceof Left)) {
            if (var153_120 instanceof Right) {
                throw (AssertionError)((Right)var153_120).value();
            }
            throw new MatchError((Object)var153_120);
        }
        ((Left)var153_120).value();
        intersect24 = null;
        tuple225 = null;
        var153_120 = null;
        Object var144_113 = null;
        intersect23 = null;
        Function1 & Serializable intersect25 = (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$17(x$3));
        boolean bl5 = false;
        ClientQuotaFilter testMatchEntities$1_filter13 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        JFunction0.mcV.sp & Serializable intersect26 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter13, (Function1)testMatchEntities$1_partition, (int)testMatchEntities$1_expectedMatchSize);
        long l13 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime13 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime13 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime13 + testMatchEntities$1_tryUntilNoAssertionError_waitTime13) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime13), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var169_128 = null;
        Tuple2 tuple226 = tuple2;
        if (tuple226 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either13 = (Either)tuple226._1();
        if (var166_130 instanceof Left) {
            ((Left)var166_130).value();
            return;
        }
        if (var166_130 instanceof Right) {
            throw (AssertionError)((Right)var166_130).value();
        }
        throw new MatchError((Object)var166_130);
    }

    @ClusterTest
    public void testClientQuotasUnsupportedEntityTypes() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other"), (Object)"name")}))).asJava());
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty()));
    }

    @ClusterTest
    public void testClientQuotasSanitized() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user with spaces")}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
    }

    @ClusterTest
    public void testClientQuotasWithDefaultName() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"<default>")}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"client-id"), (List)Nil$.MODULE$)).asJava()));
        Predef$.MODULE$.assert(result.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private void verifyDescribeEntityQuotas(ClientQuotaEntity entity, scala.collection.immutable.Map<String, Object> quotas) {
        void var8_11;
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 5000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                ClientQuotasRequestTest.$anonfun$verifyDescribeEntityQuotas$1(this, entity, quotas);
                BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                right = new Left((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var12_7 = null;
            Object var13_8 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var11_6 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        if (var8_11 instanceof Left) {
            ((Left)var8_11).value();
            return;
        }
        if (var8_11 instanceof Right) {
            throw (AssertionError)((Right)var8_11).value();
        }
        throw new MatchError((Object)var8_11);
    }

    private ClientQuotaEntity toClientEntity(Option<String> user, Option<String> clientId) {
        return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)Option$.MODULE$.option2Iterable(user.map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), x$4))).$plus$plus((IterableOnce)clientId.map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), x$5)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
    }

    private ClientQuotaEntity toIpEntity(Option<String> ip) {
        return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Option$.MODULE$.option2Iterable(ip.map((Function1 & Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), x$6))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
    }

    private java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> describeClientQuotas(ClientQuotaFilter filter) {
        KafkaFutureImpl result = new KafkaFutureImpl();
        this.sendDescribeClientQuotasRequest(filter).complete(result);
        try {
            return (java.util.Map)result.get();
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private DescribeClientQuotasResponse sendDescribeClientQuotasRequest(ClientQuotaFilter filter) {
        DescribeClientQuotasRequest request = (DescribeClientQuotasRequest)new DescribeClientQuotasRequest.Builder(filter).build();
        return (DescribeClientQuotasResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(DescribeClientQuotasResponse.class));
    }

    private Void alterEntityQuotas(ClientQuotaEntity entity, scala.collection.immutable.Map<String, Option<Object>> alter, boolean validateOnly) {
        try {
            return (Void)((KafkaFutureImpl)this.alterClientQuotas((scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), alter)}))), validateOnly).apply((Object)entity)).get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private scala.collection.mutable.Map<ClientQuotaEntity, KafkaFutureImpl<Void>> alterClientQuotas(scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>> request, boolean validateOnly) {
        scala.collection.immutable.Iterable entries = (scala.collection.immutable.Iterable)request.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
                scala.collection.immutable.Map alter = (scala.collection.immutable.Map)x0$1._2();
                Collection ops = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)alter.map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        String key = (String)x0$2._1();
                        Option value = (Option)x0$2._2();
                        return new ClientQuotaAlteration.Op(key, (Double)value.map((Function1 & Serializable)x -> ClientQuotasRequestTest.$anonfun$alterClientQuotas$3(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    }
                    throw new MatchError(null);
                })).asJavaCollection();
                return new ClientQuotaAlteration(entity, ops);
            }
            throw new MatchError(null);
        });
        java.util.Map response = CollectionConverters$.MODULE$.MapHasAsJava((Map)request.map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e._1()), (Object)new KafkaFutureImpl()))).asJava();
        this.sendAlterClientQuotasRequest((Iterable<ClientQuotaAlteration>)entries, validateOnly).complete(response);
        scala.collection.mutable.Map result = CollectionConverters$.MODULE$.MapHasAsScala(response).asScala();
        Assertions.assertEquals((int)request.size(), (int)result.size());
        request.foreach((Function1 & Serializable)e -> {
            ClientQuotasRequestTest.$anonfun$alterClientQuotas$5(result, e);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    private AlterClientQuotasResponse sendAlterClientQuotasRequest(Iterable<ClientQuotaAlteration> entries, boolean validateOnly) {
        AlterClientQuotasRequest request = (AlterClientQuotasRequest)new AlterClientQuotasRequest.Builder(CollectionConverters$.MODULE$.IterableHasAsJava(entries).asJavaCollection(), validateOnly).build();
        return (AlterClientQuotasResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(AlterClientQuotasResponse.class));
    }

    public static final /* synthetic */ void $anonfun$testAlterIpQuotasRequest$2(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatches$1, String unknownHost$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            java.util.Map props = (java.util.Map)x0$1._2();
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"connection_creation_rate"})), (Object)CollectionConverters$.MODULE$.MapHasAsScala(props).asScala().keySet());
            Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)expectedMatches$1.apply((Object)entity)), (Double)((Double)props.get("connection_creation_rate")));
            String entityName = (String)entity.entries().get("ip");
            InetAddress entityIp = entityName == null ? InetAddress.getByName(unknownHost$1) : InetAddress.getByName(entityName);
            int currentServerQuota = ((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala($this.cluster.brokerSocketServers()).asScala().head()).connectionQuotas().connectionRateForIp(entityIp);
            Assertions.assertTrue((Math.abs(BoxesRunTime.unboxToDouble((Object)expectedMatches$1.apply((Object)entity)) - (double)currentServerQuota) < 0.01 ? 1 : 0) != 0, (String)new StringBuilder(33).append("Connection quota of ").append(entity).append(" is not ").append(expectedMatches$1.apply((Object)entity)).append(" but ").append(currentServerQuota).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAlterIpQuotasRequest$1(ClientQuotasRequestTest $this, ClientQuotaFilterComponent entityFilter$1, scala.collection.immutable.Map expectedMatches$1, String unknownHost$1) {
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = $this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)entityFilter$1, (List)Nil$.MODULE$)).asJava()));
        Assertions.assertEquals((Object)expectedMatches$1.keySet(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().keySet());
        CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testAlterIpQuotasRequest$2($this, expectedMatches$1, unknownHost$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyIpQuotas$1(ClientQuotaFilterComponent entityFilter, scala.collection.immutable.Map expectedMatches, String unknownHost$1) {
        void var9_12;
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 15000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                ClientQuotasRequestTest.$anonfun$testAlterIpQuotasRequest$1(this, entityFilter, expectedMatches, unknownHost$1);
                BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                right = new Left((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var13_8 = null;
            Object var14_9 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        if (var9_12 instanceof Left) {
            ((Left)var9_12).value();
            return;
        }
        if (var9_12 instanceof Right) {
            throw (AssertionError)((Right)var9_12).value();
        }
        throw new MatchError((Object)var9_12);
    }

    private final java.util.Map matchEntity$1(ClientQuotaEntity entity) {
        scala.collection.mutable.Iterable components = (scala.collection.mutable.Iterable)CollectionConverters$.MODULE$.MapHasAsScala(entity.entries()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String entityType = (String)x0$1._1();
                String entityName = (String)x0$1._2();
                switch (entityName == null ? 0 : entityName.hashCode()) {
                    case 0: {
                        if (entityName != null) break;
                        return ClientQuotaFilterComponent.ofDefaultEntity((String)entityType);
                    }
                }
                return ClientQuotaFilterComponent.ofEntity((String)entityType, (String)entityName);
            }
            throw new MatchError(null);
        });
        return this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)components.toList()).asJava()));
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$3(ClientQuotasRequestTest $this, ClientQuotaEntity e$1, double v$1) {
        java.util.Map result = $this.matchEntity$1(e$1);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertTrue((result.get(e$1) != null ? 1 : 0) != 0);
        Double value = (Double)((java.util.Map)result.get(e$1)).get("request_percentage");
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((double)Predef$.MODULE$.Double2double(value), (double)v$1, (double)1.0E-6);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$2(ClientQuotasRequestTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            void var10_12;
            Tuple2 tuple2;
            ClientQuotaEntity e = (ClientQuotaEntity)x0$1._1();
            double v = x0$1._2$mcD$sp();
            long l = 100L;
            long tryUntilNoAssertionError_waitTime = 15000L;
            long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                void tryUntilNoAssertionError_pause;
                Right right;
                try {
                    ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$3($this, e, v);
                    BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                    right = new Left((Object)$anonfun$tryUntilNoAssertionError$1_res);
                }
                catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                    right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
                }
                Object var14_8 = null;
                Object var15_9 = null;
                Right tryUntilNoAssertionError_computeUntilTrue_result = right;
                if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    break;
                }
                if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
            }
            Object var13_7 = null;
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Either tryUntilNoAssertionError_either = (Either)tuple22._1();
            if (!(var10_12 instanceof Left)) {
                if (var10_12 instanceof Right) {
                    throw (AssertionError)((Right)var10_12).value();
                }
                throw new MatchError((Object)var10_12);
            }
            BoxedUnit cfr_ignored_0 = (BoxedUnit)((Left)var10_12).value();
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$7(ClientQuotasRequestTest $this, ClientQuotaEntity e) {
        java.util.Map result = $this.matchEntity$1(e);
        Assertions.assertEquals((int)0, (int)result.size());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$2(Function1 partition$1, Tuple2 e) {
        return BoxesRunTime.unboxToBoolean((Object)partition$1.apply(e._1()));
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$3(scala.collection.immutable.Map expectedMatchesMap$1, java.util.Map result$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            double expectedValue = x0$1._2$mcD$sp();
            if (expectedMatchesMap$1.contains((Object)entity)) {
                java.util.Map config = (java.util.Map)result$2.get(entity);
                Assertions.assertNotNull((Object)config);
                Double value = (Double)config.get("request_percentage");
                Assertions.assertNotNull((Object)value);
                Assertions.assertEquals((double)expectedValue, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
                return;
            }
            Assertions.assertNull(result$2.get(entity));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$4(scala.collection.immutable.Map expectedMatchesMap$1, java.util.Map result$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$2._1();
            double expectedValue = x0$2._2$mcD$sp();
            if (expectedMatchesMap$1.contains((Object)entity)) {
                java.util.Map config = (java.util.Map)result$2.get(entity);
                Assertions.assertNotNull((Object)config);
                Double value = (Double)config.get("connection_creation_rate");
                Assertions.assertNotNull((Object)value);
                Assertions.assertEquals((double)expectedValue, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
                return;
            }
            Assertions.assertNull(result$2.get(entity));
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$1(ClientQuotasRequestTest $this, ClientQuotaFilter filter$1, Function1 partition$1, int expectedMatchSize$1) {
        void var6_6;
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = $this.describeClientQuotas(filter$1);
        Tuple2 tuple2 = ((List)$this.matchUserClientEntities().$plus$plus($this.matchIpEntities())).partition((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(partition$1, e)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        List expectedMatches = (List)tuple2._1();
        Assertions.assertEquals((int)expectedMatchSize$1, (int)var6_6.size());
        Assertions.assertEquals((int)expectedMatchSize$1, (int)result.size(), (String)new StringBuilder(30).append("Failed to match ").append(expectedMatchSize$1).append(" entities for ").append(filter$1).toString());
        scala.collection.immutable.Map expectedMatchesMap = var6_6.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        $this.matchUserClientEntities().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(expectedMatchesMap, result, x0$1);
            return BoxedUnit.UNIT;
        });
        $this.matchIpEntities().foreach((Function1 & Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$4(expectedMatchesMap, result, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void testMatchEntities$1(ClientQuotaFilter filter, int expectedMatchSize, Function1 partition) {
        void var9_16;
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 15000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                Object var17_13;
                java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> $anonfun$testDescribeClientQuotasMatchPartial$1_result = this.describeClientQuotas(filter);
                Tuple2 tuple22 = ((List)this.matchUserClientEntities().$plus$plus(this.matchIpEntities())).partition((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(partition$1, e)));
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                List $anonfun$testDescribeClientQuotasMatchPartial$1_expectedMatches = (List)tuple22._1();
                Assertions.assertEquals((int)expectedMatchSize, (int)var17_13.size());
                Assertions.assertEquals((int)expectedMatchSize, (int)$anonfun$testDescribeClientQuotasMatchPartial$1_result.size(), (String)new StringBuilder(30).append("Failed to match ").append(expectedMatchSize).append(" entities for ").append(filter).toString());
                scala.collection.immutable.Map $anonfun$testDescribeClientQuotasMatchPartial$1_expectedMatchesMap = var17_13.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.matchUserClientEntities().foreach((Function1 & Serializable)x0$1 -> {
                    ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(expectedMatchesMap, result, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.matchIpEntities().foreach((Function1 & Serializable)x0$2 -> {
                    ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$4(expectedMatchesMap, result, x0$2);
                    return BoxedUnit.UNIT;
                });
                Object var15_11 = null;
                tuple22 = null;
                var17_13 = null;
                Object var18_14 = null;
                BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                right = new Left((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var13_8 = null;
            Object var14_9 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple23 = tuple2;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple23._1();
        if (var9_16 instanceof Left) {
            ((Left)var9_16).value();
            return;
        }
        if (var9_16 instanceof Right) {
            throw (AssertionError)((Right)var9_16).value();
        }
        throw new MatchError((Object)var9_16);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$5(ClientQuotaEntity entity) {
        Object v = entity.entries().get("user");
        String string = "user-1";
        return v != null && v.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$6(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$7(ClientQuotaEntity entity) {
        Object v = entity.entries().get("client-id");
        String string = "client-id-2";
        return v != null && v.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$8(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user") && entity.entries().get("user") == null;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$9(ClientQuotaEntity entity) {
        Object v = entity.entries().get("user");
        String string = "user-2";
        return v != null && v.equals(string) && !entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$10(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$11(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user") && !entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$12(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$13(ClientQuotaEntity entity) {
        return entity.entries().containsKey("client-id") && !entity.entries().containsKey("user");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$14(ClientQuotaEntity entity) {
        return entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$15(ClientQuotaEntity entity) {
        return entity.entries().containsKey("ip");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$16(ClientQuotaEntity entity) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$17(ClientQuotaEntity x$3) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$verifyDescribeEntityQuotas$5(java.util.Map configs$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            double v = x0$2._2$mcD$sp();
            Double value = (Double)configs$1.get(k);
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((double)v, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyDescribeEntityQuotas$1(ClientQuotasRequestTest $this, ClientQuotaEntity entity$3, scala.collection.immutable.Map quotas$1) {
        scala.collection.mutable.Iterable components = (scala.collection.mutable.Iterable)CollectionConverters$.MODULE$.MapHasAsScala(entity$3.entries()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String entityType = (String)x0$1._1();
                String entityName = (String)x0$1._2();
                return (ClientQuotaFilterComponent)Option$.MODULE$.apply((Object)entityName).map((Function1 & Serializable)name -> ClientQuotaFilterComponent.ofEntity((String)entityType, (String)name)).getOrElse((Function0 & Serializable)() -> ClientQuotaFilterComponent.ofDefaultEntity((String)entityType));
            }
            throw new MatchError(null);
        });
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> describe = $this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)components.toList()).asJava()));
        if (quotas$1.isEmpty()) {
            Assertions.assertEquals((int)0, (int)describe.size());
            return;
        }
        Assertions.assertEquals((int)1, (int)describe.size());
        java.util.Map<String, Double> configs = describe.get(entity$3);
        Assertions.assertNotNull(configs);
        Assertions.assertEquals((int)quotas$1.size(), (int)configs.size());
        quotas$1.foreach((Function1 & Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$verifyDescribeEntityQuotas$5(configs, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Double $anonfun$alterClientQuotas$3(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    public static final /* synthetic */ void $anonfun$alterClientQuotas$5(scala.collection.mutable.Map result$3, Tuple2 e) {
        Assertions.assertTrue((boolean)result$3.contains(e._1()));
    }

    public ClientQuotasRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        this.matchUserClientEntities = ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)new Some((Object)"user-1"), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)50.5)), new Tuple3((Object)new Some((Object)"user-2"), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)51.51)), new Tuple3((Object)new Some((Object)"user-3"), (Object)new Some((Object)"client-id-2"), (Object)BoxesRunTime.boxToDouble((double)52.52)), new Tuple3((Object)new Some(null), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)53.53)), new Tuple3((Object)new Some((Object)"user-1"), (Object)new Some(null), (Object)BoxesRunTime.boxToDouble((double)54.54)), new Tuple3((Object)new Some((Object)"user-3"), (Object)new Some(null), (Object)BoxesRunTime.boxToDouble((double)55.55)), new Tuple3((Object)new Some((Object)"user-1"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)56.56)), new Tuple3((Object)new Some((Object)"user-2"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)57.57)), new Tuple3((Object)new Some((Object)"user-3"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)58.58)), new Tuple3((Object)new Some(null), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)59.59)), new Tuple3((Object)None$.MODULE$, (Object)new Some((Object)"client-id-2"), (Object)BoxesRunTime.boxToDouble((double)60.6))}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Option u = (Option)x0$1._1();
                Option c = (Option)x0$1._2();
                double v = BoxesRunTime.unboxToDouble((Object)x0$1._3());
                return new Tuple2((Object)this.toClientEntity((Option<String>)u, (Option<String>)c), (Object)BoxesRunTime.boxToDouble((double)v));
            }
            throw new MatchError(null);
        });
        this.matchIpEntities = new .colon.colon((Object)new Tuple2((Object)new Some((Object)"1.2.3.4"), (Object)BoxesRunTime.boxToDouble((double)10.0)), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"2.3.4.5"), (Object)BoxesRunTime.boxToDouble((double)20.0)), (List)Nil$.MODULE$)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Some ip = (Some)x0$2._1();
                double quota = x0$2._2$mcD$sp();
                return new Tuple2((Object)this.toIpEntity((Option<String>)ip), (Object)BoxesRunTime.boxToDouble((double)quota));
            }
            throw new MatchError(null);
        });
    }
}

