/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.Collapsible;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Strings;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.layout.AnyLayout;
import org.apache.syncope.client.console.layout.AnyLayoutUtils;
import org.apache.syncope.client.console.panels.AnyObjectDirectoryPanel;
import org.apache.syncope.client.console.panels.GroupDirectoryPanel;
import org.apache.syncope.client.console.panels.UserDirectoryPanel;
import org.apache.syncope.client.console.panels.search.AbstractSearchPanel;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.GroupSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchClausePanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.panels.LabelPanel;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.common.lib.search.AnyObjectCompleteCondition;
import org.apache.syncope.common.lib.search.GroupCompleteCondition;
import org.apache.syncope.common.lib.search.UserCompleteCondition;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class AnyPanel
extends Panel
implements ModalPanel {
    private static final long serialVersionUID = -1100228004207271270L;
    protected static final Logger LOG = LoggerFactory.getLogger(AnyPanel.class);
    protected static final String DIRECTORY_PANEL_ID = "searchResult";
    @SpringBean
    protected AnyTypeClassRestClient anyTypeClassRestClient;
    @SpringBean
    protected UserRestClient userRestClient;
    @SpringBean
    protected GroupRestClient groupRestClient;
    @SpringBean
    protected AnyObjectRestClient anyObjectRestClient;
    protected final AnyTypeTO anyTypeTO;
    protected final RealmTO realmTO;
    protected final AnyLayout anyLayout;
    protected final PageReference pageRef;
    protected AbstractSearchPanel searchPanel;
    protected Panel directoryPanel;

    protected AnyPanel(String id, AnyTypeTO anyTypeTO, RealmTO realmTO, AnyLayout anyLayout, boolean enableSearch, PageReference pageRef) {
        super(id);
        this.anyTypeTO = anyTypeTO;
        this.realmTO = realmTO;
        this.anyLayout = anyLayout;
        this.pageRef = pageRef;
        final Model model = Model.of((Serializable)Integer.valueOf(-1));
        Accordion accordion = new Accordion("accordionPanel", List.of(new AbstractTab((IModel)new ResourceModel("search.result")){
            protected static final long serialVersionUID = 1037272333056449377L;

            public WebMarkupContainer getPanel(String panelId) {
                AnyPanel.this.searchPanel = AnyPanel.this.getSearchPanel(panelId);
                return AnyPanel.this.searchPanel;
            }
        }), (IModel)model){
            protected static final long serialVersionUID = -3056452800492734900L;

            protected Component newTitle(String markupId, ITab tab, Collapsible.State state) {
                return new AjaxLink<Integer>(markupId){
                    protected static final long serialVersionUID = 6250423506463465679L;

                    public void onClick(AjaxRequestTarget target) {
                        model.setObject((Serializable)Integer.valueOf((Integer)model.getObject() == 0 ? -1 : 0));
                    }
                }.setBody(tab.getTitle()).setEscapeModelStrings(false);
            }
        };
        accordion.setOutputMarkupId(true);
        this.add(new Component[]{accordion.setEnabled(enableSearch).setVisible(enableSearch)});
    }

    protected DirectoryPanelSupplier getDefaultDirectoryPanelSupplier() {
        return (id, anyType, r, layout, pr) -> {
            Object panel;
            String dynRealm;
            String realm;
            if (Strings.CS.startsWith((CharSequence)r.getFullPath(), (CharSequence)"/")) {
                realm = RealmsUtils.getFullPath(r.getFullPath());
                dynRealm = null;
            } else {
                realm = "/";
                dynRealm = r.getKey();
            }
            switch (anyType.getKind()) {
                case USER: {
                    String fiql = dynRealm == null ? ((UserCompleteCondition)SyncopeClient.getUserSearchConditionBuilder().is("key").notNullValue()).query() : ((UserCompleteCondition)SyncopeClient.getUserSearchConditionBuilder().inDynRealms(dynRealm, new String[0])).query();
                    UserTO user = new UserTO();
                    user.setRealm(RealmsUtils.getFullPath(r.getFullPath()));
                    panel = new UserDirectoryPanel.Builder(this.anyTypeClassRestClient.list(anyType.getClasses()), this.userRestClient, anyType.getKey(), pr).setRealm(realm).setDynRealm(dynRealm).setFiltered(true).setFiql(fiql).setWizardInModal(true).addNewItemPanelBuilder(AnyLayoutUtils.newLayoutInfo(user, anyType.getClasses(), layout.getUser(), this.userRestClient, pr)).build(id);
                    MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)WebPage.RENDER, (String)"USER_SEARCH");
                    break;
                }
                case GROUP: {
                    String fiql = dynRealm == null ? ((GroupCompleteCondition)SyncopeClient.getGroupSearchConditionBuilder().is("key").notNullValue()).query() : ((GroupCompleteCondition)SyncopeClient.getGroupSearchConditionBuilder().inDynRealms(dynRealm, new String[0])).query();
                    GroupTO group = new GroupTO();
                    group.setRealm(RealmsUtils.getFullPath(r.getFullPath()));
                    panel = new GroupDirectoryPanel.Builder(this.anyTypeClassRestClient.list(anyType.getClasses()), this.groupRestClient, anyType.getKey(), pr).setRealm(realm).setDynRealm(dynRealm).setFiltered(true).setFiql(fiql).setWizardInModal(true).addNewItemPanelBuilder(AnyLayoutUtils.newLayoutInfo(group, anyType.getClasses(), layout.getGroup(), this.groupRestClient, pr)).build(id);
                    break;
                }
                case ANY_OBJECT: {
                    String fiql = dynRealm == null ? ((AnyObjectCompleteCondition)SyncopeClient.getAnyObjectSearchConditionBuilder((String)anyType.getKey()).is("key").notNullValue()).query() : ((AnyObjectCompleteCondition)SyncopeClient.getAnyObjectSearchConditionBuilder((String)anyType.getKey()).inDynRealms(dynRealm, new String[0])).query();
                    AnyObjectTO anyObject = new AnyObjectTO();
                    anyObject.setRealm(RealmsUtils.getFullPath(r.getFullPath()));
                    anyObject.setType(anyType.getKey());
                    panel = new AnyObjectDirectoryPanel.Builder(this.anyTypeClassRestClient.list(anyType.getClasses()), this.anyObjectRestClient, anyType.getKey(), pr).setRealm(realm).setDynRealm(dynRealm).setFiltered(true).setFiql(fiql).setWizardInModal(true).addNewItemPanelBuilder(AnyLayoutUtils.newLayoutInfo(anyObject, anyType.getClasses(), layout.getAnyObjects().get(anyType.getKey()), this.anyObjectRestClient, pr)).build(id);
                    MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)WebPage.RENDER, (String)AnyEntitlement.SEARCH.getFor(anyType.getKey()));
                    break;
                }
                default: {
                    panel = new LabelPanel(id, null);
                }
            }
            return panel;
        };
    }

    protected Panel createDirectoryPanel(AnyTypeTO anyTypeTO, RealmTO realmTO, AnyLayout anyLayout, DirectoryPanelSupplier directoryPanelSupplier) {
        return directoryPanelSupplier.supply(DIRECTORY_PANEL_ID, anyTypeTO, realmTO, anyLayout, this.pageRef);
    }

    public void onEvent(IEvent<?> event) {
        Object object = event.getPayload();
        if (object instanceof SearchClausePanel.SearchEvent) {
            SearchClausePanel.SearchEvent payload = (SearchClausePanel.SearchEvent)object;
            AjaxRequestTarget target = payload.getTarget();
            this.send((IEventSink)this.directoryPanel, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
            String precond = this.realmTO.getFullPath().startsWith("/") ? "" : String.format("$dynRealms=~%s;", this.realmTO.getKey());
            switch (this.anyTypeTO.getKind()) {
                case USER: {
                    ((UserDirectoryPanel)((Object)UserDirectoryPanel.class.cast(this.directoryPanel))).search(precond + SearchUtils.buildFIQL((List)this.searchPanel.getModel().getObject(), SyncopeClient.getUserSearchConditionBuilder(), this.searchPanel.getAvailableSchemaTypes(), SearchUtils.NO_CUSTOM_CONDITION), target);
                    break;
                }
                case GROUP: {
                    ((GroupDirectoryPanel)((Object)GroupDirectoryPanel.class.cast(this.directoryPanel))).search(precond + SearchUtils.buildFIQL((List)this.searchPanel.getModel().getObject(), SyncopeClient.getGroupSearchConditionBuilder(), this.searchPanel.getAvailableSchemaTypes(), SearchUtils.NO_CUSTOM_CONDITION), target);
                    break;
                }
                case ANY_OBJECT: {
                    ((AnyObjectDirectoryPanel)((Object)AnyObjectDirectoryPanel.class.cast(this.directoryPanel))).search(precond + SearchUtils.buildFIQL((List)this.searchPanel.getModel().getObject(), SyncopeClient.getAnyObjectSearchConditionBuilder((String)this.anyTypeTO.getKey()), this.searchPanel.getAvailableSchemaTypes(), SearchUtils.NO_CUSTOM_CONDITION), target);
                    break;
                }
            }
        } else {
            super.onEvent(event);
        }
    }

    protected AbstractSearchPanel getSearchPanel(String id) {
        ArrayList<SearchClause> clauses = new ArrayList<SearchClause>();
        SearchClause clause = new SearchClause();
        clauses.add(clause);
        return switch (this.anyTypeTO.getKind()) {
            case AnyTypeKind.USER -> {
                clause.setComparator(SearchClause.Comparator.EQUALS);
                clause.setType(SearchClause.Type.ATTRIBUTE);
                clause.setProperty("username");
                yield (AbstractSearchPanel)((Object)new UserSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(clauses), this.pageRef).required(true).enableSearch().build(id));
            }
            case AnyTypeKind.GROUP -> {
                clause.setComparator(SearchClause.Comparator.EQUALS);
                clause.setType(SearchClause.Type.ATTRIBUTE);
                clause.setProperty("name");
                yield (AbstractSearchPanel)((Object)new GroupSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(clauses), this.pageRef).required(true).enableSearch().build(id));
            }
            case AnyTypeKind.ANY_OBJECT -> {
                clause.setComparator(SearchClause.Comparator.EQUALS);
                clause.setType(SearchClause.Type.ATTRIBUTE);
                clause.setProperty("name");
                yield (AbstractSearchPanel)((Object)new AnyObjectSearchPanel.Builder(this.anyTypeTO.getKey(), (IModel<List<SearchClause>>)new ListModel(clauses), this.pageRef).required(true).enableSearch().build(id));
            }
            default -> null;
        };
    }

    @FunctionalInterface
    public static interface DirectoryPanelSupplier
    extends Serializable {
        public Panel supply(String var1, AnyTypeTO var2, RealmTO var3, AnyLayout var4, PageReference var5);
    }

    public static class Builder<AP extends AnyPanel> {
        private final AP instance;

        public Builder(String panelClass, String id, AnyTypeTO anyTypeTO, RealmTO realmTO, AnyLayout anyLayout, boolean enableSearch, PageReference pageRef) {
            try {
                Class clazz = ClassUtils.forName((String)panelClass, (ClassLoader)ClassUtils.getDefaultClassLoader());
                this.instance = (AnyPanel)((Object)clazz.getDeclaredConstructor(String.class, AnyTypeTO.class, RealmTO.class, AnyLayout.class, Boolean.TYPE, PageReference.class).newInstance(id, anyTypeTO, realmTO, anyLayout, enableSearch, pageRef));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not instantiate " + panelClass, e);
            }
        }

        public AP build() {
            return this.build(((AnyPanel)((Object)this.instance)).getDefaultDirectoryPanelSupplier());
        }

        public AP build(DirectoryPanelSupplier directoryPanelSupplier) {
            ((AnyPanel)((Object)this.instance)).directoryPanel = ((AnyPanel)((Object)this.instance)).createDirectoryPanel(((AnyPanel)((Object)this.instance)).anyTypeTO, ((AnyPanel)((Object)this.instance)).realmTO, ((AnyPanel)((Object)this.instance)).anyLayout, directoryPanelSupplier);
            this.instance.add(new Component[]{((AnyPanel)((Object)this.instance)).directoryPanel});
            return this.instance;
        }
    }
}

