/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.services.directory.Directory;
import com.google.api.services.directory.model.Group;
import com.google.api.services.directory.model.Groups;
import com.google.api.services.directory.model.Member;
import com.google.api.services.directory.model.Members;
import com.google.api.services.directory.model.OrgUnit;
import com.google.api.services.directory.model.OrgUnits;
import com.google.api.services.directory.model.User;
import com.google.api.services.directory.model.Users;
import com.google.api.services.licensing.Licensing;
import com.google.api.services.licensing.LicensingRequest;
import com.google.api.services.licensing.model.LicenseAssignment;
import com.google.api.services.licensing.model.LicenseAssignmentList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Matcher;
import net.tirasa.connid.bundles.googleapps.GoogleApiExecutor;
import net.tirasa.connid.bundles.googleapps.GoogleAppsConfiguration;
import net.tirasa.connid.bundles.googleapps.GoogleAppsCustomSchema;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import net.tirasa.connid.bundles.googleapps.GroupHandler;
import net.tirasa.connid.bundles.googleapps.LicenseAssignmentsHandler;
import net.tirasa.connid.bundles.googleapps.MembersHandler;
import net.tirasa.connid.bundles.googleapps.OrgunitsHandler;
import net.tirasa.connid.bundles.googleapps.RequestResultHandler;
import net.tirasa.connid.bundles.googleapps.UserHandler;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SortKey;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.AndFilter;
import org.identityconnectors.framework.common.objects.filter.AttributeFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterVisitor;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;
import org.identityconnectors.framework.spi.SearchResultsHandler;

public class GoogleAppsSearch {
    private static final Log LOG = Log.getLog(GoogleAppsSearch.class);
    private final GoogleAppsConfiguration configuration;
    private final ObjectClass objectClass;
    private final Filter query;
    private final ResultsHandler handler;
    private final OperationOptions options;

    private static Set<String> getAttributesToGet(ObjectClass objectClass, OperationOptions options) {
        SortedSet attributesToGet = null;
        if (null != options.getAttributesToGet()) {
            attributesToGet = CollectionUtil.newCaseInsensitiveSet();
            if (GoogleAppsUtil.ORG_UNIT.equals((Object)objectClass)) {
                attributesToGet.add("orgUnitPath");
            } else {
                attributesToGet.add("id");
            }
            attributesToGet.add("etag");
            for (String attribute : options.getAttributesToGet()) {
                int i = attribute.indexOf(47);
                if (i == 0) {
                    attribute = attribute.substring(1);
                    i = attribute.indexOf(47);
                }
                int j = attribute.indexOf(40);
                if (i < 0 && j < 0) {
                    attributesToGet.add(attribute);
                    continue;
                }
                if (i == 0 || j == 0) {
                    throw new IllegalArgumentException("Invalid attribute name to get:/" + attribute);
                }
                int l = attribute.length();
                if (i > 0) {
                    l = Math.min(l, i);
                }
                if (j > 0) {
                    l = Math.min(l, j);
                }
                attributesToGet.add(attribute.substring(0, l));
            }
        }
        return attributesToGet;
    }

    private static List<String> customSchemaNames(String customSchemasJSON) {
        List<GoogleAppsCustomSchema> customSchemas = GoogleAppsUtil.extractCustomSchemas(customSchemasJSON);
        ArrayList<String> customSchemaNames = new ArrayList<String>();
        for (GoogleAppsCustomSchema customSchema : customSchemas) {
            if (customSchema.getType().equals("object")) {
                String basicName = customSchema.getName();
                for (GoogleAppsCustomSchema innerSchema : customSchema.getInnerSchemas()) {
                    customSchemaNames.add(basicName + "." + innerSchema.getName());
                }
                continue;
            }
            LOG.warn("CustomSchema type {0} not allowed at this level", new Object[]{customSchema.getType()});
        }
        return customSchemaNames;
    }

    private static Attribute getKeyFromFilter(ObjectClass objectClass, Filter filter) {
        Attribute key = null;
        if (filter instanceof EqualsFilter) {
            Attribute filterAttr = ((EqualsFilter)filter).getAttribute();
            if (filterAttr instanceof Uid) {
                key = filterAttr;
            } else if (ObjectClass.ACCOUNT.equals((Object)objectClass) || ObjectClass.GROUP.equals((Object)objectClass) && (filterAttr instanceof Name || filterAttr.getName().equalsIgnoreCase("aliases"))) {
                key = filterAttr;
            } else if (GoogleAppsUtil.ORG_UNIT.equals((Object)objectClass) && filterAttr.getName().equalsIgnoreCase("orgUnitPath")) {
                key = filterAttr;
            } else if (ObjectClass.GROUP.equals((Object)objectClass) && filterAttr.is("email")) {
                key = filterAttr;
            }
        } else if (filter instanceof AndFilter && GoogleAppsUtil.MEMBER.equals((Object)objectClass)) {
            Attribute groupKey = null;
            Attribute memberKey = null;
            StringBuilder memberId = new StringBuilder();
            Collection filters = ((AndFilter)filter).getFilters();
            for (Filter f : filters) {
                if (f instanceof EqualsFilter) {
                    Attribute filterAttr = ((EqualsFilter)f).getAttribute();
                    if (filterAttr.getName().equalsIgnoreCase("groupKey")) {
                        groupKey = filterAttr;
                        continue;
                    }
                    if (filterAttr.getName().equalsIgnoreCase("email") || filterAttr.getName().equalsIgnoreCase("alias") || filterAttr instanceof Uid) {
                        memberKey = filterAttr;
                        continue;
                    }
                    throw new UnsupportedOperationException("Only AndFilter('groupKey','memberKey') is supported");
                }
                throw new UnsupportedOperationException("Only AndFilter('groupKey','memberKey') is supported");
            }
            if (memberKey != null && groupKey != null) {
                memberId.append(groupKey.getValue().get(0));
                memberId.append("/");
                memberId.append(memberKey.getValue().get(0));
                key = new Uid(memberId.toString());
            }
        }
        return key;
    }

    public GoogleAppsSearch(GoogleAppsConfiguration configuration, ObjectClass objectClass, Filter query, ResultsHandler handler, OperationOptions options) {
        this.configuration = configuration;
        this.objectClass = objectClass;
        this.query = query;
        this.handler = handler;
        this.options = options;
    }

    protected String getFields(OperationOptions options, String ... nameAttribute) {
        if (null != options.getAttributesToGet()) {
            SortedSet attributes = CollectionUtil.newCaseInsensitiveSet();
            attributes.addAll(Arrays.asList(nameAttribute));
            boolean notBlankCustomSchemas = StringUtil.isNotBlank((String)this.configuration.getCustomSchemasJSON());
            List<Object> customSchemaNames = notBlankCustomSchemas ? GoogleAppsSearch.customSchemaNames(this.configuration.getCustomSchemasJSON()) : new ArrayList();
            for (String attribute : options.getAttributesToGet()) {
                if (AttributeUtil.namesEqual((String)"description", (String)attribute)) {
                    attributes.add("description");
                } else if (!AttributeUtil.isSpecialName((String)attribute)) {
                    if (AttributeUtil.namesEqual((String)"familyName", (String)attribute)) {
                        attributes.add("name/familyName");
                    } else if (AttributeUtil.namesEqual((String)"givenName", (String)attribute)) {
                        attributes.add("name/givenName");
                    } else if (AttributeUtil.namesEqual((String)"fullName", (String)attribute)) {
                        attributes.add("name/fullName");
                    } else if (!customSchemaNames.contains(attribute)) {
                        attributes.add(attribute);
                    }
                }
                if (!"full".equals(this.configuration.getProjection()) || !notBlankCustomSchemas) continue;
                attributes.add("customSchemas");
            }
            return StringUtil.join((Collection)attributes, (char)',');
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        Attribute key;
        Set<String> attributesToGet;
        block72: {
            block73: {
                attributesToGet = GoogleAppsSearch.getAttributesToGet(this.objectClass, this.options);
                key = GoogleAppsSearch.getKeyFromFilter(this.objectClass, this.query);
                if (!ObjectClass.ACCOUNT.equals((Object)this.objectClass)) break block72;
                if (null != key && null != key.getValue() && !key.getValue().isEmpty() && null != key.getValue().get(0)) break block73;
                try {
                    boolean paged;
                    Directory.Users.List request;
                    block74: {
                        request = this.configuration.getDirectory().users().list();
                        if (null != this.query) {
                            StringBuilder queryBuilder = (StringBuilder)this.query.accept((FilterVisitor)new UserHandler(), (Object)request);
                            if (null != queryBuilder) {
                                String queryString = queryBuilder.toString();
                                LOG.ok("Executing Query: {0}", new Object[]{queryString});
                                request.setQuery(queryString);
                            }
                            if (null == request.getDomain() && null == request.getCustomer()) {
                                request.setCustomer("my_customer");
                            }
                        } else {
                            request.setCustomer("my_customer");
                        }
                        paged = false;
                        if (this.options.getPageSize() != null && 0 < this.options.getPageSize()) {
                            if (this.options.getPageSize() < 1 || this.options.getPageSize() > 500) throw new IllegalArgumentException("Invalid pageSize value. Default is 100. Max allowed is 500 (integer, 1-500)");
                            request.setMaxResults(this.options.getPageSize());
                            paged = true;
                        }
                        request.setPageToken(this.options.getPagedResultsCookie());
                        request.setProjection(this.configuration.getProjection());
                        String fields = this.getFields(this.options, "id", "etag", "primaryEmail");
                        if (null != fields) {
                            request.setFields("nextPageToken,users(" + fields + ")");
                        }
                        if (this.options.getOptions().get("showDeleted") instanceof Boolean) {
                            request.setShowDeleted(this.options.getOptions().get("showDeleted").toString());
                        }
                        if (null == this.options.getSortKeys()) break block74;
                        for (SortKey sortKey : this.options.getSortKeys()) {
                            block78: {
                                String orderBy;
                                block76: {
                                    block77: {
                                        block75: {
                                            if (!sortKey.getField().equalsIgnoreCase("email") && !sortKey.getField().equalsIgnoreCase("primaryEmail") && !sortKey.getField().equalsIgnoreCase("aliases") && !sortKey.getField().equalsIgnoreCase("alias")) break block75;
                                            orderBy = "email";
                                            break block76;
                                        }
                                        if (!sortKey.getField().equalsIgnoreCase("givenName")) break block77;
                                        orderBy = "givenName";
                                        break block76;
                                    }
                                    if (sortKey.getField().equalsIgnoreCase("familyName")) {
                                        orderBy = "familyName";
                                    }
                                    break block78;
                                }
                                request.setOrderBy(orderBy);
                                if (sortKey.isAscendingOrder()) {
                                    request.setSortOrder("ASCENDING");
                                    break;
                                }
                                request.setSortOrder("DESCENDING");
                                break;
                            }
                            LOG.ok("Unsupported SortKey:{0}", new Object[]{sortKey});
                        }
                    }
                    String nextPageToken = null;
                    do {
                        nextPageToken = GoogleApiExecutor.execute(request, new RequestResultHandler<Directory.Users.List, Users, String>(){

                            @Override
                            public String handleResult(Directory.Users.List request, Users value) {
                                if (null != value.getUsers()) {
                                    for (User user : value.getUsers()) {
                                        GoogleAppsSearch.this.handler.handle(UserHandler.fromUser(GoogleAppsSearch.this.configuration, user, attributesToGet, GoogleAppsSearch.this.configuration.getDirectory().groups()));
                                    }
                                }
                                return value.getNextPageToken();
                            }
                        });
                        request.setPageToken(nextPageToken);
                    } while (!paged && StringUtil.isNotBlank((String)nextPageToken));
                    if (!paged || !StringUtil.isNotBlank((String)nextPageToken)) return;
                    LOG.info("Paged Search was requested and next token is:{0}", new Object[]{nextPageToken});
                    ((SearchResultsHandler)this.handler).handleResult(new SearchResult(nextPageToken, 0));
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#List", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
            try {
                Directory.Users.Get request = this.configuration.getDirectory().users().get((String)key.getValue().get(0));
                request.setFields(this.getFields(this.options, "id", "etag", "primaryEmail", "suspended"));
                request.setProjection(this.configuration.getProjection());
                GoogleApiExecutor.execute(request, new RequestResultHandler<Directory.Users.Get, User, Boolean>(){

                    @Override
                    public Boolean handleResult(Directory.Users.Get request, User user) {
                        return GoogleAppsSearch.this.handler.handle(UserHandler.fromUser(GoogleAppsSearch.this.configuration, user, attributesToGet, GoogleAppsSearch.this.configuration.getDirectory().groups()));
                    }

                    @Override
                    public Boolean handleNotFound(IOException e) {
                        return true;
                    }
                });
                return;
            }
            catch (IOException e) {
                LOG.warn((Throwable)e, "Failed to initialize Users#Get", new Object[0]);
                throw ConnectorException.wrap((Throwable)e);
            }
        }
        if (ObjectClass.GROUP.equals((Object)this.objectClass)) {
            if (null == key) {
                try {
                    Directory.Groups.List request = this.configuration.getDirectory().groups().list();
                    if (null != this.query) {
                        StringBuilder queryBuilder = (StringBuilder)this.query.accept((FilterVisitor)new GroupHandler(), (Object)request);
                        if (null != queryBuilder) {
                            String queryString = queryBuilder.toString();
                            LOG.ok("Executing Query: {0}", new Object[]{queryString});
                            request.setQuery(queryString);
                        }
                        if (null == request.getDomain() && null == request.getCustomer()) {
                            request.setCustomer("my_customer");
                        }
                    } else {
                        request.setCustomer("my_customer");
                    }
                    boolean paged = false;
                    if (this.options.getPageSize() != null && 0 < this.options.getPageSize()) {
                        request.setMaxResults(this.options.getPageSize());
                        paged = true;
                    }
                    request.setPageToken(this.options.getPagedResultsCookie());
                    String fields = this.getFields(this.options, "id", "etag", "email", "suspended");
                    if (null != fields) {
                        request.setFields("nextPageToken,groups(" + fields + ")");
                    }
                    String nextPageToken = null;
                    do {
                        nextPageToken = GoogleApiExecutor.execute(request, new RequestResultHandler<Directory.Groups.List, Groups, String>(){

                            @Override
                            public String handleResult(Directory.Groups.List request, Groups value) {
                                if (null != value.getGroups()) {
                                    for (Group group : value.getGroups()) {
                                        GoogleAppsSearch.this.handler.handle(GroupHandler.fromGroup(group, attributesToGet, GoogleAppsSearch.this.configuration.getDirectory().members()));
                                    }
                                }
                                return value.getNextPageToken();
                            }
                        });
                        request.setPageToken(nextPageToken);
                    } while (!paged && StringUtil.isNotBlank((String)nextPageToken));
                    if (!paged || !StringUtil.isNotBlank((String)nextPageToken)) return;
                    LOG.info("Paged Search was requested", new Object[0]);
                    ((SearchResultsHandler)this.handler).handleResult(new SearchResult(nextPageToken, 0));
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#List", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            } else {
                try {
                    Directory.Groups.Get request = this.configuration.getDirectory().groups().get((String)key.getValue().get(0));
                    request.setFields(this.getFields(this.options, "id", "etag", "email"));
                    GoogleApiExecutor.execute(request, new RequestResultHandler<Directory.Groups.Get, Group, Boolean>(){

                        @Override
                        public Boolean handleResult(Directory.Groups.Get request, Group value) {
                            return GoogleAppsSearch.this.handler.handle(GroupHandler.fromGroup(value, attributesToGet, GoogleAppsSearch.this.configuration.getDirectory().members()));
                        }

                        @Override
                        public Boolean handleNotFound(IOException e) {
                            return true;
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#Get", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
        } else if (GoogleAppsUtil.MEMBER.equals((Object)this.objectClass)) {
            if (null == key) {
                try {
                    String groupKey = null;
                    if (!(this.query instanceof EqualsFilter) || !((EqualsFilter)this.query).getAttribute().is("groupKey")) {
                        throw new UnsupportedOperationException("Only EqualsFilter('groupKey') is supported");
                    }
                    groupKey = AttributeUtil.getStringValue((Attribute)((AttributeFilter)this.query).getAttribute());
                    if (StringUtil.isBlank((String)groupKey)) {
                        throw new InvalidAttributeValueException("The 'groupKey' can not be blank.");
                    }
                    Directory.Members.List request = this.configuration.getDirectory().members().list(groupKey);
                    boolean paged = false;
                    if (this.options.getPageSize() != null && 0 < this.options.getPageSize()) {
                        request.setMaxResults(this.options.getPageSize());
                        paged = true;
                    }
                    request.setPageToken(this.options.getPagedResultsCookie());
                    String nextPageToken = null;
                    do {
                        nextPageToken = GoogleApiExecutor.execute(request, new RequestResultHandler<Directory.Members.List, Members, String>(){

                            @Override
                            public String handleResult(Directory.Members.List request, Members value) {
                                if (null != value.getMembers()) {
                                    for (Member group : value.getMembers()) {
                                        GoogleAppsSearch.this.handler.handle(MembersHandler.from(request.getGroupKey(), group));
                                    }
                                }
                                return value.getNextPageToken();
                            }
                        });
                        request.setPageToken(nextPageToken);
                    } while (!paged && StringUtil.isNotBlank((String)nextPageToken));
                    if (!paged || !StringUtil.isNotBlank((String)nextPageToken)) return;
                    LOG.info("Paged Search was requested", new Object[0]);
                    ((SearchResultsHandler)this.handler).handleResult(new SearchResult(nextPageToken, 0));
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#List", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            } else {
                try {
                    String[] ids = ((Uid)key).getUidValue().split("/");
                    if (ids.length != 2) {
                        throw new InvalidAttributeValueException("Unrecognised UID format");
                    }
                    Directory.Members.Get request = this.configuration.getDirectory().members().get(ids[0], ids[1]);
                    GoogleApiExecutor.execute(request, new RequestResultHandler<Directory.Members.Get, Member, Boolean>(){

                        @Override
                        public Boolean handleResult(Directory.Members.Get request, Member value) {
                            return GoogleAppsSearch.this.handler.handle(MembersHandler.from(request.getGroupKey(), value));
                        }

                        @Override
                        public Boolean handleNotFound(IOException e) {
                            return true;
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#Get", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
        } else if (GoogleAppsUtil.ORG_UNIT.equals((Object)this.objectClass)) {
            if (null == key) {
                try {
                    Directory.Orgunits.List request = this.configuration.getDirectory().orgunits().list("my_customer");
                    if (null != this.query) {
                        if (!(this.query instanceof StartsWithFilter) || !AttributeUtil.namesEqual((String)"orgUnitPath", (String)((StartsWithFilter)this.query).getName())) throw new UnsupportedOperationException("Only StartsWithFilter('orgUnitPath') is supported");
                        request.setOrgUnitPath(((StartsWithFilter)this.query).getValue());
                    } else {
                        request.setOrgUnitPath("/");
                    }
                    String scope = this.options.getScope();
                    if ("object".equalsIgnoreCase(scope) || "onelevel".equalsIgnoreCase(scope)) {
                        request.setType("children");
                    } else {
                        request.setType("all");
                    }
                    String fields = this.getFields(this.options, "orgUnitPath", "etag", "name");
                    if (null != fields) {
                        request.setFields("organizationUnits(" + fields + ")");
                    }
                    GoogleApiExecutor.execute(request, new RequestResultHandler<Directory.Orgunits.List, OrgUnits, Void>(){

                        @Override
                        public Void handleResult(Directory.Orgunits.List request, OrgUnits value) {
                            if (null != value.getOrganizationUnits()) {
                                for (OrgUnit group : value.getOrganizationUnits()) {
                                    GoogleAppsSearch.this.handler.handle(OrgunitsHandler.from(group, attributesToGet));
                                }
                            }
                            return null;
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize OrgUnits#List", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            } else {
                try {
                    Directory.Orgunits.Get request = this.configuration.getDirectory().orgunits().get("my_customer", (String)key.getValue().get(0));
                    request.setFields(this.getFields(this.options, "orgUnitPath", "etag", "name"));
                    GoogleApiExecutor.execute(request, new RequestResultHandler<Directory.Orgunits.Get, OrgUnit, Boolean>(){

                        @Override
                        public Boolean handleResult(Directory.Orgunits.Get request, OrgUnit value) {
                            return GoogleAppsSearch.this.handler.handle(OrgunitsHandler.from(value, attributesToGet));
                        }

                        @Override
                        public Boolean handleNotFound(IOException e) {
                            return true;
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize OrgUnits#Get", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
        } else if (GoogleAppsUtil.LICENSE_ASSIGNMENT.equals((Object)this.objectClass)) {
            if (null == key) {
                try {
                    Licensing.LicenseAssignments.ListForProduct r;
                    String productId = "";
                    String skuId = "";
                    boolean paged = false;
                    Licensing.LicenseAssignments.ListForProduct request = null;
                    if (StringUtil.isBlank((String)productId)) {
                        throw new ConnectorException("productId is required");
                    }
                    if (StringUtil.isBlank((String)skuId)) {
                        r = this.configuration.getLicensing().licenseAssignments().listForProduct(productId, "my_customer");
                        if (this.options.getPageSize() != null && 0 < this.options.getPageSize()) {
                            r.setMaxResults(Long.valueOf(this.options.getPageSize().intValue()));
                            paged = true;
                        }
                        r.setPageToken(this.options.getPagedResultsCookie());
                        request = r;
                    } else {
                        r = this.configuration.getLicensing().licenseAssignments().listForProductAndSku(productId, skuId, "my_customer");
                        if (this.options.getPageSize() != null && 0 < this.options.getPageSize()) {
                            r.setMaxResults(Long.valueOf(this.options.getPageSize().intValue()));
                            paged = true;
                        }
                        r.setPageToken(this.options.getPagedResultsCookie());
                        request = r;
                    }
                    String nextPageToken = null;
                    do {
                        nextPageToken = GoogleApiExecutor.execute(request, new RequestResultHandler<LicensingRequest<LicenseAssignmentList>, LicenseAssignmentList, String>(){

                            @Override
                            public String handleResult(LicensingRequest<LicenseAssignmentList> request, LicenseAssignmentList value) {
                                if (null != value.getItems()) {
                                    for (LicenseAssignment resource : value.getItems()) {
                                        GoogleAppsSearch.this.handler.handle(LicenseAssignmentsHandler.from(resource));
                                    }
                                }
                                return value.getNextPageToken();
                            }
                        });
                        if (request instanceof Licensing.LicenseAssignments.ListForProduct) {
                            request.setPageToken(nextPageToken);
                            continue;
                        }
                        ((Licensing.LicenseAssignments.ListForProductAndSku)request).setPageToken(nextPageToken);
                    } while (!paged && StringUtil.isNotBlank((String)nextPageToken));
                    if (!paged || !StringUtil.isNotBlank((String)nextPageToken)) return;
                    LOG.info("Paged Search was requested", new Object[0]);
                    ((SearchResultsHandler)this.handler).handleResult(new SearchResult(nextPageToken, 0));
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#List", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            } else {
                try {
                    Matcher name = LicenseAssignmentsHandler.LICENSE_NAME_PATTERN.matcher(((Uid)key).getUidValue());
                    if (!name.matches()) {
                        return;
                    }
                    String productId = name.group(0);
                    String skuId = name.group(1);
                    String userId = name.group(2);
                    Licensing.LicenseAssignments.Get request = this.configuration.getLicensing().licenseAssignments().get(productId, skuId, userId);
                    GoogleApiExecutor.execute(request, new RequestResultHandler<Licensing.LicenseAssignments.Get, LicenseAssignment, Boolean>(){

                        @Override
                        public Boolean handleResult(Licensing.LicenseAssignments.Get request, LicenseAssignment value) {
                            return GoogleAppsSearch.this.handler.handle(LicenseAssignmentsHandler.from(value));
                        }

                        @Override
                        public Boolean handleNotFound(IOException e) {
                            return true;
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#Get", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
        } else {
            LOG.warn("Search of type {0} is not supported", new Object[]{this.configuration.getConnectorMessages().format(this.objectClass.getDisplayNameKey(), this.objectClass.getObjectClassValue(), new Object[0])});
            throw new UnsupportedOperationException("Search of type" + this.objectClass.getObjectClassValue() + " is not supported");
        }
    }
}

