/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceDefinition;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.token.TokenTicketBuilder;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.validation.TicketValidationResult;
import org.apereo.cas.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTicketBuilder
implements TokenTicketBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtTicketBuilder.class);
    private final TicketValidator ticketValidator;
    private final TicketFactory ticketFactory;
    private final JwtBuilder jwtBuilder;
    private final ServicesManager servicesManager;
    private final CasConfigurationProperties casProperties;

    @Override
    public String build(String serviceTicketId, WebApplicationService webApplicationService) throws Throwable {
        TicketValidationResult assertion = (TicketValidationResult)FunctionUtils.doUnchecked(() -> this.ticketValidator.validate(serviceTicketId, webApplicationService.getId()));
        LinkedHashMap attributes = new LinkedHashMap(assertion.getAttributes());
        attributes.putAll(assertion.getPrincipal().getAttributes());
        LOGGER.trace("Assertion attributes received are [{}]", attributes);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)webApplicationService);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
        Map finalAttributes = ProtocolAttributeEncoder.decodeAttributes(attributes, (RegisteredService)registeredService, (WebApplicationService)webApplicationService);
        LOGGER.debug("Final attributes decoded are [{}]", (Object)finalAttributes);
        ExpirationPolicyBuilder expirationPolicy = this.ticketFactory.get(ServiceTicket.class).getExpirationPolicyBuilder();
        ZonedDateTime dateTime = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(this.getTimeToLive(expirationPolicy, registeredService));
        Date validUntilDate = DateTimeUtils.dateOf((ChronoZonedDateTime)dateTime);
        JwtBuilder.JwtRequest.JwtRequestBuilder<?, ?> builder = JwtBuilder.JwtRequest.builder();
        Object request = ((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)builder.registeredService(Optional.of(registeredService))).serviceAudience(Set.of(webApplicationService.getId()))).issueDate(new Date())).jwtId(serviceTicketId)).subject(assertion.getPrincipal().getId())).validUntilDate(validUntilDate)).attributes(finalAttributes)).issuer(this.casProperties.getServer().getPrefix())).build();
        LOGGER.debug("Building JWT using [{}]", request);
        return this.jwtBuilder.build((JwtBuilder.JwtRequest)request);
    }

    @Override
    public String build(Authentication authentication, RegisteredService registeredService, String jwtIdentifier, Map<String, List<Object>> claims) throws Throwable {
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>(authentication.getAttributes());
        attributes.putAll(authentication.getPrincipal().getAttributes());
        attributes.putAll(claims);
        ExpirationPolicyBuilder expirationPolicy = this.ticketFactory.get(TicketGrantingTicket.class).getExpirationPolicyBuilder();
        ZonedDateTime dt = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(this.getTimeToLive(expirationPolicy, registeredService));
        Date validUntilDate = DateTimeUtils.dateOf((ChronoZonedDateTime)dt);
        JwtBuilder.JwtRequest.JwtRequestBuilder<?, ?> builder = JwtBuilder.JwtRequest.builder();
        Object request = ((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)((JwtBuilder.JwtRequest.JwtRequestBuilder)builder.serviceAudience(Set.of(this.casProperties.getServer().getPrefix()))).registeredService(Optional.ofNullable(registeredService))).issueDate(DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate()))).jwtId(jwtIdentifier)).subject(authentication.getPrincipal().getId())).validUntilDate(validUntilDate)).attributes(attributes)).issuer(this.casProperties.getServer().getPrefix())).build();
        return this.jwtBuilder.build((JwtBuilder.JwtRequest)request);
    }

    protected Long getTimeToLive(ExpirationPolicyBuilder expirationPolicy, RegisteredService registeredService) {
        Long timeToLive = expirationPolicy.buildTicketExpirationPolicyFor((RegisteredServiceDefinition)registeredService).getTimeToLive();
        return Long.MAX_VALUE == timeToLive ? Long.valueOf(Integer.MAX_VALUE) : timeToLive;
    }

    @Generated
    public JwtTicketBuilder(TicketValidator ticketValidator, TicketFactory ticketFactory, JwtBuilder jwtBuilder, ServicesManager servicesManager, CasConfigurationProperties casProperties) {
        this.ticketValidator = ticketValidator;
        this.ticketFactory = ticketFactory;
        this.jwtBuilder = jwtBuilder;
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
    }
}

