/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.jexl;

import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.core.provisioning.api.jexl.JexlFunctions;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;

public class SyncopeJexlFunctions
implements JexlFunctions {
    @Override
    public String getNamespace() {
        return "syncope";
    }

    public String fullPath2Dn(String fullPath, String attr) {
        return this.fullPath2Dn(fullPath, attr, "");
    }

    public String fullPath2Dn(String fullPath, String attr, String prefix) {
        String[] fullPathSplitted = fullPath.split("/");
        if (fullPathSplitted.length <= 1) {
            return "";
        }
        List<String> headless = Arrays.asList(fullPathSplitted).subList(1, fullPathSplitted.length);
        return prefix + attr + "=" + headless.reversed().stream().collect(Collectors.joining("," + attr + "="));
    }

    public List<Object> connObjAttrValues(ConnectorObject connObj, String name) {
        return Optional.ofNullable(connObj).flatMap(obj -> Optional.ofNullable(obj.getAttributeByName(name)).map(Attribute::getValue)).orElseGet(List::of);
    }

    public String base64Encode(byte[] value) {
        return Base64.getEncoder().encodeToString(value);
    }

    public byte[] base64Decode(String value) {
        return Base64.getDecoder().decode(value);
    }
}

