/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import java.util.Collection;
import java.util.Collections;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class EmptyCollectionType
implements VariableType {
    public static final String TYPE_NAME = "emptyCollection";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final Class<?> EMPTY_LIST_CLASS = Collections.emptyList().getClass();
    private static final Class<?> EMPTY_SET_CLASS = Collections.emptySet().getClass();

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public boolean isAbleToStore(Object value) {
        if (value instanceof Collection) {
            return EMPTY_LIST_CLASS.isInstance(value) || EMPTY_SET_CLASS.isInstance(value);
        }
        return false;
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (EMPTY_LIST_CLASS.isInstance(value)) {
            valueFields.setTextValue(LIST);
        } else {
            valueFields.setTextValue(SET);
        }
    }

    public Object getValue(ValueFields valueFields) {
        String value = valueFields.getTextValue();
        if (LIST.equals(value)) {
            return Collections.emptyList();
        }
        if (SET.equals(value)) {
            return Collections.emptySet();
        }
        return null;
    }
}

