/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.repository.config.AotRepositoryInformation;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryFragmentConfigurationProvider;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.util.Lazy;
import org.springframework.util.ClassUtils;

class RepositoryBeanDefinitionReader {
    RepositoryBeanDefinitionReader() {
    }

    static RepositoryInformation readRepositoryInformation(RepositoryConfiguration<?> metadata, ConfigurableListableBeanFactory beanFactory) {
        return new AotRepositoryInformation(RepositoryBeanDefinitionReader.metadataSupplier(metadata, beanFactory), RepositoryBeanDefinitionReader.repositoryBaseClass(metadata, beanFactory), RepositoryBeanDefinitionReader.fragments(metadata, beanFactory));
    }

    private static Supplier<Collection<RepositoryFragment<?>>> fragments(RepositoryConfiguration<?> metadata, ConfigurableListableBeanFactory beanFactory) {
        if (metadata instanceof RepositoryFragmentConfigurationProvider) {
            RepositoryFragmentConfigurationProvider provider = (RepositoryFragmentConfigurationProvider)((Object)metadata);
            return Lazy.of(() -> provider.getFragmentConfiguration().stream().flatMap(it -> {
                ArrayList fragments = new ArrayList(1);
                fragments.add(RepositoryFragment.implemented(RepositoryBeanDefinitionReader.forName(it.getClassName(), beanFactory)));
                fragments.add(RepositoryFragment.structural(RepositoryBeanDefinitionReader.forName(it.getInterfaceName(), beanFactory)));
                return fragments.stream();
            }).collect(Collectors.toList()));
        }
        return Lazy.of(Collections::emptyList);
    }

    private static Supplier<Class<?>> repositoryBaseClass(RepositoryConfiguration metadata, ConfigurableListableBeanFactory beanFactory) {
        return Lazy.of(() -> (Class)metadata.getRepositoryBaseClassName().map(it -> RepositoryBeanDefinitionReader.forName(it.toString(), beanFactory)).orElseGet(() -> Object.class));
    }

    private static Supplier<RepositoryMetadata> metadataSupplier(RepositoryConfiguration<?> metadata, ConfigurableListableBeanFactory beanFactory) {
        return Lazy.of(() -> new DefaultRepositoryMetadata(RepositoryBeanDefinitionReader.forName(metadata.getRepositoryInterface(), beanFactory)));
    }

    static Class<?> forName(String name, ConfigurableListableBeanFactory beanFactory) {
        try {
            return ClassUtils.forName((String)name, (ClassLoader)beanFactory.getBeanClassLoader());
        }
        catch (ClassNotFoundException cause) {
            throw new TypeNotPresentException(name, cause);
        }
    }
}

