/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.wicket.util.string.Strings;

public class LocaleUtils {
    public static final int DEFAULT_STYLE = 3;

    private LocaleUtils() {
    }

    public static String getLangageCode(Locale locale) {
        if (!Strings.isEmpty((String)locale.getCountry())) {
            return String.format("%s-%s", locale.getLanguage(), locale.getCountry());
        }
        return locale.getLanguage();
    }

    public static String getLocaleDatePattern(Locale locale) {
        return LocaleUtils.getLocaleDatePattern(locale, 3, null);
    }

    public static String getLocaleDatePattern(Locale locale, int style) {
        return LocaleUtils.getLocaleDatePattern(locale, style, null);
    }

    public static String getLocaleDatePattern(Locale locale, String defaultPattern) {
        return LocaleUtils.getLocaleDatePattern(locale, 3, defaultPattern);
    }

    public static String getLocaleDatePattern(Locale locale, int style, String defaultPattern) {
        DateFormat format = DateFormat.getDateInstance(style, locale);
        if (format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)format).toPattern();
        }
        return defaultPattern;
    }

    public static String getLocaleTimePattern(Locale locale) {
        return LocaleUtils.getLocaleTimePattern(locale, 3, null);
    }

    public static String getLocaleTimePattern(Locale locale, int style) {
        return LocaleUtils.getLocaleTimePattern(locale, style, null);
    }

    public static String getLocaleTimePattern(Locale locale, String defaultPattern) {
        return LocaleUtils.getLocaleTimePattern(locale, 3, defaultPattern);
    }

    public static String getLocaleTimePattern(Locale locale, int style, String defaultPattern) {
        DateFormat format = DateFormat.getTimeInstance(style, locale);
        if (format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)format).toPattern();
        }
        return defaultPattern;
    }
}

