/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import javax.annotation.Nonnull;
import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;

public class BasicKeyAgreementCredential
extends BasicCredential
implements KeyAgreementCredential {
    @Nonnull
    private String algorithm;
    @Nonnull
    private Credential originatorCredential;
    @Nonnull
    private Credential recipientCredential;
    @Nonnull
    private KeyAgreementParameters parameters;

    public BasicKeyAgreementCredential(@Nonnull SecretKey derivedKey, @Nonnull String agreementAlgorithm, @Nonnull Credential originator, @Nonnull Credential recipient) {
        super((SecretKey)Constraint.isNotNull((Object)derivedKey, (String)"SecretKey was null"));
        this.algorithm = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)agreementAlgorithm), (String)"Algorithm was null");
        this.originatorCredential = (Credential)Constraint.isNotNull((Object)originator, (String)"Originator credential was null");
        this.recipientCredential = (Credential)Constraint.isNotNull((Object)recipient, (String)"Recipient credential was null");
        this.parameters = new KeyAgreementParameters();
    }

    @Nonnull
    public Class<? extends Credential> getCredentialType() {
        return KeyAgreementCredential.class;
    }

    @Nonnull
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Nonnull
    public Credential getOriginatorCredential() {
        return this.originatorCredential;
    }

    @Nonnull
    public Credential getRecipientCredential() {
        return this.recipientCredential;
    }

    @Nonnull
    public KeyAgreementParameters getParameters() {
        return this.parameters;
    }
}

