/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.ColumnFormatter;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.FormattableColumn;
import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPResultCode
extends CommandLineTool {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 2;
    @NotNull
    private static final String JSON_FIELD_INT_VALUE = "int-value";
    @NotNull
    private static final String JSON_FIELD_NAME = "name";
    @NotNull
    private static final String OUTPUT_FORMAT_CSV = "csv";
    @NotNull
    private static final String OUTPUT_FORMAT_JSON = "json";
    @NotNull
    private static final String OUTPUT_FORMAT_TAB_DELIMITED = "tab-delimited";
    @NotNull
    private static final String OUTPUT_FORMAT_TABLE = "table";
    @Nullable
    private BooleanArgument alphabeticOrderArg = null;
    @Nullable
    private BooleanArgument listArg = null;
    @Nullable
    private BooleanArgument scriptFriendlyArg = null;
    @Nullable
    private IntegerArgument intValueArg = null;
    @Nullable
    private StringArgument outputFormatArg = null;
    @Nullable
    private StringArgument searchArg = null;

    public static void main(String ... args) {
        ResultCode resultCode = LDAPResultCode.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        LDAPResultCode tool = new LDAPResultCode(out, err);
        return tool.runTool(args);
    }

    public LDAPResultCode(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "ldap-result-code";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return ToolMessages.INFO_LDAP_RC_TOOL_DESC_1.get();
    }

    @Override
    @NotNull
    public List<String> getAdditionalDescriptionParagraphs() {
        return Arrays.asList(ToolMessages.INFO_LDAP_RC_TOOL_DESC_2.get(), ToolMessages.INFO_LDAP_RC_TOOL_DESC_3.get());
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.10";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return false;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return false;
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.listArg = new BooleanArgument(Character.valueOf('l'), "list", 1, ToolMessages.INFO_LDAP_RC_ARG_DESC_LIST.get());
        parser.addArgument(this.listArg);
        this.intValueArg = new IntegerArgument(Character.valueOf('i'), JSON_FIELD_INT_VALUE, false, 1, ToolMessages.INFO_LDAP_RC_ARG_PLACEHOLDER_INT_VALUE.get(), ToolMessages.INFO_LDAP_RC_ARG_DESC_INT_VALUE.get());
        this.intValueArg.addLongIdentifier("intValue", true);
        parser.addArgument(this.intValueArg);
        this.searchArg = new StringArgument(Character.valueOf('S'), "search", false, 1, ToolMessages.INFO_LDAP_RC_ARG_PLACEHOLDER_SEARCH_STRING.get(), ToolMessages.INFO_LDAP_RC_ARG_DESC_SEARCH.get());
        parser.addArgument(this.searchArg);
        this.alphabeticOrderArg = new BooleanArgument(Character.valueOf('a'), "alphabetic-order", 1, ToolMessages.INFO_LDAP_RC_ARG_DESC_ALPHABETIC.get());
        this.alphabeticOrderArg.addLongIdentifier("alphabeticOrder", true);
        this.alphabeticOrderArg.addLongIdentifier("alphabetical-order", true);
        this.alphabeticOrderArg.addLongIdentifier("alphabeticalOrder", true);
        this.alphabeticOrderArg.addLongIdentifier("alphabetic", true);
        this.alphabeticOrderArg.addLongIdentifier("alphabetical", true);
        parser.addArgument(this.alphabeticOrderArg);
        this.outputFormatArg = new StringArgument(null, "output-format", false, 1, ToolMessages.INFO_LDAP_RC_ARG_PLACEHOLDER_OUTPUT_FORMAT.get(), ToolMessages.INFO_LDAP_RC_ARG_DESC_OUTPUT_FORMAT.get(), StaticUtils.setOf(OUTPUT_FORMAT_CSV, OUTPUT_FORMAT_JSON, OUTPUT_FORMAT_TAB_DELIMITED, OUTPUT_FORMAT_TABLE));
        this.outputFormatArg.addLongIdentifier("outputFormat", true);
        this.outputFormatArg.addLongIdentifier("format", true);
        parser.addArgument(this.outputFormatArg);
        this.scriptFriendlyArg = new BooleanArgument(null, "script-friendly", 1, ToolMessages.INFO_LDAP_RC_ARG_DESC_SCRIPT_FRIENDLY.get());
        this.scriptFriendlyArg.addLongIdentifier("scriptFriendly", true);
        this.scriptFriendlyArg.setHidden(true);
        parser.addArgument(this.scriptFriendlyArg);
        parser.addExclusiveArgumentSet(this.listArg, this.intValueArg, this.searchArg);
        parser.addExclusiveArgumentSet(this.outputFormatArg, this.scriptFriendlyArg, new Argument[0]);
    }

    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        OutputFormat outputFormat;
        boolean json;
        boolean scriptFriendly;
        TreeMap<Integer, ResultCode> resultCodesByIntValue = new TreeMap<Integer, ResultCode>();
        TreeMap<String, ResultCode> resultCodesByName = new TreeMap<String, ResultCode>();
        if (this.intValueArg != null && this.intValueArg.isPresent()) {
            int intValue = this.intValueArg.getValue();
            ResultCode rc = ResultCode.valueOf(intValue, null, false);
            if (rc != null) {
                resultCodesByIntValue.put(intValue, rc);
                resultCodesByName.put(StaticUtils.toLowerCase(rc.getName()), rc);
            }
        } else {
            String searchString = this.searchArg != null && this.searchArg.isPresent() ? StaticUtils.toLowerCase(this.searchArg.getValue()) : null;
            for (ResultCode rc : ResultCode.values()) {
                String name = rc.getName();
                String lowerName = StaticUtils.toLowerCase(name);
                if (searchString != null && !lowerName.contains(searchString)) continue;
                resultCodesByIntValue.put(rc.intValue(), rc);
                resultCodesByName.put(lowerName, rc);
            }
        }
        if (resultCodesByIntValue.isEmpty()) {
            this.wrapErr(0, WRAP_COLUMN, ToolMessages.ERR_LDAP_RC_NO_RESULTS.get());
            return ResultCode.NO_RESULTS_RETURNED;
        }
        String nameLabel = ToolMessages.INFO_LDAP_RC_NAME_LABEL.get();
        String intValueLabel = ToolMessages.INFO_LDAP_RC_INT_VALUE_LABEL.get();
        int numCharsInLongestName = nameLabel.length();
        int numCharsInLongestIntValue = intValueLabel.length();
        for (Map.Entry e : resultCodesByIntValue.entrySet()) {
            String intValueString = String.valueOf(e.getKey());
            numCharsInLongestIntValue = Math.max(numCharsInLongestIntValue, intValueString.length());
            String name = ((ResultCode)e.getValue()).getName();
            numCharsInLongestName = Math.max(numCharsInLongestName, name.length());
        }
        boolean bl = scriptFriendly = this.scriptFriendlyArg != null && this.scriptFriendlyArg.isPresent();
        if (scriptFriendly) {
            json = false;
            outputFormat = OutputFormat.TAB_DELIMITED_TEXT;
        } else if (this.outputFormatArg != null && this.outputFormatArg.isPresent()) {
            String outputFormatValue = StaticUtils.toLowerCase(this.outputFormatArg.getValue());
            if (outputFormatValue.equals(OUTPUT_FORMAT_CSV)) {
                json = false;
                outputFormat = OutputFormat.CSV;
            } else if (outputFormatValue.equals(OUTPUT_FORMAT_JSON)) {
                json = true;
                outputFormat = null;
            } else if (outputFormatValue.equals(OUTPUT_FORMAT_TAB_DELIMITED)) {
                json = false;
                outputFormat = OutputFormat.TAB_DELIMITED_TEXT;
            } else {
                json = false;
                outputFormat = OutputFormat.COLUMNS;
            }
        } else {
            json = false;
            outputFormat = OutputFormat.COLUMNS;
        }
        ColumnFormatter formatter = json ? null : new ColumnFormatter(false, null, outputFormat, " | ", new FormattableColumn(numCharsInLongestName, HorizontalAlignment.LEFT, nameLabel), new FormattableColumn(numCharsInLongestIntValue, HorizontalAlignment.LEFT, intValueLabel));
        if (formatter != null && outputFormat == OutputFormat.COLUMNS) {
            for (String line : formatter.getHeaderLines(true)) {
                this.out(line);
            }
        }
        Collection resultCodes = this.alphabeticOrderArg != null && this.alphabeticOrderArg.isPresent() ? resultCodesByName.values() : resultCodesByIntValue.values();
        for (ResultCode rc : resultCodes) {
            if (formatter == null) {
                JSONObject jsonObject = new JSONObject(new JSONField(JSON_FIELD_NAME, rc.getName()), new JSONField(JSON_FIELD_INT_VALUE, rc.intValue()));
                this.out(jsonObject.toSingleLineString());
                continue;
            }
            this.out(formatter.formatRow(rc.getName(), rc.intValue()));
        }
        return ResultCode.SUCCESS;
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        examples.put(StaticUtils.NO_STRINGS, ToolMessages.INFO_LDAP_RC_EXAMPLE_1.get());
        examples.put(new String[]{"--int-value", "49", "--output-format", OUTPUT_FORMAT_JSON}, ToolMessages.INFO_LDAP_RC_EXAMPLE_2.get());
        examples.put(new String[]{"--search", "attribute"}, ToolMessages.INFO_LDAP_RC_EXAMPLE_3.get());
        return examples;
    }
}

