/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCacheKey;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlan;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jooq.lambda.Unchecked;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRegisteredServiceMetadataResolverCacheLoader
implements CacheLoader<SamlRegisteredServiceCacheKey, MetadataResolver> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceMetadataResolverCacheLoader.class);
    @Generated
    private final Object $lock = new Object[0];
    protected final OpenSamlConfigBean configBean;
    protected final HttpClient httpClient;
    private final SamlRegisteredServiceMetadataResolutionPlan metadataResolutionPlan;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainingMetadataResolver load(SamlRegisteredServiceCacheKey cacheKey) {
        Object object = this.$lock;
        synchronized (object) {
            ChainingMetadataResolver metadataResolver = new ChainingMetadataResolver();
            SamlRegisteredService service = cacheKey.getRegisteredService();
            Collection<SamlRegisteredServiceMetadataResolver> availableResolvers = this.metadataResolutionPlan.getRegisteredMetadataResolvers();
            int size = availableResolvers.size();
            ArrayList metadataResolvers = new ArrayList(size);
            LOGGER.debug("There are [{}] metadata resolver(s) available in the chain", (Object)size);
            availableResolvers.stream().filter(Objects::nonNull).filter(r -> {
                LOGGER.trace("Evaluating whether metadata resolver [{}] can support service [{}]", (Object)r.getName(), (Object)service.getName());
                return r.supports(service);
            }).map(Unchecked.function(r -> {
                LOGGER.trace("Metadata resolver [{}] has started to process metadata for [{}]", (Object)r.getName(), (Object)service.getName());
                return r.resolve(service, cacheKey.getCriteriaSet());
            })).forEach(metadataResolvers::addAll);
            if (metadataResolvers.isEmpty()) {
                String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
                throw new SamlException("No metadata resolvers could be configured for service " + service.getName() + " with metadata location " + metadataLocation);
            }
            FunctionUtils.doUnchecked(u -> {
                metadataResolver.setId(ChainingMetadataResolver.class.getCanonicalName());
                LOGGER.trace("There are [{}] eligible metadata resolver(s) for this request", (Object)metadataResolvers.size());
                metadataResolver.setResolvers((List)metadataResolvers);
                metadataResolver.initialize();
            }, (Object[])new Object[0]);
            LOGGER.debug("Metadata resolvers active for this request are [{}]", metadataResolvers);
            return metadataResolver;
        }
    }

    @Generated
    public SamlRegisteredServiceMetadataResolverCacheLoader(OpenSamlConfigBean configBean, HttpClient httpClient, SamlRegisteredServiceMetadataResolutionPlan metadataResolutionPlan) {
        this.configBean = configBean;
        this.httpClient = httpClient;
        this.metadataResolutionPlan = metadataResolutionPlan;
    }
}

