/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.enduser.layout.SidebarLayout;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.Dashboard;
import org.apache.syncope.client.enduser.pages.EditChangePassword;
import org.apache.syncope.client.enduser.pages.EditSecurityQuestion;
import org.apache.syncope.client.enduser.pages.EditUser;
import org.apache.syncope.client.ui.commons.annotations.AMPage;
import org.apache.syncope.client.ui.commons.annotations.ExtPage;
import org.apache.syncope.client.ui.commons.annotations.IdMPage;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;

public class Sidebar
extends Panel {
    private static final long serialVersionUID = 8091307811313529503L;
    protected WebMarkupContainer dashboardLIContainer;
    protected WebMarkupContainer profileULContainer;
    protected WebMarkupContainer profileLIContainer;

    public Sidebar(String id, final PageReference pageRef) {
        super(id);
        this.buildBaseSidebar();
        WebMarkupContainer containingLI = null;
        if (this.dashboardLIContainer.getId().equals(this.getLIContainerId(pageRef.getPage().getClass().getSimpleName().toLowerCase()))) {
            containingLI = this.dashboardLIContainer;
        }
        if (containingLI == null) {
            containingLI = (WebMarkupContainer)this.profileULContainer.get(this.getLIContainerId(pageRef.getPage().getClass().getSimpleName().toLowerCase()));
        }
        if (containingLI != null) {
            StreamSupport.stream(containingLI.spliterator(), false).filter(Link.class::isInstance).forEach(child -> child.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = -5775607340182293596L;

                public void onComponentTag(Component component, ComponentTag tag) {
                    tag.append("class", (CharSequence)"active", " ");
                }
            }}));
            if (this.profileULContainer.getId().equals(containingLI.getParent().getId())) {
                this.profileULContainer.add(new Behavior[]{new Behavior(){
                    private static final long serialVersionUID = 3109256773218160485L;

                    public void renderHead(Component component, IHeaderResponse response) {
                        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)"$('#profileLink').addClass('active')"));
                    }

                    public void onComponentTag(Component component, ComponentTag tag) {
                        tag.put("class", (CharSequence)"nav nav-treeview");
                        tag.put("style", (CharSequence)"display: block;");
                    }
                }});
                this.profileLIContainer.add(new Behavior[]{new Behavior(){
                    private static final long serialVersionUID = 3109256773218160485L;

                    public void onComponentTag(Component component, ComponentTag tag) {
                        tag.put("class", (CharSequence)"nav-item has-treeview menu-open");
                    }
                }});
            }
        }
        List<Class<? extends BasePage>> idmPageClasses = SyncopeWebApplication.get().getLookup().getIdMPageClasses();
        ListView<Class<? extends BasePage>> idmPages = new ListView<Class<? extends BasePage>>("idmPages", idmPageClasses){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<Class<? extends BasePage>> item) {
                WebMarkupContainer containingLI = new WebMarkupContainer("idmPageLI");
                item.add(new Component[]{containingLI});
                IdMPage ann = ((Class)item.getModelObject()).getAnnotation(IdMPage.class);
                BookmarkablePageLink link = new BookmarkablePageLink("idmPage", (Class)item.getModelObject());
                link.add(new Component[]{new Label("idmPageLabel", (Serializable)((Object)ann.label()))});
                if (((Class)item.getModelObject()).equals(pageRef.getPage().getClass())) {
                    link.add(new Behavior[]{new Behavior(){
                        private static final long serialVersionUID = 1469628524240283489L;

                        public void onComponentTag(Component component, ComponentTag tag) {
                            tag.append("class", (CharSequence)"active", " ");
                        }
                    }});
                }
                containingLI.add(new Component[]{link});
                Label idmPageIcon = new Label("idmPageIcon");
                idmPageIcon.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)("nav-icon " + ann.icon())))});
                link.add(new Component[]{idmPageIcon});
            }
        };
        this.add(new Component[]{idmPages.setRenderBodyOnly(true).setOutputMarkupId(true)});
        List<Class<? extends BasePage>> amPageClasses = SyncopeWebApplication.get().getLookup().getAMPageClasses();
        ListView<Class<? extends BasePage>> amPages = new ListView<Class<? extends BasePage>>("amPages", amPageClasses){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<Class<? extends BasePage>> item) {
                WebMarkupContainer containingLI = new WebMarkupContainer("amPageLI");
                item.add(new Component[]{containingLI});
                AMPage ann = ((Class)item.getModelObject()).getAnnotation(AMPage.class);
                BookmarkablePageLink link = new BookmarkablePageLink("amPage", (Class)item.getModelObject());
                link.add(new Component[]{new Label("amPageLabel", (Serializable)((Object)ann.label()))});
                if (((Class)item.getModelObject()).equals(pageRef.getPage().getClass())) {
                    link.add(new Behavior[]{new Behavior(){
                        private static final long serialVersionUID = 1469628524240283489L;

                        public void onComponentTag(Component component, ComponentTag tag) {
                            tag.append("class", (CharSequence)"active", " ");
                        }
                    }});
                }
                containingLI.add(new Component[]{link});
                Label amPageIcon = new Label("amPageIcon");
                amPageIcon.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)("nav-icon " + ann.icon())))});
                link.add(new Component[]{amPageIcon});
            }
        };
        this.add(new Component[]{amPages.setRenderBodyOnly(true).setOutputMarkupId(true)});
        List<Class<? extends BasePage>> extPageClasses = SyncopeWebApplication.get().getLookup().getExtPageClasses();
        ListView<Class<? extends BasePage>> extPages = new ListView<Class<? extends BasePage>>("extPages", extPageClasses.stream().filter(epc -> SyncopeWebApplication.get().getCustomFormLayout().getSidebarLayout().isExtensionEnabled(StringUtils.remove((String)epc.getAnnotation(ExtPage.class).label(), (String)" "))).collect(Collectors.toList())){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<Class<? extends BasePage>> item) {
                WebMarkupContainer containingLI = new WebMarkupContainer("extPageLI");
                item.add(new Component[]{containingLI});
                ExtPage ann = ((Class)item.getModelObject()).getAnnotation(ExtPage.class);
                BookmarkablePageLink link = new BookmarkablePageLink("extPage", (Class)item.getModelObject());
                link.add(new Component[]{new Label("extPageLabel", (Serializable)((Object)ann.label()))});
                if (((Class)item.getModelObject()).equals(pageRef.getPage().getClass())) {
                    link.add(new Behavior[]{new Behavior(){
                        private static final long serialVersionUID = 1469628524240283489L;

                        public void renderHead(Component component, IHeaderResponse response) {
                            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)"$('#extensionsLink').addClass('active')"));
                        }

                        public void onComponentTag(Component component, ComponentTag tag) {
                            tag.append("class", (CharSequence)"active", " ");
                        }
                    }});
                }
                containingLI.add(new Component[]{link});
                Label extPageIcon = new Label("extPageIcon");
                extPageIcon.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)("nav-icon " + ann.icon())))});
                link.add(new Component[]{extPageIcon});
            }
        };
        this.add(new Component[]{extPages.setRenderBodyOnly(true).setOutputMarkupId(true)});
    }

    protected void buildBaseSidebar() {
        SidebarLayout layout = SyncopeWebApplication.get().getCustomFormLayout().getSidebarLayout();
        this.dashboardLIContainer = new WebMarkupContainer(this.getLIContainerId("dashboard"));
        this.add(new Component[]{this.dashboardLIContainer});
        this.dashboardLIContainer.add(new Component[]{BookmarkablePageLinkBuilder.build("home", SyncopeWebApplication.get().getPageClass("profile", Dashboard.class))});
        this.profileLIContainer = new WebMarkupContainer(this.getLIContainerId("profile"));
        this.add(new Component[]{this.profileLIContainer});
        this.profileULContainer = new WebMarkupContainer(this.getULContainerId("profile"));
        this.profileLIContainer.add(new Component[]{this.profileULContainer});
        this.profileLIContainer.setVisible(layout.isEditUserEnabled() || layout.isPasswordManagementEnabled() || layout.isSecurityQuestionManagementEnabled() && SyncopeEnduserSession.get().getPlatformInfo().isPwdResetRequiringSecurityQuestions());
        WebMarkupContainer liContainer = new WebMarkupContainer(this.getLIContainerId("edituser"));
        this.profileULContainer.add(new Component[]{liContainer});
        liContainer.add(new Component[]{BookmarkablePageLinkBuilder.build("edituser", EditUser.class)}).setVisible(layout.isEditUserEnabled());
        liContainer = new WebMarkupContainer(this.getLIContainerId("editchangepassword"));
        this.profileULContainer.add(new Component[]{liContainer});
        liContainer.add(new Component[]{BookmarkablePageLinkBuilder.build("editchangepassword", EditChangePassword.class)}).setVisible(layout.isPasswordManagementEnabled());
        liContainer = new WebMarkupContainer(this.getLIContainerId("editsecurityquestion"));
        this.profileULContainer.add(new Component[]{liContainer});
        liContainer.add(new Component[]{BookmarkablePageLinkBuilder.build("editsecurityquestion", EditSecurityQuestion.class)});
        liContainer.setOutputMarkupPlaceholderTag(true);
        liContainer.setVisible(layout.isSecurityQuestionManagementEnabled() && SyncopeEnduserSession.get().getPlatformInfo().isPwdResetRequiringSecurityQuestions());
    }

    protected String getLIContainerId(String linkId) {
        return linkId + "LI";
    }

    protected String getULContainerId(String linkId) {
        return linkId + "UL";
    }
}

