/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.FilterName;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.Node;
import org.apache.sis.filter.base.XPathSource;

final class IdentifierFilter
extends Node
implements Filter<AbstractFeature>,
XPathSource,
Optimization.OnFilter<AbstractFeature> {
    private static final long serialVersionUID = 5917022442937908715L;
    private final String property;
    private final String identifier;

    public IdentifierFilter(String identifier) {
        this.property = "sis:identifier";
        this.identifier = Objects.requireNonNull(identifier);
    }

    @Override
    public Enum<?> getOperatorType() {
        return FilterName.RESOURCE_ID;
    }

    private IdentifierFilter(IdentifierFilter original, String property) {
        this.property = property;
        this.identifier = original.identifier;
    }

    @Override
    public Filter<AbstractFeature> optimize(Optimization optimization) {
        block3: {
            HashSet<String> found = new HashSet<String>();
            try {
                String preferredName = optimization.getPreferredPropertyName(this.property, found);
                if (!preferredName.equals(this.property)) {
                    return new IdentifierFilter(this, preferredName);
                }
            }
            catch (IllegalArgumentException e) {
                boolean resolved = found.isEmpty();
                optimization.warning(e, !resolved);
                if (!resolved) break block3;
                return Filter.exclude();
            }
        }
        return this;
    }

    @Override
    public Class<AbstractFeature> getResourceClass() {
        return AbstractFeature.class;
    }

    @Override
    public String getXPath() {
        return this.property;
    }

    @Override
    public List<Expression<AbstractFeature, ?>> getExpressions() {
        return List.of(new LeafExpression.Literal(this.identifier));
    }

    @Override
    protected Collection<?> getChildren() {
        return List.of(this.property, this.identifier);
    }

    @Override
    public boolean test(AbstractFeature object) {
        if (object != null) {
            try {
                Object id = object.getPropertyValue(this.property);
                if (id != null) {
                    return this.identifier.equals(id.toString());
                }
            }
            catch (IllegalArgumentException e) {
                this.warning(e);
            }
        }
        return false;
    }
}

