/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.localregistry;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Collection;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.localregistry.LocalRegistryStore;
import org.apache.servicecomb.registry.api.Registration;
import org.apache.servicecomb.registry.api.event.MicroserviceInstanceRegisteredEvent;
import org.apache.servicecomb.registry.api.registry.BasePath;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstanceStatus;

public class LocalRegistration
implements Registration {
    public static final String NAME = "local registration";
    private final LocalRegistryStore localRegistrationStore = LocalRegistryStore.INSTANCE;

    public void init() {
        this.localRegistrationStore.init();
    }

    public void run() {
        this.localRegistrationStore.run();
        EventManager.getEventBus().post((Object)new MicroserviceInstanceRegisteredEvent(NAME, this.localRegistrationStore.getSelfMicroserviceInstance().getInstanceId(), false));
    }

    public void destroy() {
    }

    public int getOrder() {
        return 0;
    }

    public String name() {
        return NAME;
    }

    public MicroserviceInstance getMicroserviceInstance() {
        return this.localRegistrationStore.getSelfMicroserviceInstance();
    }

    public Microservice getMicroservice() {
        return this.localRegistrationStore.getSelfMicroservice();
    }

    public String getAppId() {
        return this.localRegistrationStore.getSelfMicroservice().getAppId();
    }

    public boolean updateMicroserviceInstanceStatus(MicroserviceInstanceStatus status) {
        this.localRegistrationStore.getSelfMicroserviceInstance().setStatus(status);
        return true;
    }

    public void addSchema(String schemaId, String content) {
        this.localRegistrationStore.getSelfMicroservice().addSchema(schemaId, content);
    }

    public void addEndpoint(String endpoint) {
        this.localRegistrationStore.getSelfMicroserviceInstance().getEndpoints().add(endpoint);
    }

    public void addBasePath(Collection<BasePath> basePaths) {
        this.localRegistrationStore.getSelfMicroservice().getPaths().addAll(basePaths);
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.local.registry.enabled", true).get();
    }
}

