/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.hook;

import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.client.java.hook.Attribute;
import org.apache.rocketmq.client.java.hook.AttributeKey;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.hook.MessageInterceptorContext;

public class MessageInterceptorContextImpl
implements MessageInterceptorContext {
    private final MessageHookPoints messageHookPoints;
    private MessageHookPointsStatus status;
    private final Map<AttributeKey, Attribute> attributes;

    public MessageInterceptorContextImpl(MessageHookPoints messageHookPoints) {
        this.messageHookPoints = messageHookPoints;
        this.status = MessageHookPointsStatus.UNSET;
        this.attributes = new HashMap<AttributeKey, Attribute>();
    }

    public MessageInterceptorContextImpl(MessageHookPoints messageHookPoints, MessageHookPointsStatus status) {
        this.messageHookPoints = messageHookPoints;
        this.status = status;
        this.attributes = new HashMap<AttributeKey, Attribute>();
    }

    public MessageInterceptorContextImpl(MessageHookPoints messageHookPoints, MessageHookPointsStatus status, Map<AttributeKey, Attribute> attributes) {
        this.messageHookPoints = messageHookPoints;
        this.status = status;
        this.attributes = attributes;
    }

    public MessageInterceptorContextImpl(MessageInterceptorContextImpl context, MessageHookPointsStatus status) {
        this.messageHookPoints = context.messageHookPoints;
        this.status = status;
        this.attributes = context.attributes;
    }

    @Override
    public MessageHookPoints getMessageHookPoints() {
        return this.messageHookPoints;
    }

    @Override
    public MessageHookPointsStatus getStatus() {
        return this.status;
    }

    public void setStatus(MessageHookPointsStatus status) {
        this.status = status;
    }

    @Override
    public <T> Attribute<T> getAttribute(AttributeKey<T> key) {
        return this.attributes.get(key);
    }

    @Override
    public <T> void putAttribute(AttributeKey<T> key, Attribute<T> attribute) {
        this.attributes.put(key, attribute);
    }

    public Map<AttributeKey, Attribute> getAttributes() {
        return this.attributes;
    }
}

