/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.batch.BatchParserResult;
import org.apache.olingo.odata2.api.batch.BatchRequestPart;
import org.apache.olingo.odata2.api.client.batch.BatchSingleResponse;
import org.apache.olingo.odata2.api.ep.EntityProviderBatchProperties;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.core.batch.v2.BatchBodyPart;
import org.apache.olingo.odata2.core.batch.v2.BatchLineReader;
import org.apache.olingo.odata2.core.batch.v2.BatchParserCommon;
import org.apache.olingo.odata2.core.batch.v2.BatchRequestTransformator;
import org.apache.olingo.odata2.core.batch.v2.BatchResponseTransformator;
import org.apache.olingo.odata2.core.batch.v2.BatchTransformator;
import org.apache.olingo.odata2.core.batch.v2.Line;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;

public class BatchParser {
    private final PathInfo batchRequestPathInfo;
    private final String contentTypeMime;
    private final boolean isStrict;

    public BatchParser(String contentType, boolean isStrict) {
        this(contentType, null, isStrict);
    }

    public BatchParser(String contentType, EntityProviderBatchProperties properties, boolean isStrict) {
        this.contentTypeMime = contentType;
        this.batchRequestPathInfo = properties != null ? properties.getPathInfo() : null;
        this.isStrict = isStrict;
    }

    public List<BatchSingleResponse> parseBatchResponse(InputStream in) throws BatchException {
        return this.parse(in, new BatchResponseTransformator());
    }

    public List<BatchRequestPart> parseBatchRequest(InputStream in) throws BatchException {
        return this.parse(in, new BatchRequestTransformator());
    }

    private List<? extends BatchParserResult> parse(InputStream in, BatchTransformator transformator) throws BatchException {
        try {
            List<BatchParserResult> list = this.parseBatch(in, transformator);
            return list;
        }
        catch (IOException e) {
            throw new ODataRuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new ODataRuntimeException(e);
            }
        }
    }

    private List<BatchParserResult> parseBatch(InputStream in, BatchTransformator transformator) throws BatchException, IOException {
        String baseUri = this.getBaseUri();
        String boundary = BatchParserCommon.getBoundary(this.contentTypeMime, 1);
        LinkedList<BatchParserResult> resultList = new LinkedList<BatchParserResult>();
        List<List<Line>> bodyPartStrings = this.splitBodyParts(in, boundary);
        for (List<Line> bodyPartString : bodyPartStrings) {
            BatchBodyPart bodyPart = new BatchBodyPart(bodyPartString, boundary, this.isStrict).parse();
            resultList.addAll(transformator.transform(bodyPart, this.batchRequestPathInfo, baseUri));
        }
        return resultList;
    }

    private List<List<Line>> splitBodyParts(InputStream in, String boundary) throws IOException, BatchException {
        BatchLineReader reader = new BatchLineReader(in);
        List<Line> message = reader.toLineList();
        reader.close();
        return BatchParserCommon.splitMessageByBoundary(message, boundary);
    }

    private String getBaseUri() throws BatchException {
        String baseUri = "";
        if (this.batchRequestPathInfo != null && this.batchRequestPathInfo.getServiceRoot() != null) {
            String uri = this.batchRequestPathInfo.getServiceRoot().toASCIIString();
            baseUri = this.removeLastSlash(uri);
        }
        return baseUri;
    }

    private String removeLastSlash(String baseUri) {
        if (baseUri.lastIndexOf(47) == baseUri.length() - 1) {
            baseUri = baseUri.substring(0, baseUri.length() - 1);
        }
        return baseUri;
    }
}

