/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.nb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.implspi.SchedulerControl;
import org.netbeans.modules.parsing.implspi.SourceControl;
import org.netbeans.modules.parsing.implspi.SourceEnvironment;
import org.netbeans.modules.parsing.implspi.TaskProcessorControl;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.WeakListeners;

final class EventSupport
extends SourceEnvironment {
    private static final Logger LOGGER = Logger.getLogger(EventSupport.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("parsing-event-collector", 1, false, false);
    private DocListener docListener;
    private DataObjectListener dobjListener;
    private static final EditorRegistryListener editorRegistryListener = new EditorRegistryListener();
    private static final Map<Scheduler, SchedL> scheduledSources = new HashMap<Scheduler, SchedL>(7);

    public EventSupport(SourceControl sourceControl) {
        super(sourceControl);
    }

    @Override
    public Document readDocument(FileObject fileObject, boolean forceOpen) {
        EditorCookie ec = null;
        try {
            DataObject dataObject = DataObject.find(fileObject);
            ec = dataObject.getLookup().lookup(EditorCookie.class);
        }
        catch (DataObjectNotFoundException dataObject) {
            // empty catch block
        }
        if (ec == null) {
            return null;
        }
        StyledDocument doc = ec.getDocument();
        if (doc == null && forceOpen) {
            try {
                try {
                    doc = ec.openDocument();
                }
                catch (UserQuestionException uqe) {
                    uqe.confirmed();
                    doc = ec.openDocument();
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
        }
        return doc;
    }

    @Override
    public void activate() {
        Source source = this.getSourceControl().getSource();
        FileObject fo = source.getFileObject();
        if (fo != null) {
            try {
                this.listenOnFileChanges();
                this.listenOnParser();
                DataObject dObj = DataObject.find(fo);
                this.assignDocumentListener(dObj);
                this.dobjListener = new DataObjectListener(dObj);
            }
            catch (DataObjectNotFoundException e) {
                LOGGER.log(Level.WARNING, "Ignoring events non existent file: {0}", FileUtil.getFileDisplayName(fo));
            }
        } else {
            Document doc = source.getDocument(false);
            if (doc != null) {
                this.listenOnParser();
                this.docListener = new DocListener(doc);
            }
        }
    }

    @Override
    public boolean isReparseBlocked() {
        return EditorRegistryListener.k24.get();
    }

    private void resetState(boolean invalidate, boolean mimeChanged, int startOffset, int endOffset, boolean fast) {
        if (invalidate) {
            if (startOffset == -1 || endOffset == -1) {
                this.getSourceControl().sourceChanged(mimeChanged);
            } else {
                this.getSourceControl().regionChanged(startOffset, endOffset);
            }
        } else {
            this.getSourceControl().stateChanged();
        }
        this.getSourceControl().revalidate(EventSupport.getReparseDelay(fast));
    }

    private void assignDocumentListener(DataObject od) {
        EditorCookie.Observable ec = od.getCookie(EditorCookie.Observable.class);
        if (ec != null) {
            this.docListener = new DocListener(ec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachScheduler(SchedulerControl s, boolean attach) {
        SchedL l;
        Scheduler sched;
        Source now = this.getSourceControl().getSource();
        Map<Scheduler, SchedL> map = scheduledSources;
        synchronized (map) {
            sched = s.getScheduler();
            l = scheduledSources.get(sched);
            if (attach && l == null) {
                l = new SchedL(s);
                scheduledSources.put(sched, l);
            }
        }
        if (l != null) {
            l.attachSource(sched, now, attach);
        }
    }

    private static class SchedL
    implements PropertyChangeListener {
        final SchedulerControl control;
        Source source;
        PropertyChangeListener weakListener;
        Reference<DataObject> eventSource;

        public SchedL(SchedulerControl control) {
            this.control = control;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataObject dobj;
            Source newSource;
            if ("primaryFile".equals(evt.getPropertyName()) && (newSource = Source.create((dobj = (DataObject)evt.getSource()).getPrimaryFile())) != null) {
                LOGGER.log(Level.FINE, "Rescheduling {0} due to change of primary file.", dobj.getPrimaryFile());
                this.control.sourceChanged(newSource);
            }
        }

        public void attachSource(@NonNull Scheduler sched, @NonNull Source s, boolean attach) {
            assert (Thread.holdsLock(sched));
            if (this.source != null) {
                assert (attach || this.source == s) : String.format("attach: %b, source:%s(%d), s:%s(%d)", attach, this.source, System.identityHashCode(this.source), s, System.identityHashCode(s));
                if (this.weakListener != null) {
                    assert (this.eventSource != null);
                    DataObject dobj = this.eventSource.get();
                    if (dobj != null) {
                        dobj.removePropertyChangeListener(this.weakListener);
                    }
                }
                this.weakListener = null;
                this.eventSource = null;
                this.source = null;
            }
            if (attach) {
                FileObject fo = s.getFileObject();
                if (fo != null) {
                    try {
                        DataObject dobj = DataObject.find(fo);
                        this.eventSource = new WeakReference<DataObject>(dobj);
                        this.weakListener = WeakListeners.propertyChange(this, dobj);
                        dobj.addPropertyChangeListener(this.weakListener);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        // empty catch block
                    }
                }
                this.source = s;
            }
        }
    }

    public static class EditorRegistryListener
    implements CaretListener,
    PropertyChangeListener {
        private static final AtomicBoolean k24 = new AtomicBoolean();
        private Reference<JTextComponent> lastEditorRef;

        private EditorRegistryListener() {
            EditorRegistry.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    this.editorRegistryChanged();
                }
            });
            this.editorRegistryChanged();
        }

        private void editorRegistryChanged() {
            JTextComponent lastEditor;
            JTextComponent editor = EditorRegistry.lastFocusedComponent();
            JTextComponent jTextComponent = lastEditor = this.lastEditorRef == null ? null : this.lastEditorRef.get();
            if (lastEditor != editor && (editor == null || editor.getClientProperty("AsTextField") == null)) {
                JTextComponent focused;
                if (lastEditor != null) {
                    lastEditor.removeCaretListener(this);
                    lastEditor.removePropertyChangeListener(this);
                    k24.set(false);
                }
                this.lastEditorRef = new WeakReference<JTextComponent>(editor);
                if (editor != null) {
                    editor.addCaretListener(this);
                    editor.addPropertyChangeListener(this);
                }
                if ((focused = EditorRegistry.focusedComponent()) != null) {
                    Source source;
                    Document doc = editor.getDocument();
                    String mimeType = DocumentUtilities.getMimeType(doc);
                    if (doc != null && mimeType != null && (source = Source.create(doc)) != null) {
                        ((EventSupport)EventSupport.forSource(source)).resetState(true, false, -1, -1, true);
                    }
                }
            }
        }

        @Override
        public void caretUpdate(CaretEvent event) {
            JTextComponent lastEditor;
            JTextComponent jTextComponent = lastEditor = this.lastEditorRef == null ? null : this.lastEditorRef.get();
            if (lastEditor != null) {
                Source source;
                Document doc = lastEditor.getDocument();
                String mimeType = DocumentUtilities.getMimeType(doc);
                if (doc != null && mimeType != null && (source = Source.create(doc)) != null) {
                    ((EventSupport)EventSupport.forSource(source)).resetState(false, false, -1, -1, false);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("completion-active".equals(propName)) {
                String mimeType;
                Document doc;
                Source source = null;
                JTextComponent lastEditor = this.lastEditorRef == null ? null : this.lastEditorRef.get();
                Document document = doc = lastEditor == null ? null : lastEditor.getDocument();
                if (doc != null && (mimeType = DocumentUtilities.getMimeType(doc)) != null) {
                    source = Source.create(doc);
                }
                if (source != null) {
                    this.handleCompletionActive(source, evt.getNewValue());
                }
            }
        }

        private void handleCompletionActive(@NonNull Source source, @NullAllowed Object rawValue) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "completion-active={0} for {1}", new Object[]{rawValue, source});
            }
            if (rawValue instanceof Boolean && ((Boolean)rawValue).booleanValue()) {
                k24.set(true);
                TaskProcessorControl.suspendSchedulerTasks(source);
            } else {
                k24.set(false);
                EventSupport support = (EventSupport)EventSupport.forSource(source);
                support.getSourceControl().revalidate(0);
            }
        }
    }

    private final class DataObjectListener
    implements PropertyChangeListener {
        private DataObject dobj;
        private final FileObject fobj;
        private PropertyChangeListener wlistener;

        public DataObjectListener(DataObject dobj) {
            this.dobj = dobj;
            this.fobj = dobj.getPrimaryFile();
            this.wlistener = WeakListeners.propertyChange(this, dobj);
            this.dobj.addPropertyChangeListener(this.wlistener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            DataObject invalidDO = (DataObject)pce.getSource();
            if (invalidDO != this.dobj) {
                return;
            }
            String propName = pce.getPropertyName();
            if ("valid".equals(propName)) {
                this.handleInvalidDataObject(invalidDO);
            } else if (pce.getPropertyName() == null && !this.dobj.isValid()) {
                this.handleInvalidDataObject(invalidDO);
            }
        }

        private void handleInvalidDataObject(final DataObject invalidDO) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    DataObjectListener.this.handleInvalidDataObjectImpl(invalidDO);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleInvalidDataObjectImpl(DataObject invalidDO) {
            invalidDO.removePropertyChangeListener(this.wlistener);
            if (this.fobj.isValid()) {
                try {
                    DataObject dobjNew = DataObject.find(this.fobj);
                    DataObjectListener dataObjectListener = this;
                    synchronized (dataObjectListener) {
                        if (dobjNew == this.dobj) {
                            return;
                        }
                        this.dobj = dobjNew;
                        this.dobj.addPropertyChangeListener(this.wlistener);
                    }
                    EventSupport.this.assignDocumentListener(dobjNew);
                    EventSupport.this.resetState(true, false, -1, -1, false);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private class DocListener
    implements PropertyChangeListener,
    DocumentListener,
    TokenHierarchyListener {
        private final EditorCookie.Observable ec;
        private DocumentListener docListener;
        private TokenHierarchyListener thListener;

        public DocListener(EditorCookie.Observable ec) {
            assert (ec != null);
            this.ec = ec;
            this.ec.addPropertyChangeListener(WeakListeners.propertyChange(this, this.ec));
            Source source = EventSupport.this.getSourceControl().getSource();
            assert (source != null);
            Document doc = source.getDocument(false);
            if (doc != null) {
                this.assignDocumentListener(doc);
            }
        }

        public DocListener(Document doc) {
            assert (doc != null);
            this.ec = null;
            this.assignDocumentListener(doc);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("document".equals(evt.getPropertyName())) {
                Source source;
                Object old = evt.getOldValue();
                if (old instanceof Document && this.docListener != null) {
                    Document doc = (Document)old;
                    TokenHierarchy<Document> th = TokenHierarchy.get(doc);
                    th.removeTokenHierarchyListener(this.thListener);
                    doc.removeDocumentListener(this.docListener);
                    this.thListener = null;
                    this.docListener = null;
                }
                if ((source = EventSupport.this.getSourceControl().getSource()) == null) {
                    return;
                }
                Document doc = source.getDocument(false);
                if (doc != null) {
                    this.assignDocumentListener(doc);
                    EventSupport.this.resetState(true, false, -1, -1, false);
                }
            }
        }

        private void assignDocumentListener(Document doc) {
            TokenHierarchy<Document> th = TokenHierarchy.get(doc);
            this.thListener = WeakListeners.create(TokenHierarchyListener.class, this, th);
            th.addTokenHierarchyListener(this.thListener);
            this.docListener = WeakListeners.create(DocumentListener.class, this, doc);
            doc.addDocumentListener(this.docListener);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TokenHierarchy<Document> th = TokenHierarchy.get(e.getDocument());
            if (th.isActive()) {
                return;
            }
            EventSupport.this.resetState(true, false, e.getOffset(), e.getOffset() + e.getLength(), false);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TokenHierarchy<Document> th = TokenHierarchy.get(e.getDocument());
            if (th.isActive()) {
                return;
            }
            EventSupport.this.resetState(true, false, e.getOffset(), e.getOffset(), false);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
            EventSupport.this.resetState(true, false, evt.affectedStartOffset(), evt.affectedEndOffset(), false);
        }
    }
}

