/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import java.util.Collections;
import jpt.sun.source.tree.BinaryTree;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IfTree;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.ParenthesizedTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.UnaryTree;
import jpt.sun.source.util.SourcePositions;
import jpt.sun.source.util.TreePath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.suggestions.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;

public class Ifs {
    static final boolean SHOW_ELSE_MISSING_DEFAULT = true;
    static final String SHOW_ELSE_MISSING = "show.noelse";

    public static ErrorDescription computeWarning(HintContext ctx) {
        TreePath cond = ctx.getVariables().get("$cond");
        long conditionEnd = ctx.getInfo().getTrees().getSourcePositions().getEndPosition(cond.getCompilationUnit(), cond.getParentPath().getLeaf());
        if ((long)ctx.getCaretLocation() > conditionEnd) {
            return null;
        }
        TreePath ifPath = cond.getParentPath().getParentPath();
        if (ifPath.getLeaf().getKind() != Tree.Kind.IF) {
            return null;
        }
        IfTree iv = (IfTree)ifPath.getLeaf();
        if (iv.getElseStatement() == null && !ctx.getPreferences().getBoolean(SHOW_ELSE_MISSING, true)) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_InvertIf(), new FixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix());
    }

    public static ErrorDescription joinElseIf(HintContext ctx) {
        IfTree it = (IfTree)ctx.getPath().getLeaf();
        if (it.getElseStatement().getKind() != Tree.Kind.BLOCK) {
            return null;
        }
        if (!Ifs.caretInsideToLevelElseKeyword(ctx)) {
            return null;
        }
        return ErrorDescriptionFactory.forSpan(ctx, ctx.getCaretLocation(), ctx.getCaretLocation(), Bundle.ERR_JoinElseIf(), new JoinIfFix(ctx.getInfo(), ctx.getPath()).toEditorFix());
    }

    public static ErrorDescription toOrIf(HintContext ctx) {
        boolean caretAccepted;
        SourcePositions sp = ctx.getInfo().getTrees().getSourcePositions();
        CompilationUnitTree cut = ctx.getInfo().getCompilationUnit();
        boolean bl = caretAccepted = (long)ctx.getCaretLocation() <= sp.getStartPosition(cut, ctx.getPath().getLeaf()) + 2L || Ifs.caretInsideToLevelElseKeyword(ctx);
        if (!caretAccepted) {
            return null;
        }
        return ErrorDescriptionFactory.forSpan(ctx, ctx.getCaretLocation(), ctx.getCaretLocation(), Bundle.ERR_ToOrIf(), JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_ToOrIf(), ctx.getPath(), "if ($cond1 || $cond2) $then; else $else$;"));
    }

    public static ErrorDescription splitIfCondition(HintContext ctx) {
        CompilationUnitTree cut;
        SourcePositions sp = ctx.getInfo().getTrees().getSourcePositions();
        if (!Ifs.caretInsidePreviousToken(ctx, sp.getStartPosition(cut = ctx.getInfo().getCompilationUnit(), ctx.getVariables().get("$cond2").getLeaf()), JavaTokenId.BARBAR)) {
            return null;
        }
        String target = "if ($cond1) $then; else if ($cond2) $then; else $else$;";
        return ErrorDescriptionFactory.forSpan(ctx, ctx.getCaretLocation(), ctx.getCaretLocation(), Bundle.ERR_splitIfCondition(), JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_splitIfCondition(), ctx.getPath(), target));
    }

    private static boolean caretInsideToLevelElseKeyword(HintContext ctx) {
        IfTree it = (IfTree)ctx.getPath().getLeaf();
        SourcePositions sp = ctx.getInfo().getTrees().getSourcePositions();
        CompilationUnitTree cut = ctx.getInfo().getCompilationUnit();
        int elsePos = (int)sp.getStartPosition(cut, it.getElseStatement());
        return Ifs.caretInsidePreviousToken(ctx, elsePos, JavaTokenId.ELSE);
    }

    private static boolean caretInsidePreviousToken(HintContext ctx, long startAt, JavaTokenId lookFor) {
        if (startAt < 0L) {
            return false;
        }
        TokenSequence<JavaTokenId> ts = ctx.getInfo().getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move((int)startAt);
        while (ts.movePrevious()) {
            if (ts.token().id() != lookFor) continue;
            int start = ts.offset();
            int end = ts.offset() + ts.token().length();
            return ctx.getCaretLocation() >= start && ctx.getCaretLocation() <= end;
        }
        return false;
    }

    public static ErrorDescription mergeIfs(HintContext ctx) {
        int caret = ctx.getCaretLocation();
        IfTree st = (IfTree)ctx.getPath().getLeaf();
        int conditionEnd = (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getPath().getCompilationUnit(), st.getCondition());
        if (caret > conditionEnd) {
            return null;
        }
        Fix f = JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_org_netbeans_modules_java_hints_suggestions_Tiny_mergeIfs(), ctx.getPath(), "if ($firstCondition && $secondCondition) $body;");
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_org_netbeans_modules_java_hints_suggestions_Tiny_mergeIfs(), f);
    }

    public static ErrorDescription extractIf(HintContext ctx) {
        int caret = ctx.getCaretLocation();
        boolean braces = CodeStyle.getDefault(ctx.getInfo().getFileObject()).redundantIfBraces() != CodeStyle.BracesGenerationStyle.ELIMINATE;
        TreePath toSplit = null;
        TreePath left = ctx.getVariables().get("$firstCondition");
        long leftStart = ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getPath().getCompilationUnit(), left.getLeaf());
        long leftEnd = ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getPath().getCompilationUnit(), left.getLeaf());
        if (leftStart <= (long)caret && (long)caret <= leftEnd) {
            toSplit = left;
        }
        TreePath right = ctx.getVariables().get("$secondCondition");
        if (toSplit == null) {
            long rightStart = ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getPath().getCompilationUnit(), right.getLeaf());
            long rightEnd = ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getPath().getCompilationUnit(), right.getLeaf());
            if (rightStart > (long)caret || (long)caret > rightEnd) {
                return null;
            }
        }
        ctx.getVariables().put("$firstCondition", Ifs.unwrapParenthesized(left));
        ctx.getVariables().put("$secondCondition", Ifs.unwrapParenthesized(right));
        String targetPattern = braces ? "if ($firstCondition) { if ($secondCondition) $body; }" : "if ($firstCondition) if ($secondCondition) $body;";
        Fix f = JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_org_netbeans_modules_java_hints_suggestions_Tiny_extractIf(), ctx.getPath(), targetPattern);
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_org_netbeans_modules_java_hints_suggestions_Tiny_extractIf(), f);
    }

    private static TreePath unwrapParenthesized(TreePath x) {
        while (x.getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
            x = new TreePath(x, ((ParenthesizedTree)x.getLeaf()).getExpression());
        }
        return x;
    }

    private static class JoinIfFix
    extends JavaFix {
        public JoinIfFix(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        @Override
        protected String getText() {
            return Bundle.FIX_JoinElseIf();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            IfTree it = (IfTree)ctx.getPath().getLeaf();
            ctx.getWorkingCopy().rewrite(it.getElseStatement(), ((BlockTree)it.getElseStatement()).getStatements().get(0));
        }
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        @Override
        protected String getText() {
            return Bundle.FIX_InvertIf();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            IfTree toRewrite = (IfTree)ctx.getPath().getLeaf();
            StatementTree elseStatement = toRewrite.getElseStatement();
            if (toRewrite.getCondition() == null || toRewrite.getCondition().getKind() != Tree.Kind.PARENTHESIZED) {
                return;
            }
            ParenthesizedTree ptt = (ParenthesizedTree)toRewrite.getCondition();
            if (ptt.getExpression() == null) {
                return;
            }
            if (elseStatement == null) {
                elseStatement = ctx.getWorkingCopy().getTreeMaker().Block(Collections.emptyList(), false);
            }
            ctx.getWorkingCopy().rewrite(toRewrite, ctx.getWorkingCopy().getTreeMaker().If(toRewrite.getCondition(), elseStatement, toRewrite.getThenStatement()));
            ExpressionTree negated = Utilities.negate(ctx.getWorkingCopy().getTreeMaker(), ptt.getExpression(), ptt);
            ctx.getWorkingCopy().rewrite(ptt.getExpression(), negated);
        }

        private void negate(WorkingCopy copy, ExpressionTree original, Tree parent) {
            ExpressionTree newTree;
            TreeMaker make = copy.getTreeMaker();
            switch (original.getKind()) {
                case PARENTHESIZED: {
                    ExpressionTree expr = ((ParenthesizedTree)original).getExpression();
                    this.negate(copy, expr, original);
                    return;
                }
                case LOGICAL_COMPLEMENT: {
                    newTree = ((UnaryTree)original).getExpression();
                    while (newTree.getKind() == Tree.Kind.PARENTHESIZED && !JavaFixUtilities.requiresParenthesis(((ParenthesizedTree)newTree).getExpression(), original, parent)) {
                        newTree = ((ParenthesizedTree)newTree).getExpression();
                    }
                    break;
                }
                case NOT_EQUAL_TO: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.EQUAL_TO, false);
                    break;
                }
                case EQUAL_TO: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.NOT_EQUAL_TO, false);
                    break;
                }
                case BOOLEAN_LITERAL: {
                    newTree = make.Literal((Boolean)((LiteralTree)original).getValue() == false);
                    break;
                }
                case CONDITIONAL_AND: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.CONDITIONAL_OR, true);
                    break;
                }
                case CONDITIONAL_OR: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.CONDITIONAL_AND, true);
                    break;
                }
                case LESS_THAN: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.GREATER_THAN_EQUAL, false);
                    break;
                }
                case LESS_THAN_EQUAL: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.GREATER_THAN, false);
                    break;
                }
                case GREATER_THAN: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.LESS_THAN_EQUAL, false);
                    break;
                }
                case GREATER_THAN_EQUAL: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.LESS_THAN, false);
                    break;
                }
                default: {
                    newTree = make.Unary(Tree.Kind.LOGICAL_COMPLEMENT, original);
                    if (!JavaFixUtilities.requiresParenthesis(original, original, newTree)) break;
                    newTree = make.Unary(Tree.Kind.LOGICAL_COMPLEMENT, make.Parenthesized(original));
                }
            }
            if (JavaFixUtilities.requiresParenthesis(newTree, original, parent)) {
                newTree = make.Parenthesized(newTree);
            }
            copy.rewrite(original, newTree);
        }

        private ExpressionTree negateBinaryOperator(WorkingCopy copy, Tree original, Tree.Kind newKind, boolean negateOperands) {
            BinaryTree bt = (BinaryTree)original;
            if (negateOperands) {
                this.negate(copy, bt.getLeftOperand(), original);
                this.negate(copy, bt.getRightOperand(), original);
            }
            return copy.getTreeMaker().Binary(newKind, bt.getLeftOperand(), bt.getRightOperand());
        }
    }
}

