/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jackpot30.cmdline;

import io.reflectoring.diffparser.api.UnifiedDiffParser;
import io.reflectoring.diffparser.api.model.Diff;
import io.reflectoring.diffparser.api.model.Hunk;
import io.reflectoring.diffparser.api.model.Line;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.netbeans.api.actions.Savable;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.editor.tools.storage.api.ToolPreferences;
import org.netbeans.modules.jackpot30.cmdline.lib.Utils;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintRegistry;
import org.netbeans.modules.java.hints.declarative.test.TestParser;
import org.netbeans.modules.java.hints.declarative.test.TestPerformer;
import org.netbeans.modules.java.hints.jackpot.spi.PatternConvertor;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintDescriptionFactory;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.RulesManager;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchSearch;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchUtilities;
import org.netbeans.modules.java.hints.spiimpl.batch.ProgressHandleWrapper;
import org.netbeans.modules.java.hints.spiimpl.batch.Scopes;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.hints.Hint;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class Main {
    private static final String OPTION_APPLY = "apply";
    private static final String OPTION_NO_APPLY = "no-apply";
    private static final String OPTION_FAIL_ON_WARNINGS = "fail-on-warnings";
    private static final String RUN_TESTS = "run-tests";
    private static final String SOURCE_LEVEL_DEFAULT = "1.8";
    private static final String ACCEPTABLE_SOURCE_LEVEL_PATTERN = "(1\\.)?[1-9][0-9]*";
    private static final Logger TOP_LOGGER = Logger.getLogger("");
    private static final ThreadLocal<RootConfiguration> currentRootConfiguration = new ThreadLocal();

    public static void main(String ... args) throws IOException, ClassNotFoundException {
        System.exit(Main.compile(args));
    }

    /*
     * WARNING - void declaration
     */
    public static int compile(String ... args) throws IOException, ClassNotFoundException {
        void var15_22;
        FileObject cacheDirFO2;
        boolean deleteCacheDir;
        ArrayList<RootConfiguration> groups;
        OptionSet parsed;
        ArgumentAcceptingOptionSpec<File> patchFile;
        ArgumentAcceptingOptionSpec<File> hintFile;
        ArgumentAcceptingOptionSpec<String> config;
        ArgumentAcceptingOptionSpec<String> hint;
        ArgumentAcceptingOptionSpec<File> configFile;
        ArgumentAcceptingOptionSpec<File> out;
        block56: {
            try {
                Class.forName("jpt30.lang.model.element.ModuleElement");
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Error: no suitable javac found, please run on JDK 11+.");
                return 1;
            }
            System.setProperty("netbeans.user", "/tmp/tmp-foo");
            System.setProperty("SourcePath.no.source.filter", "true");
            OptionParser parser = new OptionParser();
            GroupOptions globalGroupOptions = Main.setupGroupParser(parser);
            ArgumentAcceptingOptionSpec<File> cache = parser.accepts("cache", "a cache directory to store working data").withRequiredArg().ofType(File.class);
            out = parser.accepts("out", "output diff").withRequiredArg().ofType(File.class);
            configFile = parser.accepts("config-file", "configuration file").withRequiredArg().ofType(File.class);
            hint = parser.accepts("hint", "hint name").withRequiredArg().ofType(String.class);
            config = parser.accepts("config", "configurations").withRequiredArg().ofType(String.class);
            hintFile = parser.accepts("hint-file", "file with rules that should be performed").withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec<String> group = parser.accepts("group", "specify roots to process alongside with their classpath").withRequiredArg().ofType(String.class);
            patchFile = parser.accepts("filter-patch", "patch file, which will be used to filter the output").withRequiredArg().ofType(File.class);
            parser.accepts("list", "list all known hints");
            parser.accepts("progress", "show progress");
            parser.accepts("debug", "enable debugging loggers");
            parser.accepts("help", "prints this help");
            parser.accepts(OPTION_NO_APPLY, "do not apply changes - only print locations were the hint would be applied");
            parser.accepts(OPTION_APPLY, "apply changes");
            parser.accepts(OPTION_FAIL_ON_WARNINGS, "fail when warnings are detected");
            parser.accepts(RUN_TESTS, "run tests for declarative rules that were used");
            try {
                parsed = parser.parse(Main.inlineParameterFiles(args));
            }
            catch (OptionException ex) {
                System.err.println(ex.getLocalizedMessage());
                parser.printHelpOn(System.out);
                return 1;
            }
            if (!parsed.has("debug")) {
                Main.prepareLoggers();
            }
            if (parsed.has("help")) {
                parser.printHelpOn(System.out);
                return 0;
            }
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            ArrayList<BatchSearch.Folder> rootFolders = new ArrayList<BatchSearch.Folder>();
            for (String string : parsed.nonOptionArguments()) {
                File r = new File(string);
                FileObject root = FileUtil.toFileObject(r);
                if (root == null) continue;
                roots.add(root);
                rootFolders.add(new BatchSearch.Folder(root));
            }
            groups = new ArrayList<RootConfiguration>();
            groups.add(new RootConfiguration(parsed, globalGroupOptions));
            for (String groupValue : parsed.valuesOf(group)) {
                OptionParser groupParser = new OptionParser();
                GroupOptions groupOptions = Main.setupGroupParser(groupParser);
                OptionSet parsedGroup = groupParser.parse(Main.splitGroupArg(groupValue));
                groups.add(new RootConfiguration(parsedGroup, groupOptions));
            }
            if (parsed.has("show-gui")) {
                if (parsed.has(configFile)) {
                    final File file = parsed.valueOf(configFile);
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Pair sourceAndBinaryCP = Main.jointSourceAndBinaryCP(groups);
                                    Main.showGUICustomizer(file, (ClassPath)sourceAndBinaryCP.second(), (ClassPath)sourceAndBinaryCP.first());
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace(ex);
                                }
                                catch (BackingStoreException ex) {
                                    Exceptions.printStackTrace(ex);
                                }
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace(ex);
                    }
                    catch (InvocationTargetException ex) {
                        Exceptions.printStackTrace(ex);
                    }
                    return 0;
                }
                System.err.println("show-gui requires config-file");
                return 1;
            }
            File file = parsed.valueOf(cache);
            deleteCacheDir = false;
            if (file != null) break block56;
            File file2 = File.createTempFile("jackpot", "cache");
            file2.delete();
            deleteCacheDir = file2.mkdirs();
            if (deleteCacheDir) break block56;
            System.err.println("cannot create temporary cache");
            int groupParser = 1;
            if (deleteCacheDir && (cacheDirFO2 = FileUtil.toFileObject(file2)) != null) {
                cacheDirFO2.delete();
            }
            return groupParser;
        }
        try {
            boolean useDefaultEnabledSetting;
            boolean runDeclarativeTests;
            boolean runDeclarative;
            boolean apply;
            Preferences hintSettingsPreferences;
            ProgressHandleWrapper progress;
            if (var15_22.isFile()) {
                System.err.println("cache directory exists and is a file");
                int groupParser = 1;
                return groupParser;
            }
            String[] cacheDirContent = var15_22.list();
            if (cacheDirContent != null && cacheDirContent.length > 0 && !new File((File)var15_22, "segments").exists()) {
                System.err.println("cache directory is not empty, but was not created by this tool");
                int cacheDirFO2 = 1;
                return cacheDirFO2;
            }
            var15_22.mkdirs();
            CacheFolder.setCacheFolder(FileUtil.toFileObject(FileUtil.normalizeFile((File)var15_22)));
            OpenProjects.getDefault().getOpenProjects();
            RepositoryUpdater.getDefault().start(false);
            if (parsed.has("list")) {
                Pair<ClassPath, ClassPath> sourceAndBinaryCP = Main.jointSourceAndBinaryCP(groups);
                Main.printHints(sourceAndBinaryCP.first(), sourceAndBinaryCP.second());
                int cacheDirFO3 = 0;
                return cacheDirFO3;
            }
            int totalGroups = 0;
            for (RootConfiguration groupConfig : groups) {
                if (groupConfig.rootFolders.isEmpty()) continue;
                ++totalGroups;
            }
            ProgressHandleWrapper progressHandleWrapper = progress = parsed.has("progress") ? new ProgressHandleWrapper(new ConsoleProgressHandleAbstraction(), ProgressHandleWrapper.prepareParts(totalGroups)) : new ProgressHandleWrapper(1);
            if (parsed.has(configFile)) {
                ToolPreferences toolPrefs = ToolPreferences.from(parsed.valueOf(configFile).toURI());
                hintSettingsPreferences = toolPrefs.getPreferences("hints", "text/x-java");
                Preferences toolSettings = toolPrefs.getPreferences("standalone", "text/x-java");
                apply = toolSettings.getBoolean(OPTION_APPLY, false);
                runDeclarative = toolSettings.getBoolean("runDeclarative", true);
                runDeclarativeTests = toolSettings.getBoolean("runDeclarativeTests", false);
                useDefaultEnabledSetting = true;
                if (parsed.has(hint)) {
                    System.err.println("cannot specify --hint and --config-file together");
                    int n = 1;
                    return n;
                }
                if (parsed.has(hintFile)) {
                    System.err.println("cannot specify --hint-file and --config-file together");
                    int n = 1;
                    return n;
                }
            } else {
                hintSettingsPreferences = null;
                apply = false;
                runDeclarative = true;
                runDeclarativeTests = parsed.has(RUN_TESTS);
                useDefaultEnabledSetting = false;
            }
            if (parsed.has(config) && !parsed.has(hint)) {
                System.err.println("--config cannot specified when no hint is specified");
                int toolPrefs = 1;
                return toolPrefs;
            }
            if (parsed.has(OPTION_NO_APPLY)) {
                apply = false;
            } else if (parsed.has(OPTION_APPLY)) {
                apply = true;
            }
            GroupResult result = GroupResult.NOTHING_TO_DO;
            try (BufferedWriter outS = parsed.has(out) ? new BufferedWriter(new OutputStreamWriter(new FileOutputStream(parsed.valueOf(out)))) : null;){
                GlobalConfiguration globalConfig = new GlobalConfiguration(hintSettingsPreferences, apply, runDeclarative, runDeclarativeTests, useDefaultEnabledSetting, parsed.valueOf(hint), parsed.valueOf(hintFile), parsed.valueOf(patchFile), outS, parsed.has(OPTION_FAIL_ON_WARNINGS));
                for (RootConfiguration groupConfig : groups) {
                    result = result.join(Main.handleGroup(groupConfig, progress, globalConfig, parsed.valuesOf(config)));
                }
            }
            progress.finish();
            if (result == GroupResult.NOTHING_TO_DO) {
                System.err.println("no source roots to work on");
                int n = 1;
                return n;
            }
            if (result == GroupResult.NO_HINTS_FOUND) {
                System.err.println("no hints specified");
                int n = 1;
                return n;
            }
            int n = result == GroupResult.SUCCESS ? 0 : 1;
            return n;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (deleteCacheDir && (cacheDirFO2 = FileUtil.toFileObject((File)var15_22)) != null) {
                cacheDirFO2.delete();
            }
        }
    }

    private static String[] inlineParameterFiles(String ... args) {
        ArrayList<String> inlinedArgs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("@")) {
                try (BufferedReader r = new BufferedReader(new FileReader(arg.substring(1)));){
                    String line;
                    while ((line = r.readLine()) != null) {
                        inlinedArgs.add(line);
                    }
                    continue;
                }
                catch (IOException ex) {
                    throw new OptionException((Collection)Collections.emptySet(), (Throwable)ex){};
                }
            }
            inlinedArgs.add(arg);
        }
        return inlinedArgs.toArray(new String[0]);
    }

    private static Pair<ClassPath, ClassPath> jointSourceAndBinaryCP(List<RootConfiguration> groups) {
        HashSet<FileObject> sourceRoots = new HashSet<FileObject>();
        HashSet<FileObject> binaryRoots = new HashSet<FileObject>();
        for (RootConfiguration groupConfig : groups) {
            sourceRoots.addAll(Arrays.asList(groupConfig.sourceCP.getRoots()));
            binaryRoots.addAll(Arrays.asList(groupConfig.binaryCP.getRoots()));
        }
        return Pair.of(ClassPathSupport.createClassPath(sourceRoots.toArray(new FileObject[0])), ClassPathSupport.createClassPath(binaryRoots.toArray(new FileObject[0])));
    }

    private static GroupOptions setupGroupParser(OptionParser parser) {
        return new GroupOptions(parser.accepts("classpath", "classpath").withRequiredArg().withValuesSeparatedBy(File.pathSeparatorChar).ofType(File.class), parser.accepts("bootclasspath", "bootclasspath").withRequiredArg().withValuesSeparatedBy(File.pathSeparatorChar).ofType(File.class), parser.accepts("sourcepath", "sourcepath").withRequiredArg().withValuesSeparatedBy(File.pathSeparatorChar).ofType(File.class), parser.accepts("source", "source level").withRequiredArg().ofType(String.class).defaultsTo(SOURCE_LEVEL_DEFAULT, (String[])new String[0]));
    }

    private static Map<HintMetadata, Collection<? extends HintDescription>> listHints(ClassPath sourceFrom, ClassPath binaryFrom) {
        HashMap<HintMetadata, Collection<? extends HintDescription>> result = new HashMap<HintMetadata, Collection<? extends HintDescription>>();
        for (Map.Entry<HintMetadata, ? extends Collection<? extends HintDescription>> entry : RulesManager.getInstance().readHints(null, Arrays.asList(sourceFrom, binaryFrom), null).entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static GroupResult handleGroup(RootConfiguration rootConfiguration, ProgressHandleWrapper w, GlobalConfiguration globalConfig, List<String> config) throws IOException {
        Iterable<? extends HintDescription> hints;
        if (rootConfiguration.rootFolders.isEmpty()) {
            return GroupResult.NOTHING_TO_DO;
        }
        WarningsAndErrors wae = new WarningsAndErrors();
        ProgressHandleWrapper progress = w.startNextPartWithEmbedding(1);
        Preferences settings = globalConfig.configurationPreferences != null ? globalConfig.configurationPreferences : new MemoryPreferences();
        HintsSettings hintSettings = HintsSettings.createPreferencesBasedHintsSettings(settings, globalConfig.useDefaultEnabledSetting, null);
        if (globalConfig.hint != null) {
            hints = Main.findHints(rootConfiguration.sourceCP, rootConfiguration.binaryCP, globalConfig.hint, hintSettings);
        } else if (globalConfig.hintFile != null) {
            FileObject hintFileFO = FileUtil.toFileObject(globalConfig.hintFile);
            assert (hintFileFO != null);
            hints = PatternConvertor.create(hintFileFO.asText());
            for (HintDescription hintDescription : hints) {
                hintSettings.setEnabled(hintDescription.getMetadata(), true);
            }
        } else {
            hints = Main.readHints(rootConfiguration.sourceCP, rootConfiguration.binaryCP, hintSettings, settings, globalConfig.runDeclarative);
            if (globalConfig.runDeclarativeTests) {
                HashSet<String> enabledHints = new HashSet<String>();
                for (HintDescription hintDescription : hints) {
                    enabledHints.add(hintDescription.getMetadata().id);
                }
                ClassPath combined = ClassPathSupport.createProxyClassPath(rootConfiguration.sourceCP, rootConfiguration.binaryCP);
                HashMap<FileObject, FileObject> hashMap = new HashMap<FileObject, FileObject>();
                for (FileObject fileObject : combined.findAllResources("META-INF/upgrade")) {
                    block13: for (FileObject c : fileObject.getChildren()) {
                        if (!c.getExt().equals("test")) continue;
                        FileObject hintFile = FileUtil.findBrother(c, "hint");
                        for (HintMetadata hm : DeclarativeHintRegistry.parseHintFile(hintFile).keySet()) {
                            if (!enabledHints.contains(hm.id)) continue;
                            hashMap.put(c, hintFile);
                            continue block13;
                        }
                    }
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    TestParser.TestCase[] testCases = TestParser.parse(((FileObject)entry.getKey()).asText());
                    try {
                        Map<TestParser.TestCase, Collection<String>> testResult = TestPerformer.performTest((FileObject)entry.getValue(), (FileObject)entry.getKey(), testCases, new AtomicBoolean());
                        for (TestParser.TestCase tc : testCases) {
                            ArrayList<String> actual;
                            List<String> expected = Arrays.asList(tc.getResults());
                            if (expected.equals(actual = new ArrayList<String>(testResult.get(tc)))) continue;
                            int pos = tc.getTestCaseStart();
                            String id = "test-failure";
                            ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription(id, Severity.ERROR, "Actual results did not match the expected test results. Actual results: " + expected, null, ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList()), (FileObject)entry.getKey(), pos, pos);
                            Main.print(ed, wae, Collections.singletonMap(id, id));
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        if (config != null && !config.isEmpty()) {
            Iterator<? extends HintDescription> hit = hints.iterator();
            HintDescription hd = hit.next();
            if (hit.hasNext()) {
                System.err.println("--config cannot specified when more than one hint is specified");
                return GroupResult.FAILURE;
            }
            Preferences preferences = hintSettings.getHintPreferences(hd.getMetadata());
            boolean stop = false;
            for (String c : config) {
                int assign = c.indexOf(61);
                if (assign == -1) {
                    System.err.println("configuration option is missing '=' (" + c + ")");
                    stop = true;
                    continue;
                }
                preferences.put(c.substring(0, assign), c.substring(assign + 1));
            }
            if (stop) {
                return GroupResult.FAILURE;
            }
        }
        String sourceLevel = rootConfiguration.sourceLevel;
        if (!Pattern.compile(ACCEPTABLE_SOURCE_LEVEL_PATTERN).matcher(sourceLevel).matches()) {
            System.err.println("unrecognized source level specification: " + sourceLevel);
            return GroupResult.FAILURE;
        }
        if (globalConfig.apply && !hints.iterator().hasNext()) {
            return GroupResult.NO_HINTS_FOUND;
        }
        RootConfiguration prevConfig = currentRootConfiguration.get();
        if (globalConfig.patchFile != null) {
            PatchDescription patchDescription = Main.createPatchDescription(rootConfiguration, globalConfig.patchFile);
            if (patchDescription.file2AddedLines.isEmpty()) {
                return GroupResult.SUCCESS;
            }
            hints = Main.filterHints(hints, patchDescription);
        } else {
            Object var11_18 = null;
        }
        try {
            BatchSearch.BatchResult occurrences;
            ProgressHandleWrapper nestedProgress;
            block35: {
                currentRootConfiguration.set(rootConfiguration);
                try {
                    void var11_19;
                    nestedProgress = progress.startNextPartWithEmbedding(1, 1);
                    BatchSearch.Scope scope = Scopes.specifiedFoldersScope(rootConfiguration.rootFolders.toArray(new BatchSearch.Folder[0]));
                    occurrences = BatchSearch.findOccurrences(hints, scope, nestedProgress, hintSettings);
                    occurrences = Main.filterBatchResult(occurrences, (PatchDescription)var11_19);
                    if (!globalConfig.apply) break block35;
                    Main.apply(nestedProgress, occurrences, globalConfig.out);
                    GroupResult groupResult = GroupResult.SUCCESS;
                    return groupResult;
                }
                catch (IOException t) {
                    throw new UncheckedIOException(t);
                }
            }
            Main.findOccurrences(nestedProgress, occurrences, hints, wae);
            if (wae.errors != 0 || wae.warnings != 0 && globalConfig.failOnWarnings) {
                GroupResult groupResult = GroupResult.FAILURE;
                return groupResult;
            }
            GroupResult groupResult = GroupResult.SUCCESS;
            return groupResult;
        }
        finally {
            currentRootConfiguration.set(prevConfig);
        }
    }

    private static PatchDescription createPatchDescription(RootConfiguration rootConfiguration, File patchFile) throws IOException {
        HashMap file2AddedLines = new HashMap();
        UnifiedDiffParser p = new UnifiedDiffParser();
        List<Diff> diffs = p.parse(patchFile);
        for (Diff diff : diffs) {
            String fileName = diff.getToFileName();
            FileObject resolvedTarget = null;
            block6: while (!fileName.isEmpty()) {
                for (BatchSearch.Folder f : rootConfiguration.rootFolders) {
                    resolvedTarget = f.getFileObject().getFileObject(fileName);
                    if (resolvedTarget == null) continue;
                    break block6;
                }
                int slash = fileName.indexOf("/");
                if (slash == -1) break;
                fileName = fileName.substring(slash + 1);
            }
            if (resolvedTarget == null) continue;
            HashSet<Integer> includedLines = new HashSet<Integer>();
            for (Hunk hunk : diff.getHunks()) {
                int newLine = hunk.getToFileRange().getLineStart();
                for (Line l : hunk.getLines()) {
                    switch (l.getLineType()) {
                        case FROM: {
                            break;
                        }
                        case NEUTRAL: {
                            ++newLine;
                            break;
                        }
                        case TO: {
                            includedLines.add(newLine);
                            ++newLine;
                        }
                    }
                }
            }
            file2AddedLines.put(resolvedTarget, includedLines);
        }
        return new PatchDescription(file2AddedLines);
    }

    private static Iterable<? extends HintDescription> filterHints(Iterable<? extends HintDescription> hints, PatchDescription patch) {
        return StreamSupport.stream(hints.spliterator(), false).map(hd -> {
            class FilteringWorker
            implements HintDescription.Worker {
                private final PatchDescription patch;
                private final HintDescription.Worker delegate;

                public FilteringWorker(PatchDescription patch, HintDescription.Worker delegate) {
                    this.patch = patch;
                    this.delegate = delegate;
                }

                @Override
                public Collection<? extends ErrorDescription> createErrors(HintContext ctx) {
                    Collection<? extends ErrorDescription> errors = this.delegate.createErrors(ctx);
                    return errors != null ? (Collection)errors.stream().filter(ed -> this.patch.included((ErrorDescription)ed)).collect(Collectors.toList()) : null;
                }
            }
            return HintDescriptionFactory.create().setHintText(hd.getHintText()).setMetadata(hd.getMetadata()).setTrigger(hd.getTrigger()).setAdditionalConstraints(hd.getAdditionalConstraints()).setWorker(new FilteringWorker(patch, hd.getWorker())).produce();
        }).collect(Collectors.toList());
    }

    private static BatchSearch.BatchResult filterBatchResult(BatchSearch.BatchResult result, PatchDescription patch) {
        try {
            if (patch == null) {
                return result;
            }
            Field f = result.getClass().getDeclaredField("projectId2Resources");
            Map projectId2Resources = (Map)f.get(result);
            HashMap filteredProjectId2Resources = new HashMap();
            for (Map.Entry e : projectId2Resources.entrySet()) {
                filteredProjectId2Resources.put(e.getKey(), ((Collection)e.getValue()).stream().filter(r -> patch.included(r.getResolvedFile())).collect(Collectors.toList()));
            }
            return new BatchSearch.BatchResult(projectId2Resources, result.problems);
        }
        catch (ReflectiveOperationException ex) {
            Exceptions.printStackTrace(ex);
            return result;
        }
    }

    private static Iterable<? extends HintDescription> findHints(ClassPath sourceFrom, ClassPath binaryFrom, String name, HintsSettings toEnableIn) {
        LinkedList<? extends HintDescription> descs = new LinkedList<HintDescription>();
        for (Map.Entry<HintMetadata, Collection<? extends HintDescription>> e : Main.listHints(sourceFrom, binaryFrom).entrySet()) {
            if (!e.getKey().displayName.equals(name)) continue;
            descs.addAll(e.getValue());
            toEnableIn.setEnabled(e.getKey(), true);
        }
        return descs;
    }

    private static Iterable<? extends HintDescription> allHints(ClassPath sourceFrom, ClassPath binaryFrom, HintsSettings toEnableIn) {
        LinkedList<? extends HintDescription> descs = new LinkedList<HintDescription>();
        for (Map.Entry<HintMetadata, Collection<? extends HintDescription>> e : Main.listHints(sourceFrom, binaryFrom).entrySet()) {
            if (e.getKey().kind != Hint.Kind.INSPECTION || !e.getKey().enabled) continue;
            descs.addAll(e.getValue());
            toEnableIn.setEnabled(e.getKey(), true);
        }
        return descs;
    }

    private static Iterable<? extends HintDescription> readHints(ClassPath sourceFrom, ClassPath binaryFrom, HintsSettings toEnableIn, Preferences toEnableInPreferencesHack, boolean declarativeEnabledByDefault) {
        Map<HintMetadata, ? extends Collection<? extends HintDescription>> hardcoded = RulesManager.getInstance().readHints(null, Arrays.asList(new ClassPath[0]), null);
        Map<HintMetadata, ? extends Collection<? extends HintDescription>> all = RulesManager.getInstance().readHints(null, Arrays.asList(sourceFrom, binaryFrom), null);
        LinkedList<HintDescription> descs = new LinkedList<HintDescription>();
        for (Map.Entry<HintMetadata, ? extends Collection<? extends HintDescription>> entry : all.entrySet()) {
            if (hardcoded.containsKey(entry.getKey())) {
                if (!toEnableIn.isEnabled(entry.getKey()) || entry.getKey().kind != Hint.Kind.INSPECTION || entry.getKey().options.contains((Object)HintMetadata.Options.NO_BATCH)) continue;
                descs.addAll(entry.getValue());
                continue;
            }
            if (!toEnableInPreferencesHack.node(entry.getKey().id).getBoolean("enabled", declarativeEnabledByDefault)) continue;
            descs.addAll(entry.getValue());
        }
        return descs;
    }

    private static void prepareLoggers() {
        TOP_LOGGER.setLevel(Level.OFF);
        System.setProperty("RepositoryUpdate.increasedLogLevel", "OFF");
    }

    private static void findOccurrences(ProgressHandleWrapper progress, BatchSearch.BatchResult rawOccurrences, Iterable<? extends HintDescription> descs, final WarningsAndErrors wae) throws IOException {
        final Map<String, String> id2DisplayName = Utils.computeId2DisplayName(descs);
        LinkedList problems = new LinkedList();
        BatchSearch.getVerifiedSpans(rawOccurrences, progress, new BatchSearch.VerifiedSpansCallBack(){

            @Override
            public void groupStarted() {
            }

            @Override
            public boolean spansVerified(CompilationController wc, BatchSearch.Resource r, Collection<? extends ErrorDescription> hints) throws Exception {
                hints = hints.stream().sorted((ed1, ed2) -> ed1.getRange().getBegin().getOffset() - ed2.getRange().getBegin().getOffset()).collect(Collectors.toList());
                for (ErrorDescription ed : hints) {
                    Main.print(ed, wae, id2DisplayName);
                }
                return true;
            }

            @Override
            public void groupFinished() {
            }

            @Override
            public void cannotVerifySpan(BatchSearch.Resource r) {
            }
        }, true, problems, new AtomicBoolean());
    }

    private static void print(ErrorDescription error, WarningsAndErrors wae, Map<String, String> id2DisplayName) throws IOException {
        String severity;
        int lineNumber = error.getRange().getBegin().getLine();
        String line = error.getFile().asLines().get(lineNumber);
        int column = error.getRange().getBegin().getColumn();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < column; ++i) {
            if (Character.isWhitespace(line.charAt(i))) {
                b.append(line.charAt(i));
                continue;
            }
            b.append(' ');
        }
        b.append('^');
        String idDisplayName = Utils.categoryName(error.getId(), id2DisplayName);
        if (error.getSeverity() == Severity.ERROR) {
            severity = "error";
            wae.errors++;
        } else {
            severity = "warning";
            wae.warnings++;
        }
        System.out.println(FileUtil.getFileDisplayName(error.getFile()) + ":" + (lineNumber + 1) + ": " + severity + ": " + idDisplayName + error.getDescription());
        System.out.println(line);
        System.out.println(b);
    }

    private static void apply(ProgressHandleWrapper progress, BatchSearch.BatchResult rawOccurrences, Writer out) throws IOException {
        LinkedList problems = new LinkedList();
        Collection<ModificationResult> diffs = BatchUtilities.applyFixes(rawOccurrences, progress, new AtomicBoolean(), new ArrayList(), null, true, problems);
        if (out != null) {
            for (ModificationResult modificationResult : diffs) {
            }
        } else {
            for (ModificationResult mr : diffs) {
                mr.commit();
                for (FileObject fileObject : mr.getModifiedFileObjects()) {
                    Savable sc = fileObject.getLookup().lookup(Savable.class);
                    if (sc == null) continue;
                    sc.save();
                }
            }
        }
    }

    private static void printHints(ClassPath sourceFrom, ClassPath binaryFrom) throws IOException {
        TreeSet<String> hints = new TreeSet<String>();
        for (Map.Entry<HintMetadata, Collection<? extends HintDescription>> e : Main.listHints(sourceFrom, binaryFrom).entrySet()) {
            hints.add(e.getKey().displayName);
        }
        for (String h : hints) {
            System.out.println(h);
        }
    }

    private static ClassPath createClassPath(Iterable<? extends File> roots, ClassPath def) {
        if (roots == null) {
            return def;
        }
        ArrayList<URL> rootURLs = new ArrayList<URL>();
        for (File file : roots) {
            rootURLs.add(FileUtil.urlForArchiveOrDir(file));
        }
        return ClassPathSupport.createClassPath(rootURLs.toArray(new URL[0]));
    }

    private static void showGUICustomizer(File settingsFile, ClassPath binaryCP, ClassPath sourceCP) throws IOException, BackingStoreException {
    }

    static String[] splitGroupArg(String arg) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentPart = new StringBuilder();
        block4: for (int i = 0; i < arg.length(); ++i) {
            switch (arg.charAt(i)) {
                case '\\': {
                    if (++i >= arg.length()) continue block4;
                    currentPart.append(arg.charAt(i));
                    continue block4;
                }
                case ' ': {
                    if (currentPart.length() <= 0) continue block4;
                    result.add(currentPart.toString());
                    currentPart.delete(0, currentPart.length());
                    continue block4;
                }
                default: {
                    currentPart.append(arg.charAt(i));
                }
            }
        }
        if (currentPart.length() > 0) {
            result.add(currentPart.toString());
        }
        return result.toArray(new String[0]);
    }

    private static int findLineForPos(Map<FileObject, int[]> file2LineStartsCache, FileObject file, PositionRef pos) {
        return Main.findLineForPos(file2LineStartsCache, file, pos.getOffset());
    }

    static int findLineForPos(Map<FileObject, int[]> file2LineStartsCache, FileObject file, int offset) {
        int[] lineStarts = file2LineStartsCache.computeIfAbsent(file, x -> Main.lineStarts(file));
        int line = Arrays.binarySearch(lineStarts, offset);
        if (line < 0) {
            return -line - 1;
        }
        return line + 1;
    }

    private static int[] lineStarts(FileObject file) {
        try {
            ArrayList<Integer> lineStarts = new ArrayList<Integer>();
            lineStarts.add(0);
            for (String line : file.asLines()) {
                lineStarts.add((Integer)lineStarts.get(lineStarts.size() - 1) + line.length() + 1);
            }
            return lineStarts.stream().mapToInt(ls -> ls).toArray();
        }
        catch (IOException ex) {
            return new int[1];
        }
    }

    private static class PatchDescription {
        private final Map<FileObject, Set<Integer>> file2AddedLines;
        private final Map<FileObject, int[]> file2LineStarts = new HashMap<FileObject, int[]>();

        private PatchDescription(Map<FileObject, Set<Integer>> file2AddedLines) {
            this.file2AddedLines = file2AddedLines;
        }

        public boolean included(FileObject file) {
            return this.file2AddedLines.containsKey(file);
        }

        public boolean included(ErrorDescription error) {
            int startLine = Main.findLineForPos((Map<FileObject, int[]>)this.file2LineStarts, error.getFile(), error.getRange().getBegin());
            int endLine = Main.findLineForPos((Map<FileObject, int[]>)this.file2LineStarts, error.getFile(), error.getRange().getBegin());
            Set<Integer> addedLines = this.file2AddedLines.get(error.getFile());
            if (addedLines == null) {
                return false;
            }
            for (int line = startLine; line <= endLine; ++line) {
                if (!addedLines.contains(line)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class BCPFallBack
    implements ClassPathProvider {
        @Override
        public ClassPath findClassPath(FileObject file, String type) {
            for (ClassPathProvider p : Lookup.getDefault().lookupAll(ClassPathProvider.class)) {
                ClassPath cp;
                if (!(p instanceof TestPerformer.TestClassPathProvider) || (cp = ((TestPerformer.TestClassPathProvider)p).findClassPath(file, type)) == null) continue;
                return cp;
            }
            if ("classpath/boot".equals(type)) {
                return Utils.createDefaultBootClassPath();
            }
            return null;
        }
    }

    private static final class ConsoleProgressHandleAbstraction
    implements ProgressHandleWrapper.ProgressHandleAbstraction {
        private final int width = 78;
        private int total = -1;
        private int current = 0;
        private int currentShownDone = -1;

        @Override
        public synchronized void start(int totalWork) {
            if (this.total != -1) {
                throw new UnsupportedOperationException();
            }
            this.total = totalWork;
            this.update();
        }

        @Override
        public synchronized void progress(int currentWorkDone) {
            this.current = currentWorkDone;
            this.update();
        }

        @Override
        public void progress(String message) {
        }

        @Override
        public synchronized void finish() {
            this.current = this.total;
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    this.doUpdate(false);
                    System.out.println();
                }
            });
        }

        private void update() {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    this.doUpdate(true);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUpdate(boolean moveCaret) {
            int done;
            ConsoleProgressHandleAbstraction consoleProgressHandleAbstraction = this;
            synchronized (consoleProgressHandleAbstraction) {
                done = (int)(78.0 / (double)this.total * (double)this.current);
                if (done == this.currentShownDone) {
                    return;
                }
                this.currentShownDone = done;
            }
            int todo = 78 - done;
            PrintStream pw = System.out;
            pw.print("[");
            while (done-- > 0) {
                pw.print("=");
            }
            while (todo-- > 0) {
                pw.print(" ");
            }
            pw.print("]");
            if (moveCaret) {
                pw.print("\r");
            }
        }
    }

    public static final class SourceLevelQueryImpl
    implements SourceLevelQueryImplementation2 {
        @Override
        public SourceLevelQueryImplementation2.Result getSourceLevel(FileObject javaFile) {
            final RootConfiguration rootConfiguration = (RootConfiguration)currentRootConfiguration.get();
            if (rootConfiguration == null) {
                return null;
            }
            if (rootConfiguration.sourceCP.findOwnerRoot(javaFile) != null) {
                return new SourceLevelQueryImplementation2.Result(){

                    @Override
                    public String getSourceLevel() {
                        return rootConfiguration.sourceLevel;
                    }

                    @Override
                    public void addChangeListener(ChangeListener listener) {
                    }

                    @Override
                    public void removeChangeListener(ChangeListener listener) {
                    }
                };
            }
            return null;
        }
    }

    public static final class ClassPathProviderImpl
    implements ClassPathProvider {
        @Override
        public ClassPath findClassPath(FileObject file, String type) {
            RootConfiguration rootConfiguration = (RootConfiguration)currentRootConfiguration.get();
            if (rootConfiguration == null) {
                return null;
            }
            if (rootConfiguration.sourceCP.findOwnerRoot(file) != null) {
                if ("classpath/boot".equals(type)) {
                    return rootConfiguration.bootCP;
                }
                if ("classpath/compile".equals(type)) {
                    return rootConfiguration.compileCP;
                }
                if ("classpath/source".equals(type)) {
                    return rootConfiguration.sourceCP;
                }
            }
            return null;
        }
    }

    public static final class LookupProviderImpl
    extends ProxyLookup {
        public LookupProviderImpl() {
            super(Lookups.forPath("Services/AntBasedProjectTypes"));
        }
    }

    private static final class GlobalConfiguration {
        private final Preferences configurationPreferences;
        private final boolean apply;
        private final boolean runDeclarative;
        private final boolean runDeclarativeTests;
        private final boolean useDefaultEnabledSetting;
        private final String hint;
        private final File hintFile;
        private final File patchFile;
        private final Writer out;
        private final boolean failOnWarnings;

        public GlobalConfiguration(Preferences configurationPreferences, boolean apply, boolean runDeclarative, boolean runDeclarativeTests, boolean useDefaultEnabledSetting, String hint, File hintFile, File patchFile, Writer out, boolean failOnWarnings) {
            this.configurationPreferences = configurationPreferences;
            this.apply = apply;
            this.runDeclarative = runDeclarative;
            this.runDeclarativeTests = runDeclarativeTests;
            this.useDefaultEnabledSetting = useDefaultEnabledSetting;
            this.hint = hint;
            this.hintFile = hintFile;
            this.patchFile = patchFile;
            this.out = out;
            this.failOnWarnings = failOnWarnings;
        }
    }

    private static final class RootConfiguration {
        private final List<BatchSearch.Folder> rootFolders = new ArrayList<BatchSearch.Folder>();
        private final ClassPath bootCP;
        private final ClassPath compileCP;
        private final ClassPath sourceCP;
        private final ClassPath binaryCP;
        private final String sourceLevel;

        public RootConfiguration(OptionSet parsed, GroupOptions groupOptions) throws IOException {
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            for (String sr : parsed.nonOptionArguments()) {
                File r = new File(sr);
                FileObject root = FileUtil.toFileObject(r);
                if (root == null) continue;
                roots.add(root);
                this.rootFolders.add(new BatchSearch.Folder(root));
            }
            this.bootCP = Main.createClassPath(parsed.has(groupOptions.bootclasspath) ? parsed.valuesOf(groupOptions.bootclasspath) : null, Utils.createDefaultBootClassPath());
            this.compileCP = Main.createClassPath(parsed.has(groupOptions.classpath) ? parsed.valuesOf(groupOptions.classpath) : null, ClassPath.EMPTY);
            this.sourceCP = Main.createClassPath(parsed.has(groupOptions.sourcepath) ? parsed.valuesOf(groupOptions.sourcepath) : null, ClassPathSupport.createClassPath(roots.toArray(new FileObject[0])));
            this.binaryCP = ClassPathSupport.createProxyClassPath(this.bootCP, this.compileCP);
            this.sourceLevel = (String)parsed.valueOf(groupOptions.source);
        }
    }

    private static final class WarningsAndErrors {
        private int warnings;
        private int errors;

        private WarningsAndErrors() {
        }
    }

    private static enum GroupResult {
        NOTHING_TO_DO{

            @Override
            public GroupResult join(GroupResult other) {
                return other;
            }
        }
        ,
        NO_HINTS_FOUND{

            @Override
            public GroupResult join(GroupResult other) {
                if (other == NOTHING_TO_DO) {
                    return this;
                }
                return other;
            }
        }
        ,
        SUCCESS{

            @Override
            public GroupResult join(GroupResult other) {
                if (other == FAILURE) {
                    return other;
                }
                return this;
            }
        }
        ,
        FAILURE{

            @Override
            public GroupResult join(GroupResult other) {
                return this;
            }
        };


        public abstract GroupResult join(GroupResult var1);
    }

    private static class MemoryPreferences
    extends AbstractPreferences {
        private final Map<String, String> values = new HashMap<String, String>();
        private final Map<String, MemoryPreferences> nodes = new HashMap<String, MemoryPreferences>();

        public MemoryPreferences() {
            this(null, "");
        }

        public MemoryPreferences(MemoryPreferences parent, String name) {
            super(parent, name);
        }

        @Override
        protected void putSpi(String key, String value) {
            this.values.put(key, value);
        }

        @Override
        protected String getSpi(String key) {
            return this.values.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.values.remove(key);
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            ((MemoryPreferences)this.parent()).nodes.remove(this.name());
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            return this.values.keySet().toArray(new String[0]);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            return this.nodes.keySet().toArray(new String[0]);
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            MemoryPreferences result = this.nodes.get(name);
            if (result == null) {
                result = new MemoryPreferences(this, name);
                this.nodes.put(name, result);
            }
            return result;
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
        }
    }

    private static final class GroupOptions {
        private final ArgumentAcceptingOptionSpec<File> classpath;
        private final ArgumentAcceptingOptionSpec<File> bootclasspath;
        private final ArgumentAcceptingOptionSpec<File> sourcepath;
        private final ArgumentAcceptingOptionSpec<String> source;

        public GroupOptions(ArgumentAcceptingOptionSpec<File> classpath, ArgumentAcceptingOptionSpec<File> bootclasspath, ArgumentAcceptingOptionSpec<File> sourcepath, ArgumentAcceptingOptionSpec<String> source) {
            this.classpath = classpath;
            this.bootclasspath = bootclasspath;
            this.sourcepath = sourcepath;
            this.source = source;
        }
    }
}

