/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.autoupdate.ui.wizards.CustomHandleStep;
import org.netbeans.modules.autoupdate.ui.wizards.InstallStep;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.LicenseApprovalStep;
import org.openide.WizardDescriptor;

abstract class InstallableIteratorBase
implements WizardDescriptor.Iterator<WizardDescriptor> {
    protected final List<WizardDescriptor.Panel<WizardDescriptor>> panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
    protected final InstallUnitWizardModel installModel;
    protected int index;
    private WizardDescriptor.Panel<WizardDescriptor> licenseApprovalStep = null;
    private WizardDescriptor.Panel<WizardDescriptor> customHandleStep = null;
    private WizardDescriptor.Panel<WizardDescriptor> installStep = null;
    private boolean isCompact = false;
    private boolean clearLazyUnits = false;
    private final boolean allowRunInBackground;
    private final boolean runInBackground;

    public InstallableIteratorBase(InstallUnitWizardModel model) {
        this(model, false);
    }

    public InstallableIteratorBase(InstallUnitWizardModel model, boolean clearLazyUnits) {
        this(model, clearLazyUnits, true, true);
    }

    public InstallableIteratorBase(InstallUnitWizardModel model, boolean clearLazyUnits, boolean allowRunInBackground) {
        this(model, clearLazyUnits, allowRunInBackground, false);
    }

    public InstallableIteratorBase(InstallUnitWizardModel model, boolean clearLazyUnits, boolean allowRunInBackground, boolean runInBackground) {
        this.installModel = model;
        this.clearLazyUnits = clearLazyUnits;
        this.allowRunInBackground = allowRunInBackground;
        this.runInBackground = runInBackground;
        this.index = 0;
    }

    public InstallUnitWizardModel getModel() {
        assert (this.installModel != null);
        return this.installModel;
    }

    @Override
    public WizardDescriptor.Panel<WizardDescriptor> current() {
        assert (this.panels != null);
        return this.panels.get(this.index);
    }

    @Override
    public boolean hasNext() {
        this.compactPanels();
        return this.index < this.panels.size() - 1;
    }

    @Override
    public void nextPanel() {
        this.compactPanels();
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    @Override
    public void previousPanel() {
        this.compactPanels();
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    @Override
    public boolean hasPrevious() {
        this.compactPanels();
        return this.index > 0;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
    }

    protected void insertPanels(int index) {
        this.licenseApprovalStep = new LicenseApprovalStep(this.installModel);
        this.panels.add(index++, this.licenseApprovalStep);
        this.customHandleStep = new CustomHandleStep(this.installModel);
        this.panels.add(index++, this.customHandleStep);
        this.installStep = new InstallStep(this.installModel, this.clearLazyUnits, this.allowRunInBackground, this.runInBackground);
        this.panels.add(index++, this.installStep);
    }

    protected void removeInstallPanels() {
        this.panels.remove(this.licenseApprovalStep);
        this.panels.remove(this.installStep);
        this.panels.remove(this.customHandleStep);
    }

    protected void compactPanels() {
        if (this.isCompact) {
            return;
        }
        boolean allLicensesTouched = this.getModel().allLicensesTouched();
        if (allLicensesTouched && this.getModel().allLicensesApproved()) {
            this.panels.remove(this.licenseApprovalStep);
        }
        if (!this.getModel().hasCustomComponents()) {
            this.panels.remove(this.customHandleStep);
        }
        if (!this.getModel().hasStandardComponents()) {
            this.panels.remove(this.installStep);
        }
        this.isCompact = allLicensesTouched;
    }
}

