/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.kylin.common.persistence.metadata.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.util.CompressionUtils;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.springframework.jdbc.core.RowMapper;

import lombok.SneakyThrows;
import lombok.val;

public class RawResourceRowMapper implements RowMapper<RawResource> {
    @SneakyThrows
    @Override
    public RawResource mapRow(ResultSet rs, int rowNum) throws SQLException {
        val resPath = rs.getString(1);
        val content = CompressionUtils.decompress(rs.getBytes(2));
        val ts = rs.getLong(3);
        val mvcc = rs.getLong(4);
        return new RawResource(resPath, ByteSource.wrap(content), ts, mvcc);
    }
}
