/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.access;

import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.DateUtils;

public class RecordIterator
implements Iterator<Record> {
    private final List<Column> childrenColumns;
    private final List<org.apache.tsfile.read.common.type.Type> dataTypes;
    private final int positionCount;
    protected int currentIndex;

    public RecordIterator(List<Column> childrenColumns, List<org.apache.tsfile.read.common.type.Type> dataTypes, int positionCount) {
        this.childrenColumns = childrenColumns;
        this.dataTypes = dataTypes;
        this.positionCount = positionCount;
        if (childrenColumns.size() != dataTypes.size()) {
            throw new IllegalArgumentException("The size of childrenColumns and dataTypes should be the same.");
        }
    }

    protected int getCurrentIndex() {
        return this.currentIndex++;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.positionCount;
    }

    @Override
    public Record next() {
        return new RecordImpl(this.childrenColumns, this.dataTypes, this.getCurrentIndex());
    }

    private static class RecordImpl
    implements Record {
        private final List<Column> childrenColumns;
        private final List<org.apache.tsfile.read.common.type.Type> dataTypes;
        private int index;

        private RecordImpl(List<Column> childrenColumns, List<org.apache.tsfile.read.common.type.Type> dataTypes, int index) {
            this.childrenColumns = childrenColumns;
            this.dataTypes = dataTypes;
            this.index = index;
        }

        public int getInt(int columnIndex) {
            return this.childrenColumns.get(columnIndex).getInt(this.index);
        }

        public long getLong(int columnIndex) {
            return this.childrenColumns.get(columnIndex).getLong(this.index);
        }

        public float getFloat(int columnIndex) {
            return this.childrenColumns.get(columnIndex).getFloat(this.index);
        }

        public double getDouble(int columnIndex) {
            return this.childrenColumns.get(columnIndex).getDouble(this.index);
        }

        public boolean getBoolean(int columnIndex) {
            return this.childrenColumns.get(columnIndex).getBoolean(this.index);
        }

        public Binary getBinary(int columnIndex) {
            return this.childrenColumns.get(columnIndex).getBinary(this.index);
        }

        public String getString(int columnIndex) {
            return this.childrenColumns.get(columnIndex).getBinary(this.index).getStringValue(TSFileConfig.STRING_CHARSET);
        }

        public LocalDate getLocalDate(int columnIndex) {
            return DateUtils.parseIntToLocalDate((int)this.childrenColumns.get(columnIndex).getInt(this.index));
        }

        public Object getObject(int columnIndex) {
            return this.childrenColumns.get(columnIndex).getObject(this.index);
        }

        public Type getDataType(int columnIndex) {
            return UDFDataTypeTransformer.transformReadTypeToUDFDataType(this.dataTypes.get(columnIndex));
        }

        public boolean isNull(int columnIndex) {
            return this.childrenColumns.get(columnIndex).isNull(this.index);
        }

        public int size() {
            return this.childrenColumns.size();
        }
    }
}

