/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services.helpers;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.AccessContext;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.api.services.ViewServices;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.sdk.server.util.UaEnumUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.ExecutionQueue;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.slf4j.LoggerFactory;

public class BrowseHelper {
    private static final StatusCode BAD_CONTINUATION_POINT_INVALID = new StatusCode(2152333312L);
    private static final StatusCode BAD_NO_CONTINUATION_POINTS = new StatusCode(2152398848L);
    private static final BrowseResult NODE_ID_UNKNOWN_RESULT = new BrowseResult(new StatusCode(2150891520L), ByteString.NULL_VALUE, new ReferenceDescription[0]);
    private static final BrowseResult REFERENCE_TYPE_ID_INVALID_RESULT = new BrowseResult(new StatusCode(2152464384L), ByteString.NULL_VALUE, new ReferenceDescription[0]);
    private final ExecutionQueue browseQueue;

    public BrowseHelper(ExecutorService executor) {
        this.browseQueue = new ExecutionQueue((Executor)executor, Runtime.getRuntime().availableProcessors());
    }

    public CompletableFuture<BrowseResult> browse(AccessContext context, OpcUaServer server, ViewDescription viewDescription, UInteger maxReferencesPerNode, BrowseDescription browseDescription) {
        if (browseDescription.getBrowseDirection() == null) {
            BrowseResult result = new BrowseResult(new StatusCode(2152529920L), ByteString.NULL_VALUE, null);
            return CompletableFuture.completedFuture(result);
        }
        Browse browse = new Browse(context, server, viewDescription, maxReferencesPerNode, browseDescription);
        return browse.browse();
    }

    public void browseNext(ServiceRequest service) {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        BrowseNextRequest request = (BrowseNextRequest)service.getRequest();
        List continuationPoints = ConversionUtil.l((Object[])request.getContinuationPoints());
        if (continuationPoints.size() > server.getConfig().getLimits().getMaxBrowseContinuationPoints().intValue()) {
            service.setServiceFault(0x80100000L);
        } else {
            server.getExecutorService().execute(new BrowseNext(server, service));
        }
    }

    private static class BrowseAttributes {
        private final QualifiedName browseName;
        private final LocalizedText displayName;
        private final NodeClass nodeClass;

        private BrowseAttributes(QualifiedName browseName, LocalizedText displayName, NodeClass nodeClass) {
            this.browseName = browseName;
            this.displayName = displayName;
            this.nodeClass = nodeClass;
        }

        public QualifiedName getBrowseName() {
            return this.browseName;
        }

        public LocalizedText getDisplayName() {
            return this.displayName;
        }

        public NodeClass getNodeClass() {
            return this.nodeClass;
        }
    }

    public static class BrowseContinuationPoint {
        private final List<ReferenceDescription> references;
        private final int max;
        private final ByteString identifier;

        public BrowseContinuationPoint(List<ReferenceDescription> references, int max) {
            this(references, max, BrowseContinuationPoint.generateId());
        }

        public BrowseContinuationPoint(List<ReferenceDescription> references, int max, ByteString identifier) {
            this.references = Collections.synchronizedList(references);
            this.max = max;
            this.identifier = identifier;
        }

        public List<ReferenceDescription> getReferences() {
            return this.references;
        }

        public int getMax() {
            return this.max;
        }

        public ByteString getIdentifier() {
            return this.identifier;
        }

        public static ByteString generateId() {
            return NonceUtil.generateNonce((int)16);
        }
    }

    private static class BrowseNext
    implements Runnable {
        private final Session session;
        private final OpcUaServer server;
        private final ServiceRequest service;

        private BrowseNext(OpcUaServer server, ServiceRequest service) {
            this.server = server;
            this.service = service;
            this.session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        }

        @Override
        public void run() {
            BrowseNextRequest request = (BrowseNextRequest)this.service.getRequest();
            List continuationPoints = ConversionUtil.l((Object[])request.getContinuationPoints());
            if (continuationPoints.isEmpty()) {
                this.service.setServiceFault(0x800F0000L);
                return;
            }
            ArrayList results = Lists.newArrayList();
            for (ByteString bs : continuationPoints) {
                if (request.getReleaseContinuationPoints().booleanValue()) {
                    results.add(this.release(bs));
                    continue;
                }
                results.add(this.references(bs));
            }
            ResponseHeader header = this.service.createResponseHeader();
            BrowseNextResponse response = new BrowseNextResponse(header, results.toArray(new BrowseResult[0]), new DiagnosticInfo[0]);
            this.service.setResponse((UaResponseMessage)response);
        }

        private BrowseResult release(ByteString bs) {
            BrowseContinuationPoint c = this.session.getBrowseContinuationPoints().remove(bs);
            return c != null ? new BrowseResult(StatusCode.GOOD, null, null) : new BrowseResult(BAD_CONTINUATION_POINT_INVALID, null, null);
        }

        private BrowseResult references(ByteString bs) {
            BrowseContinuationPoint c = this.session.getBrowseContinuationPoints().remove(bs);
            if (c != null) {
                int max = c.max;
                List references = c.references;
                if (references.size() > max) {
                    List subList = references.subList(0, max);
                    ArrayList current = Lists.newArrayList(subList);
                    subList.clear();
                    this.session.getBrowseContinuationPoints().put(c.identifier, c);
                    return new BrowseResult(StatusCode.GOOD, c.identifier, current.toArray(new ReferenceDescription[0]));
                }
                return new BrowseResult(StatusCode.GOOD, null, references.toArray(new ReferenceDescription[0]));
            }
            return new BrowseResult(BAD_CONTINUATION_POINT_INVALID, null, null);
        }
    }

    private class Browse {
        private final CompletableFuture<BrowseResult> future = new CompletableFuture();
        private final Session session;
        private final AccessContext context;
        private final OpcUaServer server;
        private final ViewDescription view;
        private final UInteger maxReferencesPerNode;
        private final BrowseDescription browseDescription;

        private Browse(AccessContext context, OpcUaServer server, ViewDescription view, UInteger maxReferencesPerNode, BrowseDescription browseDescription) {
            this.context = context;
            this.server = server;
            this.view = view;
            this.browseDescription = browseDescription;
            this.maxReferencesPerNode = maxReferencesPerNode;
            this.session = context.getSession().orElseThrow(() -> new IllegalArgumentException("AccessContext must have a session"));
        }

        public CompletableFuture<BrowseResult> browse() {
            BrowseHelper.this.browseQueue.submit(() -> {
                NodeId referenceTypeId = this.browseDescription.getReferenceTypeId();
                if (referenceTypeId.isNotNull() && !this.server.getReferenceTypes().containsKey(referenceTypeId)) {
                    this.future.complete(REFERENCE_TYPE_ID_INVALID_RESULT);
                    return;
                }
                ViewServices.BrowseContext browseContext = new ViewServices.BrowseContext(this.server, this.context.getSession().orElse(null));
                this.server.getAddressSpaceManager().browse(browseContext, this.view, this.browseDescription.getNodeId());
                CompletableFuture referencesFuture = browseContext.getFuture();
                referencesFuture.whenComplete((references, ex) -> {
                    if (references != null) {
                        this.browse((List<Reference>)references).whenComplete((result, ex2) -> {
                            if (result != null) {
                                this.future.complete((BrowseResult)result);
                            } else {
                                this.future.complete(NODE_ID_UNKNOWN_RESULT);
                            }
                        });
                    } else {
                        this.future.complete(NODE_ID_UNKNOWN_RESULT);
                    }
                });
            });
            return this.future;
        }

        private CompletableFuture<BrowseResult> browse(List<Reference> references) {
            List fs = references.stream().filter(this::directionFilter).filter(this::referenceTypeFilter).map(this::referenceDescription).collect(Collectors.toList());
            return FutureUtils.sequence(fs).thenApply(referenceDescriptions -> {
                int max = this.maxReferencesPerNode.longValue() == 0L ? Integer.MAX_VALUE : Ints.saturatedCast((long)this.maxReferencesPerNode.longValue());
                return this.browseResult(max, referenceDescriptions.stream().filter(this::nodeClassFilter).collect(Collectors.toList()));
            });
        }

        private BrowseResult browseResult(int max, List<ReferenceDescription> references) {
            if (references.size() > max) {
                if (this.session.getBrowseContinuationPoints().size() > this.server.getConfig().getLimits().getMaxBrowseContinuationPoints().intValue()) {
                    return new BrowseResult(BAD_NO_CONTINUATION_POINTS, null, new ReferenceDescription[0]);
                }
                List<ReferenceDescription> subList = references.subList(0, max);
                ArrayList current = Lists.newArrayList(subList);
                subList.clear();
                BrowseContinuationPoint c = new BrowseContinuationPoint(references, max);
                this.session.getBrowseContinuationPoints().put(c.identifier, c);
                return new BrowseResult(StatusCode.GOOD, c.identifier, current.toArray(new ReferenceDescription[0]));
            }
            return new BrowseResult(StatusCode.GOOD, null, references.toArray(new ReferenceDescription[0]));
        }

        private boolean directionFilter(Reference reference) {
            switch (this.browseDescription.getBrowseDirection()) {
                case Forward: {
                    return reference.isForward();
                }
                case Inverse: {
                    return reference.isInverse();
                }
            }
            return true;
        }

        private boolean referenceTypeFilter(Reference reference) {
            NodeId referenceTypeId = this.browseDescription.getReferenceTypeId();
            boolean includeAny = referenceTypeId == null || referenceTypeId.isNull();
            boolean includeSubtypes = this.browseDescription.getIncludeSubtypes();
            return includeAny || reference.getReferenceTypeId().equals((Object)referenceTypeId) || includeSubtypes && reference.subtypeOf(referenceTypeId, this.server.getReferenceTypes());
        }

        private boolean nodeClassFilter(ReferenceDescription referenceDescription) {
            long mask = this.browseDescription.getNodeClassMask().longValue();
            EnumSet<NodeClass> nodeClasses = mask == 0L ? EnumSet.allOf(NodeClass.class) : UaEnumUtil.nodeClasses(mask);
            return nodeClasses.contains(referenceDescription.getNodeClass());
        }

        private CompletableFuture<ReferenceDescription> referenceDescription(Reference reference) {
            EnumSet<BrowseResultMask> masks = UaEnumUtil.browseResultMasks(this.browseDescription.getResultMask().longValue());
            ExpandedNodeId targetNodeId = reference.getTargetNodeId();
            NodeId referenceTypeId = masks.contains(BrowseResultMask.ReferenceTypeId) ? reference.getReferenceTypeId() : NodeId.NULL_VALUE;
            boolean forward = masks.contains(BrowseResultMask.IsForward) && reference.isForward();
            return targetNodeId.toNodeId(this.server.getNamespaceTable()).map(nodeId -> {
                CompletableFuture<BrowseAttributes> attributesFuture = this.browseAttributes((NodeId)nodeId);
                CompletionStage referenceFuture = attributesFuture.thenCompose(attributes -> {
                    if (masks.contains(BrowseResultMask.TypeDefinition) && (((BrowseAttributes)attributes).nodeClass == NodeClass.Object || ((BrowseAttributes)attributes).nodeClass == NodeClass.Variable)) {
                        return this.getTypeDefinition((NodeId)nodeId).thenApply(typeDefinition -> new ReferenceDescription(referenceTypeId, Boolean.valueOf(forward), targetNodeId, masks.contains(BrowseResultMask.BrowseName) ? attributes.getBrowseName() : QualifiedName.NULL_VALUE, masks.contains(BrowseResultMask.DisplayName) ? attributes.getDisplayName() : LocalizedText.NULL_VALUE, masks.contains(BrowseResultMask.NodeClass) ? attributes.getNodeClass() : NodeClass.Unspecified, typeDefinition));
                    }
                    return CompletableFuture.completedFuture(new ReferenceDescription(referenceTypeId, Boolean.valueOf(forward), targetNodeId, masks.contains(BrowseResultMask.BrowseName) ? attributes.getBrowseName() : QualifiedName.NULL_VALUE, masks.contains(BrowseResultMask.DisplayName) ? attributes.getDisplayName() : LocalizedText.NULL_VALUE, masks.contains(BrowseResultMask.NodeClass) ? attributes.getNodeClass() : NodeClass.Unspecified, ExpandedNodeId.NULL_VALUE));
                });
                return ((CompletableFuture)referenceFuture).whenComplete((r, ex) -> {
                    if (ex != null) {
                        LoggerFactory.getLogger(BrowseHelper.class).warn("failed to get browse attributes for: {}", (Object)reference.getSourceNodeId(), ex);
                    }
                });
            }).orElseGet(() -> {
                LoggerFactory.getLogger(BrowseHelper.class).warn("reference target not local: {} -> {}", (Object)reference.getSourceNodeId(), (Object)targetNodeId);
                return CompletableFuture.completedFuture(new ReferenceDescription(referenceTypeId, Boolean.valueOf(forward), targetNodeId, QualifiedName.NULL_VALUE, LocalizedText.NULL_VALUE, NodeClass.Unspecified, ExpandedNodeId.NULL_VALUE));
            });
        }

        private CompletableFuture<BrowseAttributes> browseAttributes(NodeId nodeId) {
            ArrayList readValueIds = Lists.newArrayList();
            readValueIds.add(new ReadValueId(nodeId, AttributeId.BrowseName.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(nodeId, AttributeId.DisplayName.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(nodeId, AttributeId.NodeClass.uid(), null, QualifiedName.NULL_VALUE));
            AttributeServices.ReadContext context = new AttributeServices.ReadContext(this.server, null);
            this.server.getAddressSpaceManager().read(context, 0.0, TimestampsToReturn.Neither, readValueIds);
            return context.getFuture().thenApply(values -> {
                DataValue value2;
                DataValue value1;
                QualifiedName browseName = QualifiedName.NULL_VALUE;
                LocalizedText displayName = LocalizedText.NULL_VALUE;
                NodeClass nodeClass = NodeClass.Unspecified;
                DataValue value0 = (DataValue)values.get(0);
                if (value0.getStatusCode() == null || value0.getStatusCode().isGood()) {
                    browseName = (QualifiedName)value0.getValue().getValue();
                }
                if ((value1 = (DataValue)values.get(1)).getStatusCode() == null || value1.getStatusCode().isGood()) {
                    displayName = (LocalizedText)value1.getValue().getValue();
                }
                if ((value2 = (DataValue)values.get(2)).getStatusCode() == null || value2.getStatusCode().isGood()) {
                    nodeClass = (NodeClass)value2.getValue().getValue();
                }
                return new BrowseAttributes(browseName, displayName, nodeClass);
            });
        }

        private CompletableFuture<ExpandedNodeId> getTypeDefinition(NodeId nodeId) {
            Optional<ExpandedNodeId> typeDefinitionId = this.server.getAddressSpaceManager().getManagedReferences(nodeId, Reference.HAS_TYPE_DEFINITION_PREDICATE).stream().findFirst().map(Reference::getTargetNodeId);
            return typeDefinitionId.map(CompletableFuture::completedFuture).orElseGet(() -> {
                LoggerFactory.getLogger(BrowseHelper.class).trace("No managed TypeDefinition for nodeId={}, browsing...", (Object)nodeId);
                ViewServices.BrowseContext browseContext = new ViewServices.BrowseContext(this.server, this.context.getSession().orElse(null));
                this.server.getAddressSpaceManager().browse(browseContext, nodeId);
                CompletableFuture browseFuture = browseContext.getFuture();
                return browseFuture.thenApply(references -> references.stream().filter(r -> Identifiers.HasTypeDefinition.equals((Object)r.getReferenceTypeId())).findFirst().map(Reference::getTargetNodeId).orElse(ExpandedNodeId.NULL_VALUE));
            });
        }
    }
}

