package org.apache.torque.generator.outlet;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * An merge point where the output of another outlet can be merged
 * into the text generated by a outlet.
 */
public class Mergepoint
{
    /**
     * The name of the merge point.
     */
    private String name;

    /**
     * Constructor.
     *
     * @param name the name of the merge point, not null.
     *
     * @throws NullPointerException if the name is null.
     */
    public Mergepoint(String name)
    {
        if (name == null)
        {
            throw new NullPointerException("name must not be null");
        }
        this.name = name;
    }

    /**
     * Returns the name of the merge point.
     *
     * @return the name of the merge point, never null.
     */
    public String getName()
    {
        return name;
    }

    /**
     * Returns a String representation of the Mergepoint for debugging purposes.
     *
     * @return a String representation of the Mergepoint.
     * @see Object#toString()
     */
    @Override
    public String toString()
    {
        StringBuffer result = new StringBuffer();
        result.append(name);
        return result.toString();
    }
}
