/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BlobSetBytesBoundaryTest
extends BaseJDBCTestCase {
    private static final byte[] BOLB_CONTENT = "test".getBytes();

    public BlobSetBytesBoundaryTest(String string) {
        super(string);
    }

    public static Test suite() {
        Test test = TestConfiguration.defaultSuite(BlobSetBytesBoundaryTest.class, false);
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                BlobSetBytesBoundaryTest.initializeBlobData(statement);
            }
        };
    }

    public void testSetBytesWithTooLongLength() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        ResultSet resultSet = statement.executeQuery("select dBlob, length from BlobTable");
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        try {
            blob.setBytes(1L, new byte[]{105}, 0, 2);
            BlobSetBytesBoundaryTest.fail((String)"Wrong long length is not accepted!");
        }
        catch (SQLException sQLException) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ079", sQLException);
        }
        statement.close();
    }

    public void testSetBytesByBadLengthAndOffset() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        ResultSet resultSet = statement.executeQuery("select dBlob, length from BlobTable");
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        try {
            blob.setBytes(1L, new byte[]{105, 78, 71, 85}, 1, 4);
            BlobSetBytesBoundaryTest.fail((String)"Wrong offset and length is not accepted!");
        }
        catch (SQLException sQLException) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ079", sQLException);
        }
        try {
            blob.setBytes(1L, new byte[100], 10, Integer.MAX_VALUE);
            BlobSetBytesBoundaryTest.fail((String)"setBytes() should fail when offset+length > bytes.length");
        }
        catch (SQLException sQLException) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ079", sQLException);
        }
        statement.close();
    }

    public void testSetBytesWithZeroLength() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        ResultSet resultSet = statement.executeQuery("select dBlob, length from BlobTable");
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        int n = blob.setBytes(1L, new byte[]{105}, 0, 0);
        BlobSetBytesBoundaryTest.assertEquals((String)"return zero for zero length", (int)0, (int)n);
        statement.close();
    }

    public void testSetBytesWithNonPositiveLength() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        ResultSet resultSet = statement.executeQuery("select dBlob, length from BlobTable");
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        try {
            blob.setBytes(1L, new byte[]{105}, 0, -1);
            BlobSetBytesBoundaryTest.fail((String)"Nonpositive Length is not sccepted!");
        }
        catch (SQLException sQLException) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ071", sQLException);
        }
        statement.close();
    }

    public void testSetBytesWithInvalidOffset() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        ResultSet resultSet = statement.executeQuery("select dBlob, length from BlobTable");
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        try {
            blob.setBytes(1L, new byte[]{11}, -1, 1);
            BlobSetBytesBoundaryTest.fail((String)"Invalid offset Length is not sccepted!");
        }
        catch (SQLException sQLException) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ078", sQLException);
        }
        try {
            blob.setBytes(1L, new byte[]{11}, 2, 1);
            BlobSetBytesBoundaryTest.fail((String)"Invalid offset Length is not sccepted!");
        }
        catch (SQLException sQLException) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ078", sQLException);
        }
        try {
            blob.setBytes(1L, new byte[]{11, 14}, Integer.MAX_VALUE, 1);
            BlobSetBytesBoundaryTest.fail((String)"Invalid offset Length is not sccepted!");
        }
        catch (SQLException sQLException) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ078", sQLException);
        }
        statement.close();
    }

    public void testSetBytesWithEmptyBytes() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        ResultSet resultSet = statement.executeQuery("select dBlob, length from BlobTable");
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        BlobSetBytesBoundaryTest.assertEquals((int)0, (int)blob.setBytes(1L, new byte[0]));
        statement.close();
    }

    public void testSetBytesWithTooBigPos() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        ResultSet resultSet = statement.executeQuery("select dBlob, length from BlobTable");
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        try {
            blob.setBytes(Integer.MAX_VALUE, new byte[]{15});
            BlobSetBytesBoundaryTest.fail((String)"Too big position is not sccepted!");
        }
        catch (SQLException sQLException) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ076", sQLException);
        }
        try {
            blob.setBytes(BOLB_CONTENT.length + 2, new byte[]{15});
            BlobSetBytesBoundaryTest.fail((String)"Too big position is not sccepted!");
        }
        catch (SQLException sQLException) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ076", sQLException);
        }
        statement.close();
    }

    public void testSetBytesWithNonpositivePos() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        ResultSet resultSet = statement.executeQuery("select dBlob, length from BlobTable");
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        try {
            blob.setBytes(0L, new byte[]{15});
            BlobSetBytesBoundaryTest.fail((String)"Nonpositive position is not sccepted!");
        }
        catch (SQLException sQLException) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ070", sQLException);
        }
        try {
            blob.setBytes(-1L, new byte[]{15});
            BlobSetBytesBoundaryTest.fail((String)"Nonpositive position is not sccepted!");
        }
        catch (SQLException sQLException) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ070", sQLException);
        }
        statement.close();
    }

    private static void initializeBlobData(Statement statement) throws SQLException {
        Connection connection = statement.getConnection();
        connection.setAutoCommit(false);
        try {
            statement.executeUpdate("drop table BlobTable");
        }
        catch (SQLException sQLException) {
            BlobSetBytesBoundaryTest.assertSQLState("42Y55", sQLException);
        }
        statement.executeUpdate("create table BlobTable (dBlob Blob, length int)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into BlobTable values (?,?)");
        preparedStatement.setBytes(1, BOLB_CONTENT);
        preparedStatement.setInt(2, BOLB_CONTENT.length);
        preparedStatement.executeUpdate();
        connection.commit();
    }
}

