/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.nio.ByteBuffer;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.impl.drda.Utf8CcsidManager;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Utf8CcsidManagerTest
extends BaseTestCase {
    private Utf8CcsidManager ccsidManager = new Utf8CcsidManager();

    public Utf8CcsidManagerTest(String string) {
        super(string);
    }

    public void testConvertFromJavaString() throws Exception {
        String string = new String(new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-16"), "UTF-16");
        byte[] byArray = new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        byte[] byArray2 = this.ccsidManager.convertFromJavaString(string);
        Utf8CcsidManagerTest.assertTrue((String)"UTF-8 conversion isn't equal to bytes", (boolean)Arrays.equals(byArray, byArray2));
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        this.ccsidManager.convertFromJavaString(string, byteBuffer);
        if (byteBuffer.hasArray()) {
            byArray2 = byteBuffer.array();
            Utf8CcsidManagerTest.assertTrue((String)"UTF-8 conversion isn't equal to bytes (with buffer)", (boolean)Arrays.equals(byArray, byArray2));
        } else {
            Utf8CcsidManagerTest.fail((String)"Could not convert from UCS2 to UTF-8 using a buffer");
        }
    }

    public void testConvertToJavaString() throws Exception {
        byte[] byArray = new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        String string = new String(new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-16"), "UTF-16");
        String string2 = new String(new String("\u597d\u4e16").getBytes("UTF-16"), "UTF-16");
        String string3 = this.ccsidManager.convertToJavaString(byArray);
        Utf8CcsidManagerTest.assertEquals((String)string, (String)string3);
        String string4 = this.ccsidManager.convertToJavaString(byArray, 3, 6);
        Utf8CcsidManagerTest.assertEquals((String)string2, (String)string4);
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(Utf8CcsidManagerTest.class);
    }
}

