/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import org.apache.derbyTesting.junit.Utilities;
import org.apache.derbyTesting.junit.Version;

public class DerbyVersion
implements Comparable {
    public static final DerbyVersion _10_0 = new DerbyVersion(10, 0, 0, 0);
    public static final DerbyVersion _10_1 = new DerbyVersion(10, 1, 0, 0);
    public static final DerbyVersion _10_2 = new DerbyVersion(10, 2, 0, 0);
    public static final DerbyVersion _10_3 = new DerbyVersion(10, 3, 0, 0);
    public static final DerbyVersion _10_4 = new DerbyVersion(10, 4, 0, 0);
    public static final DerbyVersion _10_5 = new DerbyVersion(10, 5, 0, 0);
    public static final DerbyVersion _10_6 = new DerbyVersion(10, 6, 0, 0);
    public static final DerbyVersion _10_7 = new DerbyVersion(10, 7, 0, 0);
    public static final DerbyVersion _10_8 = new DerbyVersion(10, 8, 0, 0);
    public static final DerbyVersion _10_9 = new DerbyVersion(10, 9, 0, 0);
    public static final DerbyVersion _10_10 = new DerbyVersion(10, 10, 0, 0);
    public static final DerbyVersion _10_0_2_1 = new DerbyVersion(10, 0, 2, 1);
    public static final DerbyVersion _10_1_1_0 = new DerbyVersion(10, 1, 1, 0);
    public static final DerbyVersion _10_1_2_1 = new DerbyVersion(10, 1, 2, 1);
    public static final DerbyVersion _10_1_3_1 = new DerbyVersion(10, 1, 3, 1);
    public static final DerbyVersion _10_2_1_6 = new DerbyVersion(10, 2, 1, 6);
    public static final DerbyVersion _10_2_2_0 = new DerbyVersion(10, 2, 2, 0);
    public static final DerbyVersion _10_3_1_4 = new DerbyVersion(10, 3, 1, 4);
    public static final DerbyVersion _10_3_3_0 = new DerbyVersion(10, 3, 3, 0);
    public static final DerbyVersion _10_4_1_3 = new DerbyVersion(10, 4, 1, 3);
    public static final DerbyVersion _10_4_2_0 = new DerbyVersion(10, 4, 2, 0);
    public static final DerbyVersion _10_5_1_1 = new DerbyVersion(10, 5, 1, 1);
    public static final DerbyVersion _10_5_3_0 = new DerbyVersion(10, 5, 3, 0);
    public static final DerbyVersion _10_6_1_0 = new DerbyVersion(10, 6, 1, 0);
    public static final DerbyVersion _10_6_2_1 = new DerbyVersion(10, 6, 2, 1);
    public static final DerbyVersion _10_7_1_1 = new DerbyVersion(10, 7, 1, 1);
    public static final DerbyVersion _10_8_1_2 = new DerbyVersion(10, 8, 1, 2);
    public static final DerbyVersion _10_8_2_2 = new DerbyVersion(10, 8, 2, 2);
    public static final DerbyVersion _10_8_3_0 = new DerbyVersion(10, 8, 3, 0);
    public static final DerbyVersion _10_9_1_0 = new DerbyVersion(10, 9, 1, 0);
    public static final DerbyVersion FIRST_JIGSAW_VERSION = new DerbyVersion(10, 15, 0, 0);
    private final int major;
    private final int minor;
    private final int fixpack;
    private final int point;
    private final Version simpleVersion;

    public static DerbyVersion parseVersionString(String versionString) throws IllegalArgumentException {
        String[] components = Utilities.split(versionString.trim(), ' ');
        if ((components = Utilities.split(components[0], '.')).length != 4) {
            throw new IllegalArgumentException("invalid number of version components, got " + components.length + " expected 4: " + versionString);
        }
        return new DerbyVersion(Integer.parseInt(components[0]), Integer.parseInt(components[1]), Integer.parseInt(components[2]), Integer.parseInt(components[3]));
    }

    public DerbyVersion(int major, int minor, int fixpack, int point) {
        this.major = major;
        this.minor = minor;
        this.fixpack = fixpack;
        this.point = point;
        this.simpleVersion = new Version(major, minor);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getFixpack() {
        return this.fixpack;
    }

    public int getPoint() {
        return this.point;
    }

    public boolean lessThan(DerbyVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean greaterThan(DerbyVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean greaterMinorThan(DerbyVersion other) {
        if (!this.sameMajorAs(other)) {
            throw new IllegalArgumentException("major versions must be equal");
        }
        return this.minor > other.minor;
    }

    public boolean atLeast(DerbyVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean atMost(DerbyVersion other) {
        return this.compareTo(other) <= 0;
    }

    public boolean atMajorMinor(int major, int minor) {
        return this.major == major && this.minor == minor;
    }

    public boolean atMajorMinorOf(DerbyVersion other) {
        return this.major == other.major && this.minor == other.minor;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.fixpack + "." + this.point;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DerbyVersion other = (DerbyVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        if (this.fixpack != other.fixpack) {
            return false;
        }
        return this.point == other.point;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + this.major;
        hash = 23 * hash + this.minor;
        hash = 23 * hash + this.fixpack;
        hash = 23 * hash + this.point;
        return hash;
    }

    public int compareTo(Object o) {
        return this.compareTo((DerbyVersion)o);
    }

    public int compareTo(DerbyVersion o) {
        if (this.major < o.major) {
            return -1;
        }
        if (this.major > o.major) {
            return 1;
        }
        if (this.minor < o.minor) {
            return -1;
        }
        if (this.minor > o.minor) {
            return 1;
        }
        if (this.fixpack < o.fixpack) {
            return -1;
        }
        if (this.fixpack > o.fixpack) {
            return 1;
        }
        if (this.point < o.point) {
            return -1;
        }
        if (this.point > o.point) {
            return 1;
        }
        return 0;
    }

    public Version asSimpleVersion() {
        return this.simpleVersion;
    }

    private boolean sameMajorAs(DerbyVersion other) {
        return this.major == other.major;
    }
}

