/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class RecoveryAfterBackup {
    public static void main(String[] argv) throws Throwable {
        try {
            ij.getPropertyArg((String[])argv);
            Connection conn = ij.startJBMS();
            conn.setAutoCommit(true);
            Statement s = conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT COUNT(a), SUM(a) FROM t1");
            while (rs.next()) {
                int count = rs.getInt(1);
                int sum = rs.getInt(2);
                if (count != 2 || sum != 1) {
                    System.out.print("Unexpected initial database state: ");
                }
                System.out.println("Count: " + count + " Sum: " + sum);
            }
            System.out.println("Inserting records ...");
            s.execute("INSERT INTO t1 SELECT a+2 FROM t1");
            s.execute("INSERT INTO t1 SELECT a+4 FROM t1");
            s.execute("INSERT INTO t1 SELECT a+8 FROM t1");
            s.execute("INSERT INTO t1 SELECT a+16 FROM t1");
            s.execute("INSERT INTO t1 SELECT a+32 FROM t1");
            s.execute("INSERT INTO t1 SELECT a+64 FROM t1");
            s.execute("INSERT INTO t1 SELECT a+128 FROM t1");
            System.out.println("Shutting down database ...");
            try {
                TestUtil.getConnection("", "shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState() != null && sqle.getSQLState().equals("XJ015")) {
                    System.out.println("Database shutdown completed");
                }
                throw sqle;
            }
            System.out.println("Starting restore with roll-forward recovery..");
            String dbName = "hairynosedwombat";
            String connAttrs = "rollForwardRecoveryFrom=extinout/mybackup/hairynosedwombat";
            conn = TestUtil.getConnection(dbName, connAttrs);
            System.out.println("Verifying database ...");
            s = conn.createStatement();
            rs = s.executeQuery("SELECT COUNT(a), SUM(a) FROM t1");
            while (rs.next()) {
                int count = rs.getInt(1);
                int sum = rs.getInt(2);
                if (count != 256 || sum != 32640) {
                    System.out.print("Test FAILED: ");
                }
                System.out.println("Count: " + count + " Sum: " + sum);
            }
        }
        catch (SQLException sqle) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
            sqle.printStackTrace(System.out);
        }
    }
}

